/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerListener;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessComponentKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessImageProducer;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.UtilsKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0014J\u001a\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J(\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0007H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerListener;", "myModel", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;)V", "<set-?>", "", "alpha", "getAlpha", "()I", "", "brightness", "getBrightness", "()F", "hue", "getHue", "saturation", "getSaturation", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "commit", "", "paintComponent", "g", "Ljava/awt/Graphics;", "pickingColorChanged", "setHSBAValue", "h", "s", "b", "a", "intellij.android.core"})
public final class SaturationBrightnessComponent
extends JComponent
implements ColorPickerListener {
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private final ColorPickerModel myModel;

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    private final void handleMouseEvent(MouseEvent e, boolean commit) {
        int x = Math.max(0, Math.min(e.getX(), this.getSize().width));
        int y = Math.max(0, Math.min(e.getY(), this.getSize().height));
        float saturation = (float)x / (float)this.getSize().width;
        float brightness = 1.0f - (float)y / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        ((Function2)(commit ? new Function2<Color, Object, Unit>(this.myModel){

            public final void invoke(@NotNull Color p1, @Nullable Object p2) {
                ((ColorPickerModel)this.receiver).setColor(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ColorPickerModel.class);
            }

            public final String getName() {
                return "setColor";
            }

            public final String getSignature() {
                return "setColor(Ljava/awt/Color;Ljava/lang/Object;)V";
            }
        } : new Function2<Color, Object, Unit>(this.myModel){

            public final void invoke(@NotNull Color p1, @Nullable Object p2) {
                ((ColorPickerModel)this.receiver).setPickingColor(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ColorPickerModel.class);
            }

            public final String getName() {
                return "setPickingColor";
            }

            public final String getSignature() {
                return "setPickingColor(Ljava/awt/Color;Ljava/lang/Object;)V";
            }
        })).invoke((Object)new Color(argb, true), (Object)this);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return (Dimension)JBUI.size((int)300, (int)150);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return (Dimension)JBUI.size((int)150, (int)140);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Rectangle component = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Image image = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image, component.x, component.y, null);
        int knobX = Math.round(this.saturation * (float)component.width);
        int knobY = Math.round((float)component.height * (1.0f - this.brightness));
        g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        g.drawOval(knobX - JBUI.scale((int)4), knobY - JBUI.scale((int)4), JBUI.scale((int)8), JBUI.scale((int)8));
        g.drawOval(knobX - JBUI.scale((int)3), knobY - JBUI.scale((int)3), JBUI.scale((int)6), JBUI.scale((int)6));
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
        this.repaint();
    }

    @Override
    public void pickingColorChanged(@NotNull Color color, @Nullable Object source) {
        this.colorChanged(color, source);
    }

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        this.myModel = myModel;
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, false);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, false);
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, true);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.myModel.addListener(this);
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, MouseEvent e, boolean commit) {
        $this.handleMouseEvent(e, commit);
    }
}

