/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.groups;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroup;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceChooserGroups {
    private static final boolean FILTER_OUT_PRIVATE_ITEMS = true;
    private static ImmutableList<ResourceNamespace> SAMPLE_DATA_NS = ImmutableList.of((Object)ResourceNamespace.TOOLS, (Object)ResourceNamespace.TODO());
    private static final Comparator<ResourceChooserItem> ITEM_COMPARATOR = (resource1, resource2) -> {
        int framework2;
        int framework1 = resource1.isFramework() ? 1 : 0;
        int delta = framework1 - (framework2 = resource2.isFramework() ? 1 : 0);
        if (delta != 0) {
            return delta;
        }
        return resource1.getName().compareTo(resource2.getName());
    };
    private static final EnumSet<ResourceType> IMAGE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.COLOR);
    private static final Predicate<SampleDataResourceItem> ONLY_IMAGES_FILTER = item -> item.getContentType() == SampleDataResourceItem.ContentType.IMAGE;
    private static final Predicate<SampleDataResourceItem> NOT_IMAGES_FILTER = ONLY_IMAGES_FILTER.negate();

    private ResourceChooserGroups() {
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getFrameworkItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull ResourceRepository frameworkResources, @NotNull ResourceType asType) {
        HashMap<String, ArrayList<ResourceItem>> itemsByName = new HashMap<String, ArrayList<ResourceItem>>();
        Collection publicItems = frameworkResources.getPublicResources(ResourceNamespace.ANDROID, type);
        for (ResourceItem item : publicItems) {
            String name = item.getName();
            ArrayList<ResourceItem> list = (ArrayList<ResourceItem>)itemsByName.get(name);
            if (list == null) {
                list = new ArrayList<ResourceItem>();
                itemsByName.put(name, list);
            }
            list.add(item);
        }
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (Map.Entry entry : itemsByName.entrySet()) {
            List items2 = (List)entry.getValue();
            String resourceName = (String)entry.getKey();
            if (!includeFileResources && ((ResourceItem)items2.get(0)).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createFrameworkItem(asType, resourceName, items2));
        }
        return chooserItems.build();
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getProjectItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull LocalResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (String resourceName : repository.getResources(ResourceNamespace.TODO(), type).keySet()) {
            List<ResourceItem> items2;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items2 = repository.getResources(ResourceNamespace.TODO(), type, resourceName)).isEmpty() || !includeFileResources && items2.get(0).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createProjectItem(type, resourceName, items2));
        }
        return chooserItems.build();
    }

    @NotNull
    public static ResourceChooserGroup createResourceItemsGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, boolean framework, boolean includeFileResources) {
        assert (type != ResourceType.MIPMAP);
        ImmutableList.Builder items2 = ImmutableList.builder();
        if (framework) {
            ResourceRepository frameworkResources = ResourceRepositoryManager.getInstance(facet).getFrameworkResources(type == ResourceType.STRING);
            if (frameworkResources != null) {
                items2.addAll(ResourceChooserGroups.getFrameworkItems(type, includeFileResources, frameworkResources, type));
                if (type == ResourceType.DRAWABLE) {
                    items2.addAll(ResourceChooserGroups.getFrameworkItems(ResourceType.MIPMAP, includeFileResources, frameworkResources, type));
                }
            }
        } else {
            ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet);
            LocalResourceRepository appResources = repoManager.getAppResources();
            ResourceVisibilityLookup lookup = repoManager.getResourceVisibility();
            items2.addAll(ResourceChooserGroups.getProjectItems(type, includeFileResources, appResources, lookup));
            if (type == ResourceType.DRAWABLE) {
                items2.addAll(ResourceChooserGroups.getProjectItems(ResourceType.MIPMAP, includeFileResources, appResources, lookup));
            }
        }
        return new ResourceChooserGroup(label, type, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2.build()));
    }

    @NotNull
    public static ResourceChooserGroup createThemeAttributesGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet, @NotNull Collection<String> attrs) {
        ResourceVisibilityLookup lookup = ResourceRepositoryManager.getInstance(facet).getResourceVisibility();
        ArrayList<ResourceChooserItem.AttrItem> items2 = new ArrayList<ResourceChooserItem.AttrItem>();
        for (String name : attrs) {
            String simpleName;
            boolean framework = name.startsWith("android:");
            String string = simpleName = framework ? ResolutionUtils.getNameFromQualifiedName(name) : name;
            if (!framework && lookup != null && lookup.isPrivate(ResourceType.ATTR, simpleName)) continue;
            items2.add(new ResourceChooserItem.AttrItem(type, framework, simpleName));
        }
        return new ResourceChooserGroup("Theme attributes", type, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, items2));
    }

    @NotNull
    public static ResourceChooserGroup createSampleDataGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet) {
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet);
        Predicate<SampleDataResourceItem> filter2 = IMAGE_RESOURCE_TYPES.contains(type) ? ONLY_IMAGES_FILTER : NOT_IMAGES_FILTER;
        ImmutableList items2 = (ImmutableList)SAMPLE_DATA_NS.stream().flatMap(namespace -> repository.getResources((ResourceNamespace)namespace, ResourceType.SAMPLE_DATA).values().stream()).map(item -> (SampleDataResourceItem)item).filter(filter2).map(item -> new ResourceChooserItem.SampleDataItem((SampleDataResourceItem)item)).collect(ImmutableList.toImmutableList());
        return new ResourceChooserGroup("Sample data", ResourceType.SAMPLE_DATA, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2));
    }
}

