/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.icons;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.awt.Graphics;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncIcon
implements Icon {
    @NotNull
    private Icon myIcon;
    private final int myW;
    private final int myH;

    AsyncIcon(@NotNull CompletableFuture<? extends Icon> futureIcon, @NotNull Icon placeholderIcon, @Nullable Runnable onIconLoad) {
        this.myIcon = placeholderIcon;
        this.myW = placeholderIcon.getIconWidth();
        this.myH = placeholderIcon.getIconHeight();
        futureIcon.whenComplete((result2, e) -> {
            if (e != null) {
                Logger.getInstance(AsyncIcon.class).warn("Unable to load AsyncIcon", e);
                return;
            }
            if (result2 != null) {
                this.myIcon = result2;
            }
            if (onIconLoad != null) {
                onIconLoad.run();
            }
        });
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon2 = this.myIcon;
        assert (icon2.getIconWidth() == this.myW && icon2.getIconHeight() == this.myH);
        icon2.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.myW;
    }

    @Override
    public int getIconHeight() {
        return this.myH;
    }
}

