/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.util;

import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class SimpleTabUI
extends BasicTabbedPaneUI {
    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = JBUI.insets((int)8);
        this.selectedTabPadInsets = JBUI.emptyInsets();
        this.contentBorderInsets = JBUI.emptyInsets();
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        int thickness = JBUI.scale((int)1);
        g.setColor(OnePixelDivider.BACKGROUND);
        switch (tabPlacement) {
            case 2: {
                g.fillRect((x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - thickness, y, thickness, h);
                break;
            }
            case 4: {
                g.fillRect(x + (w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)), y, thickness, h);
                break;
            }
            case 3: {
                g.fillRect(x, y + (h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)), w, thickness);
                break;
            }
            default: {
                g.fillRect(x, (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - thickness, w, thickness);
            }
        }
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return super.getTabLabelShiftX(tabPlacement, tabIndex, false);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return super.getTabLabelShiftY(tabPlacement, tabIndex, false);
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon2, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        tabRect = new Rectangle(tabRect);
        tabRect.x += insets.left;
        tabRect.y += insets.top;
        tabRect.width = tabRect.width - insets.left - insets.right;
        tabRect.height = tabRect.height - insets.top - insets.bottom;
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon2, 0, 10, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                JBColor selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = JBColor.BLUE) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                UIUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, (Graphics)g, (String)title, (int)mnemIndex, (int)textRect.x, (int)(textRect.y + metrics.getAscent()));
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                UIUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, (Graphics)g, (String)title, (int)mnemIndex, (int)textRect.x, (int)(textRect.y + metrics.getAscent()));
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                UIUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, (Graphics)g, (String)title, (int)mnemIndex, (int)(textRect.x - 1), (int)(textRect.y + metrics.getAscent() - 1));
            }
        }
    }
}

