/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import icons.StudioIcons;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/actions/ShowFileInResourceManagerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "showThumbnailAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPsiDir", "Lcom/intellij/psi/PsiDirectory;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isSupportedInResManager", "", "isSupportedResource", "showResourceExplorer", "update", "intellij.android.core"})
public final class ShowFileInResourceManagerAction
extends DumbAwareAction {
    private final AnAction showThumbnailAction = ActionManager.getInstance().getAction("Images.ShowThumbnails");

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project != null && file != null && this.isSupportedInResManager(file, project)) {
                this.showResourceExplorer(project, file);
                return;
            }
            AnAction anAction = this.showThumbnailAction;
            if (anAction == null) break block1;
            anAction.actionPerformed(e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (this.isSupportedInResManager(file, project)) {
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
            } else {
                e.getPresentation().setEnabled(true);
            }
            e.getPresentation().setIcon(StudioIcons.Shell.ToolWindows.VISUAL_ASSETS);
            return;
        }
        if (this.showThumbnailAction != null) {
            e.getPresentation().setIcon(this.showThumbnailAction.getTemplatePresentation().getIcon());
            this.showThumbnailAction.update(e);
            e.getPresentation().setText(this.showThumbnailAction.getTemplatePresentation().getText());
        }
    }

    private final void showResourceExplorer(Project project, VirtualFile file) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Resources Explorer");
        AndroidFacet facet = AndroidFacet.getInstance(file, project);
        if (facet != null) {
            toolWindow.show(new Runnable(toolWindow, facet, file){
                final /* synthetic */ ToolWindow $toolWindow;
                final /* synthetic */ AndroidFacet $facet;
                final /* synthetic */ VirtualFile $file;

                public final void run() {
                    block1: {
                        ResourceExplorer resourceExplorer;
                        Content content = this.$toolWindow.getContentManager().getContent(0);
                        JComponent jComponent = content != null ? content.getComponent() : null;
                        if (!(jComponent instanceof ResourceExplorer)) {
                            jComponent = null;
                        }
                        ResourceExplorer resourceExplorer2 = resourceExplorer = (ResourceExplorer)jComponent;
                        if (resourceExplorer2 == null) break block1;
                        resourceExplorer2.selectAsset(this.$facet, this.$file);
                    }
                }
                {
                    this.$toolWindow = toolWindow;
                    this.$facet = androidFacet;
                    this.$file = virtualFile;
                }
            });
        }
    }

    private final boolean isSupportedInResManager(VirtualFile file, Project project) {
        if (file == null || project == null) {
            return false;
        }
        PsiDirectory psiDirectory = this.getPsiDir(file, project);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory dir = psiDirectory;
        return AndroidResourceUtil.isResourceDirectory(dir) || AndroidResourceUtil.isResourceSubdirectory(dir, null) && this.isSupportedResource(dir.getVirtualFile());
    }

    private final boolean isSupportedResource(VirtualFile file) {
        Object object = ResourceFolderType.getFolderType((String)file.getName());
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object folderName = object;
        return ArraysKt.contains((Object[])ResourceExplorerKt.getSUPPORTED_RESOURCES(), (Object)ResourceType.fromFolderName((String)folderName));
    }

    private final PsiDirectory getPsiDir(VirtualFile file, Project project) {
        Object object;
        if (file.isDirectory()) {
            object = PsiManager.getInstance((Project)project).findDirectory(file);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            object = psiFile != null ? psiFile.getContainingDirectory() : null;
        }
        return object;
    }

    public ShowFileInResourceManagerAction() {
        super("Show In Resource Manager", "Display selected file in the Resource Manager", null);
    }
}

