/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDialog;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDragTarget;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "setFacet", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "anyFileCanBeImported", "", "files", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "cleanUpOnLeave", "", "drop", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "getFiles", "hasImporterForFile", "file", "update", "updateDraggedImage", "image", "Ljava/awt/Image;", "dropPoint", "Ljava/awt/Point;", "imageOffset", "intellij.android.core"})
public final class ResourceImportDragTarget
implements DnDNativeTarget {
    @NotNull
    private AndroidFacet facet;
    private final ImportersProvider importersProvider;

    public void cleanUpOnLeave() {
    }

    public boolean update(@NotNull DnDEvent event) {
        if (FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event) && (SystemInfo.isMac || this.anyFileCanBeImported(this.getFiles(event)))) {
            event.setDropPossible(true, "Import Files in project resources");
            return false;
        }
        return true;
    }

    private final Sequence<File> getFiles(DnDEvent event) {
        DnDEvent dnDEvent = event;
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)FileCopyPasteUtil.getFileListFromAttachedObject((Object)(dnDEvent != null ? dnDEvent.getAttachedObject() : null))), (Function1)getFiles.1.INSTANCE);
    }

    private final boolean anyFileCanBeImported(Sequence<? extends File> files2) {
        boolean bl;
        block1: {
            Sequence<? extends File> $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                if (!this.hasImporterForFile(file)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasImporterForFile(File file) {
        Collection collection = this.importersProvider.getImportersForExtension(FilesKt.getExtension((File)file));
        return !collection.isEmpty();
    }

    public void drop(@NotNull DnDEvent event) {
        Sequence<DesignAsset> assetSets = ResourceImportManagerKt.findAllDesignAssets(this.getFiles(event), this.importersProvider);
        ResourceManagerTracking.INSTANCE.logAssetAddedViaDnd();
        new ResourceImportDialog(this.facet, assetSets).show();
    }

    public void updateDraggedImage(@Nullable Image image, @Nullable Point dropPoint, @Nullable Point imageOffset) {
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public final void setFacet(@NotNull AndroidFacet androidFacet) {
        this.facet = androidFacet;
    }

    public ResourceImportDragTarget(@NotNull AndroidFacet facet, @NotNull ImportersProvider importersProvider) {
        this.facet = facet;
        this.importersProvider = importersProvider;
    }
}

