/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u0019\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\"\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010#\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010$\u001a\u00020\f*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/model/ResourcePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "dependsOnAppCompat", "", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "getResourceUrl", "Lcom/android/resources/ResourceUrl;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "insertImageView", "", "resourceReference", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "caret", "Lcom/intellij/openapi/editor/Caret;", "isPasteEnabled", "isPastePossible", "pasteAtCaret", "type", "Lcom/android/resources/ResourceType;", "performForImageView", "performForXml", "performPaste", "processForAttribute", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "processForTag", "processForValue", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "replaceAtCaret", "setSrcAttribute", "selectStringFromOffset", "offset", "", "intellij.android.core"})
public final class ResourcePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Object object = CommonDataKeys.CARET.getData(dataContext);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Caret caret = (Caret)object;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        boolean $i$f$runReadAction = false;
        PsiElement psiElement = (PsiElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(psiFile2, caret){
            final /* synthetic */ PsiFile $psiFile$inlined;
            final /* synthetic */ Caret $caret$inlined;
            {
                this.$psiFile$inlined = psiFile;
                this.$caret$inlined = caret;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$psiFile$inlined.findElementAt(this.$caret$inlined.getOffset());
            }
        });
        FileType fileType = psiFile2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)XmlFileType.INSTANCE)) {
            this.performForXml(psiElement, dataContext, caret);
        }
    }

    private final void performForXml(PsiElement psiElement, DataContext dataContext, Caret caret) {
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        Object object = resourceUrl;
        if (object == null || (object = object.toString()) == null) {
            return;
        }
        Object resourceReference = object;
        if (psiElement instanceof PsiWhiteSpace && ResourceHelper.getFolderType(((PsiWhiteSpace)psiElement).getContainingFile()) == ResourceFolderType.LAYOUT) {
            ResourceManagerTracking.INSTANCE.logPasteOnBlank(resourceUrl.type);
            if (resourceUrl.type == ResourceType.DRAWABLE) {
                this.insertImageView((String)resourceReference, psiElement, caret);
                return;
            }
        }
        if (!(psiElement instanceof XmlElement)) {
            this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type);
            return;
        }
        PsiElement $receiver$iv = psiElement;
        boolean $i$f$parentOfType = false;
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttributeValue.class)});
        if (this.processForValue(xmlAttributeValue, caret, (String)resourceReference)) {
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(resourceUrl.type);
            return;
        }
        PsiElement $receiver$iv2 = psiElement;
        boolean $i$f$parentOfType2 = false;
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv2, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)});
        if (this.processForAttribute(xmlAttribute, caret, (String)resourceReference)) {
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(resourceUrl.type);
            return;
        }
        PsiElement $receiver$iv3 = psiElement;
        boolean $i$f$parentOfType3 = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv3, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlTag.class)});
        if (this.processForTag(xmlTag, caret, (String)resourceReference)) {
            ResourceManagerTracking.INSTANCE.logPasteOnXmlTag(resourceUrl.type);
            return;
        }
        this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type);
    }

    private final void insertImageView(String resourceReference, PsiElement psiElement, Caret caret) {
        Object element$iv;
        boolean dependsOnAppCompat;
        XmlTag parent;
        block2: {
            PsiElement $receiver$iv = psiElement;
            boolean $i$f$parentOfType = false;
            XmlTag xmlTag = (XmlTag)PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlTag.class)});
            if (xmlTag == null) {
                return;
            }
            parent = xmlTag;
            dependsOnAppCompat = this.dependsOnAppCompat(parent);
            Object[] $receiver$iv2 = parent.getChildren();
            Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv2))).iterator();
            while (iterator.hasNext()) {
                int index$iv = ((Number)iterator.next()).intValue();
                Object it = element$iv = $receiver$iv2[index$iv];
                boolean bl = false;
                if (!(it.getTextRange().getStartOffset() < caret.getOffset())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object before = element$iv;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, parent, (PsiElement)before, dependsOnAppCompat, resourceReference){
            final /* synthetic */ ResourcePasteProvider this$0;
            final /* synthetic */ XmlTag $parent$inlined;
            final /* synthetic */ PsiElement $before$inlined;
            final /* synthetic */ boolean $dependsOnAppCompat$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.this$0 = resourcePasteProvider;
                this.$parent$inlined = xmlTag;
                this.$before$inlined = psiElement;
                this.$dependsOnAppCompat$inlined = bl;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                XmlTag childTag;
                boolean bl = false;
                PsiElement psiElement = this.$parent$inlined.addAfter((PsiElement)this.$parent$inlined.createChildTag("ImageView", this.$parent$inlined.getNamespace(), null, false), this.$before$inlined);
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                }
                XmlTag $receiver = childTag = (XmlTag)psiElement;
                boolean bl2 = false;
                $receiver.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
                $receiver.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
                ResourcePasteProvider.access$setSrcAttribute(this.this$0, this.$dependsOnAppCompat$inlined, $receiver, this.$resourceReference$inlined);
                $receiver.collapseIfEmpty();
                TemplateUtils.reformatAndRearrange(this.$parent$inlined.getProject(), (PsiElement)$receiver);
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean processForTag(XmlTag xmlTag, Caret caret, String resourceReference) {
        XmlTag xmlTag2 = xmlTag;
        if (xmlTag2 == null) return false;
        String string = xmlTag2.getName();
        if (string == null) return false;
        String string2 = string;
        switch (string2.hashCode()) {
            case 1125864064: {
                if (!string2.equals("ImageView")) return false;
                boolean bl = this.performForImageView(xmlTag, resourceReference);
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean processForAttribute(XmlAttribute xmlAttribute, Caret caret, String resourceReference) {
        block1: {
            int n;
            if (xmlAttribute == null) {
                return false;
            }
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(xmlAttribute, resourceReference){
                final /* synthetic */ XmlAttribute $xmlAttribute$inlined;
                final /* synthetic */ String $resourceReference$inlined;
                {
                    this.$xmlAttribute$inlined = xmlAttribute;
                    this.$resourceReference$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$xmlAttribute$inlined.setValue(this.$resourceReference$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
            XmlAttributeValue xmlAttributeValue = xmlAttribute.getValueElement();
            if (xmlAttributeValue == null || (xmlAttributeValue = xmlAttributeValue.getValueTextRange()) == null) break block1;
            int it = n = xmlAttributeValue.getStartOffset();
            boolean bl = false;
            this.selectStringFromOffset(caret, resourceReference, it);
        }
        return true;
    }

    private final boolean processForValue(XmlAttributeValue xmlAttributeValue, Caret caret, String resourceReference) {
        if (xmlAttributeValue == null) {
            return false;
        }
        PsiElement psiElement = xmlAttributeValue.getParent();
        if (!(psiElement instanceof XmlAttribute)) {
            psiElement = null;
        }
        this.processForAttribute((XmlAttribute)psiElement, caret, resourceReference);
        return true;
    }

    private final void pasteAtCaret(Caret caret, String resourceReference, ResourceType type) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(caret, resourceReference){
            final /* synthetic */ Caret $caret$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$caret$inlined = caret;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                this.$caret$inlined.getEditor().getDocument().insertString(this.$caret$inlined.getOffset(), (CharSequence)this.$resourceReference$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        this.selectStringFromOffset(caret, resourceReference, caret.getOffset());
        ResourceManagerTracking.INSTANCE.logPasteUrlText(type);
    }

    static /* synthetic */ void pasteAtCaret$default(ResourcePasteProvider resourcePasteProvider, Caret caret, String string, ResourceType resourceType, int n, Object object) {
        if ((n & 4) != 0) {
            resourceType = null;
        }
        resourcePasteProvider.pasteAtCaret(caret, string, resourceType);
    }

    private final void replaceAtCaret(Caret caret, PsiElement psiElement, String resourceReference) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(caret, psiElement, resourceReference){
            final /* synthetic */ Caret $caret$inlined;
            final /* synthetic */ PsiElement $psiElement$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$caret$inlined = caret;
                this.$psiElement$inlined = psiElement;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                this.$caret$inlined.getEditor().getDocument().replaceString(this.$psiElement$inlined.getTextRange().getStartOffset(), this.$psiElement$inlined.getTextRange().getEndOffset(), (CharSequence)this.$resourceReference$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        this.selectStringFromOffset(caret, resourceReference, psiElement.getTextRange().getStartOffset());
    }

    private final void selectStringFromOffset(@NotNull Caret $receiver, String resourceReference, int offset) {
        $receiver.setSelection(offset, offset + resourceReference.length());
        $receiver.moveToOffset(offset + resourceReference.length());
    }

    private final boolean performForImageView(XmlTag xmlTag, String resourceReference) {
        boolean dependsOnAppCompat = this.dependsOnAppCompat(xmlTag);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, dependsOnAppCompat, xmlTag, resourceReference){
            final /* synthetic */ ResourcePasteProvider this$0;
            final /* synthetic */ boolean $dependsOnAppCompat$inlined;
            final /* synthetic */ XmlTag $xmlTag$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.this$0 = resourcePasteProvider;
                this.$dependsOnAppCompat$inlined = bl;
                this.$xmlTag$inlined = xmlTag;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                ResourcePasteProvider.access$setSrcAttribute(this.this$0, this.$dependsOnAppCompat$inlined, this.$xmlTag$inlined, this.$resourceReference$inlined);
                TemplateUtils.reformatAndRearrange(this.$xmlTag$inlined.getProject(), (PsiElement)this.$xmlTag$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        return true;
    }

    private final void setSrcAttribute(boolean dependsOnAppCompat, XmlTag xmlTag, String resourceReference) {
        if (dependsOnAppCompat) {
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", resourceReference);
            xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", null);
        } else {
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", null);
            xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", resourceReference);
        }
    }

    private final boolean dependsOnAppCompat(XmlTag xmlTag) {
        boolean $i$f$runReadAction = false;
        return Intrinsics.areEqual((Object)((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(xmlTag){
            final /* synthetic */ XmlTag $xmlTag$inlined;
            {
                this.$xmlTag$inlined = xmlTag;
            }

            public final T compute() {
                boolean bl = false;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$xmlTag$inlined));
                return (T)(module != null ? Boolean.valueOf(DependencyManagementUtil.dependsOnAppCompat(module)) : null);
            }
        })), (Object)true);
    }

    private final ResourceUrl getResourceUrl(DataContext dataContext) {
        Object object = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return (ResourceUrl)(object != null && (object = (Transferable)object.produce()) != null ? object.getTransferData(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : null);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (!((Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get()).booleanValue()) {
            return false;
        }
        Object object = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return object != null && (object = (Transferable)object.produce()) != null ? object.isDataFlavorSupported(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.isPastePossible(dataContext);
    }

    public static final /* synthetic */ void access$setSrcAttribute(ResourcePasteProvider $this, boolean dependsOnAppCompat, XmlTag xmlTag, String resourceReference) {
        $this.setSrcAttribute(dependsOnAppCompat, xmlTag, resourceReference);
    }
}

