/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcemanager.ImageCache;
import com.android.tools.idea.ui.resourcemanager.explorer.DesignAssetCellRendererKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderer;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProvider$WhenMappings;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProviderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ui.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012F\b\u0002\u0010\b\u001a@\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0018\u00010\tj\u0002`\u0012\u00a2\u0006\u0002\u0010\u0013J>\u0010\"\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0$2\u0006\u0010'\u001a\u00020\n2\b\b\u0002\u0010(\u001a\u00020\u001dH\u0002J$\u0010)\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J<\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0$H\u0016J\u001c\u00101\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0002J\"\u00105\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0015H\u0002RL\u0010\b\u001a@\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0018\u00010\tj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/DrawableIconProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "imageCache", "Lcom/android/tools/idea/ui/resourcemanager/ImageCache;", "alternateImageProvider", "Lkotlin/Function2;", "Ljava/awt/Dimension;", "Lkotlin/ParameterName;", "name", "dimension", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "designAsset", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AsyncImageProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/ResourceResolver;Lcom/android/tools/idea/ui/resourcemanager/ImageCache;Lkotlin/jvm/functions/Function2;)V", "contentRatio", "", "imageIcon", "Ljavax/swing/ImageIcon;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "setSupportsTransparency", "(Z)V", "fetchImage", "refreshCallBack", "Lkotlin/Function0;", "", "isStillVisible", "targetSize", "forceImageRender", "getDrawableImage", "getIcon", "assetToRender", "width", "", "height", "refreshCallback", "shouldBeRendered", "getLayoutImage", "getScale", "target", "source", "renderImage", "scaleToFitIfNeeded", "image", "shouldScale", "scale", "intellij.android.core"})
public final class DrawableIconProvider
implements AssetIconProvider {
    private final ImageIcon imageIcon;
    private final double contentRatio = 0.1;
    private boolean supportsTransparency;
    @NotNull
    private final Project project;
    private final AndroidFacet facet;
    private final ResourceResolver resourceResolver;
    private final ImageCache imageCache;
    private final Function2<Dimension, DesignAsset, CompletableFuture<Image>> alternateImageProvider;

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    public void setSupportsTransparency(boolean bl) {
        this.supportsTransparency = bl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final CompletableFuture<? extends Image> getDrawableImage(Dimension dimension2, DesignAsset designAsset) {
        ResourceValue resourceValue2 = DesignAssetKt.resolveValue(this.resourceResolver, designAsset);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue resolveValue = resourceValue2;
        VirtualFile virtualFile = ResourceHelper.resolveDrawable((RenderResources)this.resourceResolver, resolveValue, this.project);
        if (virtualFile == null) {
            virtualFile = designAsset.getFile();
        }
        VirtualFile file = virtualFile;
        return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2);
    }

    private final CompletableFuture<? extends Image> getLayoutImage(DesignAsset designAsset) {
        VirtualFile file = designAsset.getFile();
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.facet.getModule().getProject(), file);
        return psiFile instanceof XmlFile ? CompletableFuture.supplyAsync((Supplier)new Supplier<Configuration>(this, file){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ VirtualFile $file;

            @NotNull
            public final Configuration get() {
                return ConfigurationManager.getOrCreateInstance(DrawableIconProvider.access$getFacet$p(this.this$0)).getConfiguration(this.$file);
            }
            {
                this.this$0 = drawableIconProvider;
                this.$file = virtualFile;
            }
        }, PooledThreadExecutor.INSTANCE).thenCompose(new Function<T, CompletionStage<U>>(this, psiFile){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ PsiFile $psiFile;

            @NotNull
            public final CompletableFuture<BufferedImage> apply(Configuration configuration) {
                return LayoutRenderer.Companion.getInstance(DrawableIconProvider.access$getFacet$p(this.this$0)).getLayoutRender((XmlFile)this.$psiFile, configuration);
            }
            {
                this.this$0 = drawableIconProvider;
                this.$psiFile = psiFile;
            }
        }) : null;
    }

    private final CompletableFuture<? extends Image> renderImage(Dimension dimension2, DesignAsset designAsset) {
        Object object;
        Object object2 = this.alternateImageProvider;
        if (object2 == null || (object2 = (CompletableFuture)object2.invoke((Object)dimension2, (Object)designAsset)) == null) {
            switch (DrawableIconProvider$WhenMappings.$EnumSwitchMapping$0[designAsset.getType().ordinal()]) {
                case 1: {
                    object2 = this.getLayoutImage(designAsset);
                    break;
                }
                case 2: 
                case 3: {
                    object2 = this.getDrawableImage(dimension2, designAsset);
                    break;
                }
                default: {
                    object2 = object = null;
                }
            }
        }
        if (object2 == null) {
            object = CompletableFuture.completedFuture(null);
        }
        return object;
    }

    @Override
    @NotNull
    public ImageIcon getIcon(@NotNull DesignAsset assetToRender, int width, int height, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        if (height > 0 && width > 0) {
            Dimension targetSize = new Dimension(width, height);
            Image image = DrawableIconProvider.fetchImage$default(this, assetToRender, refreshCallback, shouldBeRendered, targetSize, false, 16, null);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            double scale = this.getScale(targetSize, new Dimension(imageWidth, imageHeight));
            if (Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getEMPTY_ICON()) ^ true && Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getERROR_ICON()) ^ true && this.shouldScale(scale)) {
                BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image);
                image = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage, (double)scale, (double)scale);
                this.fetchImage(assetToRender, refreshCallback, shouldBeRendered, targetSize, true);
            }
            this.imageIcon.setImage(image);
        } else {
            this.imageIcon.setImage(DesignAssetCellRendererKt.getEMPTY_ICON());
        }
        return this.imageIcon;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        double d2 = 1.0 + this.contentRatio;
        double d3 = scale;
        return !(d3 >= d) || !(d3 <= d2);
    }

    private final double getScale(Dimension target, Dimension source) {
        double xScale = (double)target.width / source.getWidth();
        double yScale = (double)target.height / source.getHeight();
        return Math.min(xScale, yScale);
    }

    private final Image fetchImage(DesignAsset designAsset, Function0<Unit> refreshCallBack, Function0<Boolean> isStillVisible, Dimension targetSize, boolean forceImageRender) {
        return ImageCache.computeAndGet$default(this.imageCache, designAsset, DesignAssetCellRendererKt.getEMPTY_ICON(), forceImageRender, refreshCallBack, null, (Function0)new Function0<CompletableFuture<? extends Image>>(this, isStillVisible, targetSize, designAsset){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ Function0 $isStillVisible;
            final /* synthetic */ Dimension $targetSize;
            final /* synthetic */ DesignAsset $designAsset;

            @NotNull
            public final CompletableFuture<? extends Image> invoke() {
                return (Boolean)this.$isStillVisible.invoke() != false ? ((CompletableFuture)((CompletableFuture)DrawableIconProvider.access$renderImage(this.this$0, this.$targetSize, this.$designAsset).thenApplyAsync((Function)fetchImage.1.INSTANCE)).thenApply(new Function<T, U>(this){
                    final /* synthetic */ fetchImage.1 this$0;

                    @NotNull
                    public final Image apply(Image image) {
                        return DrawableIconProvider.access$scaleToFitIfNeeded(this.this$0.this$0, image, this.this$0.$targetSize);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })).exceptionally(new Function<Throwable, Image>(this){
                    final /* synthetic */ fetchImage.1 this$0;

                    @NotNull
                    public final BufferedImage apply(Throwable throwable) {
                        DrawableIconProviderKt.access$getLOG$p().error("Error while rendering " + this.this$0.$designAsset, throwable);
                        return DesignAssetCellRendererKt.getERROR_ICON();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : CompletableFuture.completedFuture(null);
            }
            {
                this.this$0 = drawableIconProvider;
                this.$isStillVisible = function0;
                this.$targetSize = dimension2;
                this.$designAsset = designAsset;
                super(0);
            }
        }, 16, null);
    }

    static /* synthetic */ Image fetchImage$default(DrawableIconProvider drawableIconProvider, DesignAsset designAsset, Function0 function0, Function0 function02, Dimension dimension2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return drawableIconProvider.fetchImage(designAsset, (Function0<Unit>)function0, (Function0<Boolean>)function02, dimension2, bl);
    }

    private final Image scaleToFitIfNeeded(Image image, Dimension targetSize) {
        Dimension imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double scale = this.getScale(targetSize, imageSize);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)imageSize.width * scale);
            int newHeight = (int)((double)imageSize.height * scale);
            if (newWidth > 0 && newHeight > 0) {
                return ImageUtil.toBufferedImage((Image)image).getScaledInstance(newWidth, newHeight, 4);
            }
        }
        return image;
    }

    public DrawableIconProvider(@NotNull AndroidFacet facet, @NotNull ResourceResolver resourceResolver, @NotNull ImageCache imageCache, @Nullable Function2<? super Dimension, ? super DesignAsset, ? extends CompletableFuture<Image>> alternateImageProvider) {
        this.facet = facet;
        this.resourceResolver = resourceResolver;
        this.imageCache = imageCache;
        this.alternateImageProvider = alternateImageProvider;
        this.imageIcon = new ImageIcon(DesignAssetCellRendererKt.getEMPTY_ICON());
        this.contentRatio = 0.1;
        this.supportsTransparency = true;
        this.project = this.facet.getModule().getProject();
    }

    public /* synthetic */ DrawableIconProvider(AndroidFacet androidFacet, ResourceResolver resourceResolver, ImageCache imageCache, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function2 = null;
        }
        this(androidFacet, resourceResolver, imageCache, (Function2<? super Dimension, ? super DesignAsset, ? extends CompletableFuture<Image>>)function2);
    }

    public static final /* synthetic */ AndroidFacet access$getFacet$p(DrawableIconProvider $this) {
        return $this.facet;
    }

    public static final /* synthetic */ CompletableFuture access$renderImage(DrawableIconProvider $this, Dimension dimension2, DesignAsset designAsset) {
        return $this.renderImage(dimension2, designAsset);
    }

    public static final /* synthetic */ Image access$scaleToFitIfNeeded(DrawableIconProvider $this, Image image, Dimension targetSize) {
        return $this.scaleToFitIfNeeded(image, targetSize);
    }
}

