/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.TransparentModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FillModel
implements TransparentModel {
    @NotNull
    private Color myColor;
    @Nullable
    private GradientModel myGradientModel;
    private double myOpacity;

    public FillModel(@NotNull Color color, @Nullable GradientModel gradientModel, double opacity) {
        this.myColor = color;
        this.myGradientModel = gradientModel;
        this.myOpacity = opacity;
    }

    @NotNull
    public Color getColor() {
        return this.myColor;
    }

    @Nullable
    public GradientModel getGradientModel() {
        return this.myGradientModel;
    }

    @Override
    public double getOpacity() {
        return this.myOpacity;
    }

    @Override
    public void applyOpacity(double opacity) {
        this.myOpacity *= opacity;
        GradientModel gradient = this.getGradientModel();
        if (gradient != null) {
            GradientStopModel[] stopModels;
            for (GradientStopModel gradientStop : stopModels = gradient.getGradientStopModels()) {
                gradientStop.setColor(StyleModel.addAlphaToColor(gradientStop.getColor(), this.myOpacity));
            }
        } else {
            this.myColor = StyleModel.addAlphaToColor(this.myColor, this.myOpacity);
        }
    }
}

