/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolInstance;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.google.common.collect.ImmutableList;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

public class SymbolModel {
    @NotNull
    ImmutableList<ShapeModel> myShapeModels;
    @NotNull
    SketchSymbolMaster mySymbolMaster;
    @NotNull
    SketchSymbolInstance mySymbolInstance;

    public SymbolModel(@NotNull ImmutableList<ShapeModel> shapeModels, @NotNull SketchSymbolMaster symbolMaster) {
        this.myShapeModels = shapeModels;
        this.mySymbolMaster = symbolMaster;
    }

    public void applyProperties(@NotNull InheritedProperties properties) {
        for (ShapeModel shapeModel : this.myShapeModels) {
            shapeModel.applyOpacity(properties.getInheritedOpacity());
            shapeModel.applyTransformations(properties);
        }
    }

    @NotNull
    public ImmutableList<ShapeModel> getShapeModels() {
        return this.myShapeModels;
    }

    private double getScaleRatioX() {
        return this.mySymbolInstance.getFrame().getWidth() / this.mySymbolMaster.getFrame().getWidth();
    }

    private double getScaleRatioY() {
        return this.mySymbolInstance.getFrame().getHeight() / this.mySymbolMaster.getFrame().getHeight();
    }

    private boolean isInstanceScaled() {
        return Double.compare(this.getScaleRatioX(), 1.0) != 0 || Double.compare(this.getScaleRatioY(), 1.0) != 0;
    }

    public void setSymbolInstance(@NotNull SketchSymbolInstance symbolInstance) {
        this.mySymbolInstance = symbolInstance;
    }

    public void scaleShapes() {
        if (this.isInstanceScaled()) {
            for (ShapeModel shapeModel : this.myShapeModels) {
                ResizingConstraint constraint = shapeModel.getResizingConstraint();
                if (constraint.isNoConstraint()) {
                    shapeModel.scale(this.getScaleRatioX(), this.getScaleRatioY());
                } else if (constraint.isOnlyConstraintWidth()) {
                    shapeModel.scale(1.0, this.getScaleRatioY());
                } else if (constraint.isOnlyConstraintHeight()) {
                    shapeModel.scale(this.getScaleRatioX(), 1.0);
                }
                AffineTransform transform2 = new AffineTransform();
                transform2.scale(this.getScaleRatioX(), this.getScaleRatioY());
                Point2D.Double newPoint = new Point2D.Double();
                transform2.transform(shapeModel.getShapeFrameLocation(), newPoint);
                shapeModel.translateTo(newPoint.getX(), newPoint.getY());
            }
        }
    }
}

