/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.ColorDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.ConstraintDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.PointDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchDocumentDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchLayerDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchMetaDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchParser {
    private static final Logger LOG = Logger.getInstance(SketchParser.class);
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SketchDocument.class, (Object)new SketchDocumentDeserializer()).registerTypeAdapter(SketchMeta.class, (Object)new SketchMetaDeserializer()).registerTypeAdapter(SketchLayer.class, (Object)new SketchLayerDeserializer()).registerTypeAdapter(Color.class, (Object)new ColorDeserializer()).registerTypeAdapter(SketchPoint2D.class, (Object)new PointDeserializer()).registerTypeAdapter(ResizingConstraint.class, (Object)new ConstraintDeserializer()).create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SketchFile read(@NotNull String path) {
        try (ZipFile zip = new ZipFile(path);){
            SketchFile sketchFile2 = new SketchFile();
            Enumeration<? extends ZipEntry> e = zip.entries();
            block21: while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!FilenameUtils.getExtension((String)entryName).equals("json")) continue;
                switch (entryName) {
                    case "document.json": {
                        SketchDocument document = (SketchDocument)SketchParser.parseJson(zip.getInputStream(entry), SketchDocument.class);
                        if (document == null) continue block21;
                        sketchFile2.setDocument(document);
                        continue block21;
                    }
                    case "meta.json": {
                        SketchMeta meta = (SketchMeta)SketchParser.parseJson(zip.getInputStream(entry), SketchMeta.class);
                        if (meta == null) continue block21;
                        sketchFile2.setMeta(meta);
                        continue block21;
                    }
                    case "user.json": {
                        continue block21;
                    }
                }
                SketchPage page = (SketchPage)SketchParser.parseJson(zip.getInputStream(entry), SketchPage.class);
                if (page == null) continue;
                sketchFile2.addPage(page);
            }
            SketchFile sketchFile = sketchFile2;
            return sketchFile;
        }
        catch (Exception e) {
            LOG.warn("Failed to read from sketch file: " + path + ".", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T parseJson(@NotNull InputStream in, @NotNull Type typeOfT) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            Object object = gson.fromJson((Reader)reader, typeOfT);
            return (T)object;
        }
        catch (Exception e) {
            LOG.warn("Could not read JSON from input stream.", (Throwable)e);
            return null;
        }
    }
}

