/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public class ConstraintDeserializer
implements JsonDeserializer<ResizingConstraint> {
    public static final int WIDTH_HEIGHT_CONSTRAINT = 44;
    public static final int HEIGHT_CONSTRAINT = 47;
    public static final int WIDTH_CONSTRAINT = 60;
    public static final int NO_CONSTRAINT = 63;

    public ResizingConstraint deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        boolean constrainHeight;
        boolean constrainWidth;
        int constraint = json.getAsInt();
        switch (constraint) {
            case 44: {
                constrainWidth = true;
                constrainHeight = true;
                break;
            }
            case 47: {
                constrainWidth = false;
                constrainHeight = true;
                break;
            }
            case 60: {
                constrainWidth = true;
                constrainHeight = false;
                break;
            }
            default: {
                constrainWidth = false;
                constrainHeight = false;
            }
        }
        return new ResizingConstraint(constrainWidth, constrainHeight);
    }
}

