/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.analytics;

import com.android.sdklib.devices.State;
import com.android.tools.idea.common.analytics.UsageTrackerUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.google.wireless.android.sdk.stats.LayoutFavoriteAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.google.wireless.android.sdk.stats.SearchOption;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerImpl
implements NlUsageTracker {
    private static final Pattern STYLE_PATTERN = Pattern.compile("style=\"(.*)\"");
    private static final Pattern INPUT_STYLE_PATTERN = Pattern.compile("android:inputType=\"(.*)\"");
    private static final Pattern ORIENTATION_PATTERN = Pattern.compile("android:orientation=\"(.*)\"");
    private static final Map<String, LayoutPaletteEvent.ViewOption> PALETTE_VIEW_OPTION_MAP = ImmutableMap.builder().put((Object)"textPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD).put((Object)"numberPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD_NUMERIC).put((Object)"textEmailAddress", (Object)LayoutPaletteEvent.ViewOption.EMAIL).put((Object)"phone", (Object)LayoutPaletteEvent.ViewOption.PHONE).put((Object)"textPostalAddress", (Object)LayoutPaletteEvent.ViewOption.POSTAL_ADDRESS).put((Object)"textMultiLine", (Object)LayoutPaletteEvent.ViewOption.MULTILINE_TEXT).put((Object)"time", (Object)LayoutPaletteEvent.ViewOption.TIME_EDITOR).put((Object)"date", (Object)LayoutPaletteEvent.ViewOption.DATE_EDITOR).put((Object)"number", (Object)LayoutPaletteEvent.ViewOption.NUMBER).put((Object)"numberSigned", (Object)LayoutPaletteEvent.ViewOption.SIGNED_NUMBER).put((Object)"numberDecimal", (Object)LayoutPaletteEvent.ViewOption.DECIMAL_NUMBER).build();
    private static final int LOG_RENDER_PERCENT = 10;
    private static final Random sRandom = new Random();
    private final Executor myExecutor;
    private final WeakReference<DesignSurface> myDesignSurfaceRef;
    private final Consumer<AndroidStudioEvent.Builder> myEventLogger;

    NlUsageTrackerImpl(@NotNull Executor executor, @Nullable DesignSurface surface, @NotNull Consumer<AndroidStudioEvent.Builder> eventLogger) {
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference<DesignSurface>(surface);
        this.myEventLogger = eventLogger;
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface surface) {
        Configuration configuration;
        LayoutEditorState.Builder builder = LayoutEditorState.newBuilder();
        if (surface == null) {
            return builder.build();
        }
        if (surface.getLayoutType() instanceof LayoutEditorFileType) {
            builder.setType(((LayoutEditorFileType)surface.getLayoutType()).getLayoutEditorStateType());
        }
        double scale = surface.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder.setConfigZoomLevel((int)(scale * 100.0));
        }
        if (surface instanceof NlDesignSurface) {
            builder.setMode(((NlDesignSurface)surface).isPreviewSurface() ? LayoutEditorState.Mode.PREVIEW_MODE : LayoutEditorState.Mode.DESIGN_MODE);
            switch (((NlDesignSurface)surface).getSceneMode()) {
                case SCREEN_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.SCREEN_SURFACE);
                    break;
                }
                case BLUEPRINT_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BLUEPRINT_SURFACE);
                    break;
                }
                case BOTH: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BOTH);
                }
            }
        }
        return builder.build();
    }

    boolean shouldLog(int percent) {
        return sRandom.nextInt(100) >= 100 - percent - 1;
    }

    private void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        try {
            this.myExecutor.execute(() -> {
                LayoutEditorEvent.Builder builder = LayoutEditorEvent.newBuilder().setType(eventType).setState(NlUsageTrackerImpl.getState((DesignSurface)((Object)((Object)this.myDesignSurfaceRef.get()))));
                if (consumer != null) {
                    consumer.accept(builder);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder.build());
                this.myEventLogger.accept(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        assert (!LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logDropFromPalette";
        assert (!LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logPropertyChange";
        assert (!LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE.equals((Object)eventType)) : "FAVORITE_CHANGE actions should be logged through logFavoritesChange";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable LayoutEditorRenderResult.Trigger trigger, @NotNull RenderResult result2, long totalRenderTimeMs) {
        if (!this.shouldLog(10)) {
            return;
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.RENDER, event -> {
            LayoutEditorRenderResult.Builder builder = LayoutEditorRenderResult.newBuilder().setResultCode(result2.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(totalRenderTimeMs);
            if (trigger != null) {
                builder.setTrigger(trigger);
            }
            builder.setComponentCount((int)result2.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel((EditorDesignSurface)((Object)((Object)this.myDesignSurfaceRef.get())), result2, null);
            builder.setTotalIssueCount(errorModel.getIssues().size());
            if (!errorModel.getIssues().isEmpty()) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue2 : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.getName().equals(issue2.getSeverity().getName())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue2.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            event.setRenderResult(builder.build());
        });
    }

    @Override
    public void logDropFromPalette(@NotNull String viewTagName, @NotNull String representation, @NotNull String selectedGroup, int filterMatches) {
        LayoutPaletteEvent.Builder builder = LayoutPaletteEvent.newBuilder().setView(UsageTrackerUtil.convertTagName(viewTagName)).setViewOption(NlUsageTrackerImpl.convertViewOption(viewTagName, representation)).setSelectedGroup(NlUsageTrackerImpl.convertGroupName(selectedGroup)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE, event -> event.setPaletteEvent(builder));
    }

    @Override
    public void logPropertyChange(@NotNull NlProperty property2, @NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode, int filterMatches) {
        LayoutAttributeChangeEvent.Builder builder = LayoutAttributeChangeEvent.newBuilder().setAttribute(UsageTrackerUtil.convertAttribute(property2)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches)).setViewType(NlUsageTrackerImpl.convertPropertiesMode(propertiesMode));
        for (NlComponent component : property2.getComponents()) {
            builder.addView(UsageTrackerUtil.convertTagName(component.getTagName()));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder));
    }

    @Override
    public void logPropertyChange(@NotNull NelePropertyItem property2, int filterMatches) {
        LayoutAttributeChangeEvent.Builder builder = LayoutAttributeChangeEvent.newBuilder().setAttribute(UsageTrackerUtil.convertAttribute(property2)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        for (NlComponent component : property2.getComponents()) {
            builder.addView(UsageTrackerUtil.convertTagName(component.getTagName()));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder));
    }

    @Override
    public void logFavoritesChange(@NotNull String addedPropertyName, @NotNull String removedPropertyName, @NotNull List<String> currentFavorites, @NotNull AndroidFacet facet) {
        LayoutFavoriteAttributeChangeEvent.Builder builder = LayoutFavoriteAttributeChangeEvent.newBuilder();
        if (!addedPropertyName.isEmpty()) {
            builder.setAdded(UsageTrackerUtil.convertAttribute(addedPropertyName, facet));
        }
        if (!removedPropertyName.isEmpty()) {
            builder.setRemoved(UsageTrackerUtil.convertAttribute(removedPropertyName, facet));
        }
        for (String propertyName : currentFavorites) {
            builder.addActive(UsageTrackerUtil.convertAttribute(propertyName, facet));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE, event -> event.setFavoriteChangeEvent(builder));
    }

    @NotNull
    static LayoutPaletteEvent.ViewGroup convertGroupName(@NotNull String groupName) {
        switch (groupName) {
            case "All": {
                return LayoutPaletteEvent.ViewGroup.ALL_GROUPS;
            }
            case "All Results": {
                return LayoutPaletteEvent.ViewGroup.ALL_RESULTS;
            }
            case "Common": {
                return LayoutPaletteEvent.ViewGroup.COMMON;
            }
            case "Buttons": {
                return LayoutPaletteEvent.ViewGroup.BUTTONS;
            }
            case "Widgets": {
                return LayoutPaletteEvent.ViewGroup.WIDGETS;
            }
            case "Text": {
                return LayoutPaletteEvent.ViewGroup.TEXT;
            }
            case "Layouts": {
                return LayoutPaletteEvent.ViewGroup.LAYOUTS;
            }
            case "Containers": {
                return LayoutPaletteEvent.ViewGroup.CONTAINERS;
            }
            case "Images": {
                return LayoutPaletteEvent.ViewGroup.IMAGES;
            }
            case "Date": {
                return LayoutPaletteEvent.ViewGroup.DATES;
            }
            case "Transitions": {
                return LayoutPaletteEvent.ViewGroup.TRANSITIONS;
            }
            case "Advanced": {
                return LayoutPaletteEvent.ViewGroup.ADVANCED;
            }
            case "Google": {
                return LayoutPaletteEvent.ViewGroup.GOOGLE;
            }
            case "Design": {
                return LayoutPaletteEvent.ViewGroup.DESIGN;
            }
            case "AppCompat": {
                return LayoutPaletteEvent.ViewGroup.APP_COMPAT;
            }
            case "Legacy": {
                return LayoutPaletteEvent.ViewGroup.LEGACY;
            }
        }
        return LayoutPaletteEvent.ViewGroup.CUSTOM;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertViewOption(@NotNull String tagName, @NotNull String representation) {
        switch (tagName) {
            case "ProgressBar": {
                return NlUsageTrackerImpl.convertProgressBarViewOption(representation);
            }
            case "SeekBar": {
                return NlUsageTrackerImpl.convertSeekBarViewOption(representation);
            }
            case "EditText": {
                return NlUsageTrackerImpl.convertEditTextViewOption(representation);
            }
            case "LinearLayout": {
                return NlUsageTrackerImpl.convertLinearLayoutViewOption(representation);
            }
        }
        return LayoutPaletteEvent.ViewOption.NORMAL;
    }

    @NotNull
    static LayoutAttributeChangeEvent.ViewType convertPropertiesMode(@NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode) {
        switch (propertiesMode) {
            case TABLE: {
                return LayoutAttributeChangeEvent.ViewType.PROPERTY_TABLE;
            }
        }
        return LayoutAttributeChangeEvent.ViewType.INSPECTOR;
    }

    @NotNull
    static SearchOption convertFilterMatches(int matches) {
        if (matches < 1) {
            return SearchOption.NONE;
        }
        if (matches > 1) {
            return SearchOption.MULTIPLE_MATCHES;
        }
        return SearchOption.SINGLE_MATCH;
    }

    @Nullable
    @VisibleForTesting
    static String getStyleValue(@NotNull String representation) {
        Matcher matcher = STYLE_PATTERN.matcher(representation);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertProgressBarViewOption(@NotNull String representation) {
        String styleValue = NlUsageTrackerImpl.getStyleValue(representation);
        if (styleValue == null || styleValue.equals("?android:attr/progressBarStyle")) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("?android:attr/progressBarStyleHorizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_PROGRESS_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertSeekBarViewOption(@NotNull String representation) {
        String styleValue = NlUsageTrackerImpl.getStyleValue(representation);
        if (styleValue == null) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("@style/Widget.AppCompat.SeekBar.Discrete")) {
            return LayoutPaletteEvent.ViewOption.DISCRETE_SEEK_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertEditTextViewOption(@NotNull String representation) {
        Matcher matcher = INPUT_STYLE_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        LayoutPaletteEvent.ViewOption viewOption = PALETTE_VIEW_OPTION_MAP.get(matcher.group(1));
        return viewOption != null ? viewOption : LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertLinearLayoutViewOption(@NotNull String representation) {
        Matcher matcher = ORIENTATION_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        String orientation = matcher.group(1);
        if (orientation.equals("horizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        if (orientation.equals("vertical")) {
            return LayoutPaletteEvent.ViewOption.VERTICAL_LINEAR_LAYOUT;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }
}

