/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.FloatResources;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import java.awt.Dimension;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewEditor {
    @Nullable
    public static Integer resolveDimensionPixelSize(@NotNull RenderResources resources, @NotNull String value2, @NotNull Configuration configuration) {
        FloatResources.TypedValue out;
        String resValue = ResourceHelper.resolveStringValue(resources, value2);
        if (FloatResources.parseFloatAttribute(resValue, out = new FloatResources.TypedValue(), true)) {
            return FloatResources.TypedValue.complexToDimensionPixelSize(out.data, configuration);
        }
        return null;
    }

    public int dpToPx(int dp) {
        return Coordinates.dpToPx(this.getScene().getDesignSurface(), (float)dp);
    }

    public int pxToDp(int px) {
        return Coordinates.pxToDp(this.getScene().getDesignSurface(), px);
    }

    @Nullable
    public abstract AndroidVersion getCompileSdkVersion();

    @NotNull
    public abstract AndroidVersion getMinSdkVersion();

    @NotNull
    public abstract AndroidVersion getTargetSdkVersion();

    @NotNull
    public abstract Configuration getConfiguration();

    @NotNull
    public abstract NlModel getModel();

    @NotNull
    public abstract LayoutlibSceneManager getSceneBuilder();

    @NotNull
    public abstract Collection<ViewInfo> getRootViews();

    @Nullable
    public abstract CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent var1, @Nullable RenderTask.AttributeFilter var2);

    @Nullable
    public final String displayResourceInput(@NotNull EnumSet<ResourceType> types) {
        return this.displayResourceInput("", types);
    }

    @Nullable
    public final String displayResourceInput(@NotNull EnumSet<ResourceType> types, boolean includeSampleData) {
        return this.displayResourceInput("", types, includeSampleData);
    }

    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types) {
        return this.displayResourceInput(title, types, false);
    }

    @Nullable
    public abstract String displayResourceInput(@NotNull String var1, @NotNull EnumSet<ResourceType> var2, boolean var3);

    @Nullable
    public abstract String displayClassInput(@NotNull String var1, @NotNull Set<String> var2, @Nullable Predicate<String> var3, @Nullable String var4);

    @NotNull
    public abstract Scene getScene();

    public abstract boolean canInsertChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2, int var3);

    public abstract void insertChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2, int var3, @NotNull InsertType var4);

    public abstract void openResourceFile(@NotNull String var1);

    public abstract boolean moduleDependsOnAppCompat();
}

