/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.AbstractViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewActionSeparator
extends AbstractViewAction {
    private List<ViewAction> myFollowingActions = new ArrayList<ViewAction>();

    public ViewActionSeparator() {
        super(null, "");
    }

    public static void setupFollowingActions(@NotNull List<ViewAction> actions2) {
        ViewActionSeparator separator = null;
        for (ViewAction action2 : actions2) {
            if (action2 instanceof ViewActionSeparator) {
                separator = (ViewActionSeparator)action2;
            } else if (separator != null) {
                separator.addFollowingAction(action2);
            }
            if (!(action2 instanceof NestedViewActionMenu)) continue;
            ArrayList<ViewAction> nested = new ArrayList<ViewAction>();
            ((NestedViewActionMenu)action2).getActions().forEach(list -> nested.addAll((Collection<ViewAction>)list));
            ViewActionSeparator.setupFollowingActions(nested);
        }
    }

    private void addFollowingAction(@NotNull ViewAction action2) {
        this.myFollowingActions.add(action2);
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
    }

    @Override
    public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
    }

    public boolean isVisible(@NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren) {
        if (this.myFollowingActions.isEmpty()) {
            return true;
        }
        for (ViewAction action2 : this.myFollowingActions) {
            SeparatorPresentation following = new SeparatorPresentation();
            action2.updatePresentation(following, editor2, handler, component, selectedChildren, 0);
            if (!following.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static class SeparatorPresentation
    implements ViewActionPresentation {
        private boolean myVisible = true;

        private SeparatorPresentation() {
        }

        @Override
        public void setLabel(@NotNull String label) {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
        }

        @Override
        public void setVisible(boolean visible) {
            this.myVisible = visible;
        }

        public boolean isVisible() {
            return this.myVisible;
        }
    }
}

