/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAbstractWindowManager
extends LightToolWindowManager {
    private ToolWindowType myPreviousWindowType;
    private ToolWindowAnchor myPreviousWindowAnchor;
    private DesignSurface myDesignSurface;

    public NlAbstractWindowManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
    }

    protected void initToolWindow(final @NotNull String id, @NotNull Icon icon2) {
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(id, false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(icon2);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindow.setAutoHide(false);
        this.myPreviousWindowType = this.myToolWindow.getType();
        this.myPreviousWindowAnchor = this.getEditorMode();
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (NlAbstractWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlAbstractWindowManager.this.myProject).getToolWindow(id);
                ToolWindowType newWindowType = window.getType();
                ToolWindowAnchor newWindowAnchor = NlAbstractWindowManager.this.getEditorMode();
                if (newWindowType != NlAbstractWindowManager.this.myPreviousWindowType || newWindowAnchor != NlAbstractWindowManager.this.myPreviousWindowAnchor) {
                    NlUsageTracker.getInstance(NlAbstractWindowManager.this.myDesignSurface).logAction(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
                    NlAbstractWindowManager.this.myPreviousWindowType = newWindowType;
                    NlAbstractWindowManager.this.myPreviousWindowAnchor = newWindowAnchor;
                }
            }
        });
        this.initGearActions();
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myDesignSurface = NlAbstractWindowManager.getDesignSurface(designer);
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor2) {
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return null;
            }
        };
    }

    @Nullable
    protected static DesignSurface getDesignSurface(@NotNull DesignerEditorPanelFacade designer) {
        if (designer instanceof DesignerEditorPanel) {
            DesignerEditorPanel editor2 = (DesignerEditorPanel)designer;
            return editor2.getSurface();
        }
        if (designer instanceof NlPreviewForm) {
            NlPreviewForm form = (NlPreviewForm)designer;
            return form.hasFile() ? form.getSurface() : null;
        }
        throw new RuntimeException(designer.getClass().getName());
    }

    protected void createWindowContent(@NotNull JComponent contentPane, @NotNull JComponent focusedComponent, @Nullable AnAction[] actions2) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(contentPane, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(focusedComponent);
        if (actions2 != null) {
            ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
            toolWindow.setTitleActions(actions2);
        }
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }
}

