/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.DesignerEditorProvider;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.type.AdaptativeIconFileType;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.uibuilder.type.PreferenceScreenFileType;
import com.android.tools.idea.uibuilder.type.StateListFileType;
import com.android.tools.idea.uibuilder.type.VectorFileType;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NlEditorProvider
extends DesignerEditorProvider {
    @NotNull
    private final List<DesignerEditorFileType> myRegisteredTypes = ImmutableList.of((Object)AdaptativeIconFileType.INSTANCE, (Object)LayoutFileType.INSTANCE, (Object)MenuFileType.INSTANCE, (Object)PreferenceScreenFileType.INSTANCE, (Object)StateListFileType.INSTANCE, (Object)VectorFileType.INSTANCE);

    public NlEditorProvider() {
        this.myRegisteredTypes.forEach(DesignerTypeRegistrar.INSTANCE::register);
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new NlEditor(file, project);
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "android-designer2";
    }

    @Override
    protected boolean acceptAndroidFacetXml(@NotNull XmlFile xmlFile) {
        return this.myRegisteredTypes.stream().anyMatch(type -> type instanceof LayoutEditorFileType && type.isResourceTypeOf((PsiFile)xmlFile));
    }
}

