/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewManager
implements ProjectComponent {
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private NlPreviewForm myToolWindowForm;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady = false;
    private boolean myToolWindowDisposed = false;
    @VisibleForTesting
    private int myUpdateCount;
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;
    private boolean myRenderImmediately;

    public NlPreviewManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.preview", 100, true, null, (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> {
            this.myToolWindowReady = true;
            this.processFileEditorChange(this.getActiveLayoutXmlEditor(null));
        });
    }

    public boolean isWindowVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    protected boolean isUseInteractiveSelector() {
        return true;
    }

    protected String getToolWindowId() {
        return AndroidBundle.message("android.layout.preview.tool.window.title", new Object[0]);
    }

    @NotNull
    protected NlPreviewForm createPreviewForm() {
        return new NlPreviewForm(this);
    }

    protected void initToolWindow() {
        this.myToolWindowForm = this.createPreviewForm();
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(toolWindowId, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PREVIEW);
        this.myToolWindow.getComponent().setFocusTraversalPolicy(new NoDefaultFocusTraversalPolicy());
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (NlPreviewManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlPreviewManager.this.myProject).getToolWindow(toolWindowId);
                if (window != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (NlPreviewManager.this.myToolWindowForm != null) {
                        if (visible) {
                            NlPreviewManager.this.myToolWindowForm.activate();
                        } else {
                            NlPreviewManager.this.myToolWindowForm.deactivate();
                        }
                    }
                }
            }
        });
        JComponent contentPanel = this.myToolWindowForm.getComponent();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.addDataProvider(dataId -> {
            TextEditor textEditor;
            if ((LangDataKeys.MODULE.is(dataId) || LangDataKeys.IDE_VIEW.is(dataId) || CommonDataKeys.VIRTUAL_FILE.is(dataId)) && (textEditor = this.myToolWindowForm.getEditor()) != null) {
                JComponent component = textEditor.getEditor().getContentComponent();
                DataContext context = DataManager.getInstance().getDataContext((Component)component);
                return context.getData(dataId);
            }
            return null;
        });
        Content content = contentManager.getFactory().createContent(contentPanel, null, false);
        content.setDisposer((Disposable)this.myToolWindowForm);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(contentPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindowForm.setUseInteractiveSelector(this.isUseInteractiveSelector());
        if (this.isWindowVisible()) {
            this.myToolWindowForm.activate();
        }
    }

    public void projectClosed() {
        if (this.myToolWindowForm != null) {
            Disposer.dispose((Disposable)this.myToolWindowForm);
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        return "NlPreviewManager";
    }

    @VisibleForTesting
    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    @VisibleForTesting
    public boolean isPreviewVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    private void processFileEditorChange(final @Nullable TextEditor newEditor) {
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            public void run() {
                Editor activeEditor;
                NlPreviewManager.this.myUpdateCount++;
                if (!NlPreviewManager.this.myToolWindowReady || NlPreviewManager.this.myToolWindowDisposed) {
                    return;
                }
                NlPreviewManager.this.myRenderImmediately = false;
                Editor editor2 = activeEditor = newEditor != null ? newEditor.getEditor() : null;
                if (NlPreviewManager.this.myToolWindow == null) {
                    if (activeEditor == null) {
                        return;
                    }
                    if (!activeEditor.getComponent().isShowing()) {
                        if (!NlPreviewManager.this.mySeenEditor) {
                            NlPreviewManager.this.myPendingShowComponent = activeEditor.getComponent();
                            if (NlPreviewManager.this.myHierarchyListener == null) {
                                NlPreviewManager.this.myHierarchyListener = hierarchyEvent -> {
                                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == NlPreviewManager.this.myPendingShowComponent && NlPreviewManager.this.myPendingShowComponent.isShowing()) {
                                        NlPreviewManager.this.myPendingShowComponent.removeHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                                        NlPreviewManager.this.mySeenEditor = true;
                                        NlPreviewManager.this.myPendingShowComponent = null;
                                        NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(null));
                                    }
                                };
                            }
                            NlPreviewManager.this.myPendingShowComponent.addHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    NlPreviewManager.this.mySeenEditor = true;
                    NlPreviewManager.this.initToolWindow();
                }
                AndroidEditorSettings settings = AndroidEditorSettings.getInstance();
                boolean hideForNonLayoutFiles = settings.getGlobalState().isHideForNonLayoutFiles();
                if (activeEditor == null) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                if (!NlPreviewManager.this.myToolWindowForm.setNextEditor(newEditor)) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                NlPreviewManager.this.myToolWindow.setAvailable(true, null);
                boolean visible = AndroidEditorSettings.getInstance().getGlobalState().isVisible();
                if (visible && !NlPreviewManager.this.myToolWindow.isVisible()) {
                    Runnable restoreFocus = null;
                    if (NlPreviewManager.this.myToolWindow.getType() == ToolWindowType.WINDOWED) {
                        restoreFocus = () -> IdeFocusManager.getInstance((Project)NlPreviewManager.this.myProject).doWhenFocusSettlesDown(() -> NlPreviewManager.restoreFocusToEditor(newEditor));
                    }
                    NlPreviewManager.this.myToolWindowForm.clearRenderResult();
                    NlPreviewManager.this.myToolWindow.activate(restoreFocus, false, false);
                }
            }
        });
    }

    private static void restoreFocusToEditor(@NotNull TextEditor newEditor) {
        ApplicationManager.getApplication().invokeLater(() -> newEditor.getEditor().getContentComponent().requestFocus());
    }

    @Nullable
    private TextEditor getActiveLayoutXmlEditor(@Nullable PsiFile file) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (TextEditor)ApplicationManager.getApplication().runReadAction(() -> this.getActiveLayoutXmlEditor(file));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return Arrays.stream(this.myFileEditorManager.getSelectedEditors()).filter(editor2 -> editor2 instanceof TextEditor && this.isApplicableEditor((TextEditor)editor2, file)).findFirst().orElse(null);
    }

    public boolean isApplicableEditor(@NotNull TextEditor textEditor, @Nullable PsiFile file) {
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file != null && !file.equals(psiFile)) {
            return false;
        }
        return NlPreviewManager.isInResourceFolder(psiFile);
    }

    @Nullable
    protected XmlFile getBoundXmlFile(@Nullable PsiFile file) {
        return (XmlFile)file;
    }

    @Nullable
    protected ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    public NlPreviewForm getPreviewForm() {
        if (this.myToolWindow == null) {
            this.initToolWindow();
        }
        return this.myToolWindowForm;
    }

    private static boolean isInResourceFolder(@Nullable PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            return RenderService.canRender(psiFile);
        }
        return false;
    }

    public static NlPreviewManager getInstance(Project project) {
        return (NlPreviewManager)project.getComponent(NlPreviewManager.class);
    }

    public void notifyFileShown(@NotNull TextEditor editor2, boolean renderImmediately) {
        if (renderImmediately) {
            this.myRenderImmediately = true;
        }
        this.processFileEditorChange(editor2);
        if (renderImmediately) {
            this.myToolWindowUpdateQueue.sendFlush();
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private static class NoDefaultFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private NoDefaultFocusTraversalPolicy() {
        }

        @Override
        @Nullable
        public Component getDefaultComponent(@Nullable Container aContainer) {
            super.getDefaultComponent(aContainer);
            return null;
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (!file.isValid()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)NlPreviewManager.this.myProject).findFile(file);
            NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(psiFile));
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (NlPreviewManager.this.myToolWindowForm != null) {
                NlPreviewManager.this.myToolWindowForm.fileClosed(source, file);
            }
            if (source.getOpenFiles().length == 0) {
                ApplicationManager.getApplication().invokeLater(() -> NlPreviewManager.this.processFileEditorChange(null), NlPreviewManager.this.myProject.getDisposed());
            }
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            FileEditor newEditor = event.getNewEditor();
            TextEditor layoutXmlEditor = null;
            if (newEditor instanceof TextEditor && NlPreviewManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor, null)) {
                layoutXmlEditor = textEditor;
            }
            NlPreviewManager.this.processFileEditorChange(layoutXmlEditor);
        }
    }
}

