/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.google.common.collect.ImmutableCollection;
import com.intellij.lang.annotation.HighlightSeverity;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderIssueProvider
extends IssueProvider {
    private final RenderErrorModel myRenderErrorModel;

    public RenderIssueProvider(@NotNull RenderErrorModel renderErrorModel) {
        this.myRenderErrorModel = renderErrorModel;
    }

    @Override
    public void collectIssues(@NotNull ImmutableCollection.Builder<Issue> issueListBuilder) {
        for (RenderErrorModel.Issue error : this.myRenderErrorModel.getIssues()) {
            issueListBuilder.add((Object)NlRenderIssueWrapper.wrapIssue(error));
        }
    }

    public static class NlRenderIssueWrapper
    extends Issue {
        private final RenderErrorModel.Issue myIssue;

        NlRenderIssueWrapper(@NotNull RenderErrorModel.Issue issue2) {
            this.myIssue = issue2;
        }

        @NotNull
        public static Issue wrapIssue(@NotNull RenderErrorModel.Issue renderIssue) {
            return new NlRenderIssueWrapper(renderIssue);
        }

        @Override
        @NotNull
        public String getSummary() {
            return this.myIssue.getSummary();
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myIssue.getHtmlContent();
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myIssue.getSeverity();
        }

        @Override
        @Nullable
        public NlComponent getSource() {
            return null;
        }

        @Override
        @NotNull
        public String getCategory() {
            return "Rendering Issue";
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myIssue.getHyperlinkListener();
        }
    }
}

