/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.graphics;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class NlGraphics {
    private final SceneView myScene;
    private final Graphics2D myGraphics;
    @NotNull
    private NlDrawingStyle myStyle = NlDrawingStyle.INVALID;
    private static final int MIN_LENGTH = 10;
    private static final int ARROW_SIZE = 5;

    public NlGraphics(@NotNull Graphics2D graphics, @NotNull SceneView scene) {
        this.myGraphics = graphics;
        this.myScene = scene;
    }

    public void useStyle(@NotNull NlDrawingStyle style) {
        this.myStyle = style;
    }

    public void fillRect(int x, int y, int width, int height) {
        Color fillColor = this.myStyle.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(this.myStyle, this.myGraphics);
            x = Coordinates.getSwingX(this.myScene, x);
            y = Coordinates.getSwingY(this.myScene, y);
            width = Coordinates.getSwingDimension(this.myScene, width);
            height = Coordinates.getSwingDimension(this.myScene, height);
            NlGraphics.fillRect(this.myStyle, this.myGraphics, x, y, width, height);
        }
    }

    public void drawTop(@NotNull NlComponent component) {
        this.drawLine(NlComponentHelperKt.getX(component), NlComponentHelperKt.getY(component), NlComponentHelperKt.getX(component) + NlComponentHelperKt.getW(component), NlComponentHelperKt.getY(component));
    }

    public void drawTop(@NotNull Rectangle rectangle) {
        this.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
    }

    public void drawTopDp(@NotNull Rectangle rectangle) {
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y));
    }

    public void drawLeft(@NotNull NlComponent component) {
        this.drawLine(NlComponentHelperKt.getX(component), NlComponentHelperKt.getY(component), NlComponentHelperKt.getX(component), NlComponentHelperKt.getY(component) + NlComponentHelperKt.getH(component));
    }

    public void drawLeft(@NotNull Rectangle rectangle) {
        this.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
    }

    public void drawLeftDp(@NotNull Rectangle rectangle) {
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawRight(@NotNull NlComponent component) {
        this.drawLine(NlComponentHelperKt.getX(component) + NlComponentHelperKt.getW(component), NlComponentHelperKt.getY(component), NlComponentHelperKt.getX(component) + NlComponentHelperKt.getW(component), NlComponentHelperKt.getY(component) + NlComponentHelperKt.getH(component));
    }

    public void drawRight(@NotNull Rectangle rectangle) {
        this.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawRightDp(@NotNull Rectangle rectangle) {
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawBottom(@NotNull NlComponent component) {
        this.drawLine(NlComponentHelperKt.getX(component), NlComponentHelperKt.getY(component) + NlComponentHelperKt.getH(component), NlComponentHelperKt.getX(component) + NlComponentHelperKt.getW(component), NlComponentHelperKt.getY(component) + NlComponentHelperKt.getH(component));
    }

    public void drawBottom(@NotNull Rectangle rectangle) {
        this.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawBottomDp(@NotNull Rectangle rectangle) {
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScene, x1);
        x2 = Coordinates.getSwingX(this.myScene, x2);
        y1 = Coordinates.getSwingY(this.myScene, y1);
        y2 = Coordinates.getSwingY(this.myScene, y2);
        NlGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawLineDp(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingXDip(this.myScene, x1);
        x2 = Coordinates.getSwingXDip(this.myScene, x2);
        y1 = Coordinates.getSwingYDip(this.myScene, y1);
        y2 = Coordinates.getSwingYDip(this.myScene, y2);
        NlGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        x = Coordinates.getSwingX(this.myScene, x);
        y = Coordinates.getSwingY(this.myScene, y);
        width = Coordinates.getSwingDimension(this.myScene, width);
        height = Coordinates.getSwingDimension(this.myScene, height);
        NlGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public void drawRectDp(int x, int y, int width, int height) {
        x = Coordinates.getSwingXDip(this.myScene, x);
        y = Coordinates.getSwingYDip(this.myScene, y);
        width = Coordinates.getSwingDimensionDip(this.myScene, width);
        height = Coordinates.getSwingDimensionDip(this.myScene, height);
        NlGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public void drawArrow(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScene, x1);
        x2 = Coordinates.getSwingX(this.myScene, x2);
        y1 = Coordinates.getSwingY(this.myScene, y1);
        y2 = Coordinates.getSwingY(this.myScene, y2);
        NlGraphics.drawArrow(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawCross(int radius) {
        radius = Coordinates.getSwingDimension(this.myScene, radius);
        NlGraphics.drawCross(this.myStyle, this.myGraphics, radius);
    }

    public static void fillRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(style, gc);
            gc.fillRect(x + 1, y + 1, width - 1, height - 1);
        }
    }

    public static void drawFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(style, gc);
            gc.setColor(fillColor);
            gc.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.drawRect(x, y, width - 1, height - 1);
        }
    }

    public static void drawStrokeFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.fillRect(x, y, width, height);
        }
    }

    public static void drawRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        NlGraphics.useStroke(style, gc);
        gc.drawRect(x, y, width - 1, height - 1);
    }

    public static void drawLine(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x1, int y1, int x2, int y2) {
        NlGraphics.useStroke(style, gc);
        gc.drawLine(x1, y1, x2, y2);
    }

    public static void drawArrow(@NotNull NlDrawingStyle style, @NotNull Graphics graphics, int x1, int y1, int x2, int y2) {
        int delta;
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != graphics.getColor()) {
            graphics.setColor(strokeColor);
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)graphics;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
        int arrowWidth = 5;
        int arrowHeight = 5;
        if (x1 == x2 && Math.abs(y1 - y2) < 10) {
            delta = (10 - Math.abs(y1 - y2)) / 2;
            if (y1 < y2) {
                y1 -= delta;
                y2 += delta;
            } else {
                y1 += delta;
                y2 -= delta;
            }
        } else if (y1 == y2 && Math.abs(x1 - x2) < 10) {
            delta = (10 - Math.abs(x1 - x2)) / 2;
            if (x1 < x2) {
                x1 -= delta;
                x2 += delta;
            } else {
                x1 += delta;
                x2 -= delta;
            }
        }
        graphics.drawLine(x1, y1, x2, y2);
        if (x1 == x2) {
            if (y2 > y1) {
                graphics.drawLine(x2 - arrowWidth, y2 - arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 - arrowHeight, x2, y2);
            } else {
                graphics.drawLine(x2 - arrowWidth, y2 + arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 + arrowHeight, x2, y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                graphics.drawLine(x2 - arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 - arrowHeight, y2 + arrowWidth, x2, y2);
            } else {
                graphics.drawLine(x2 + arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 + arrowHeight, y2 + arrowWidth, x2, y2);
            }
        } else {
            int dy = y2 - y1;
            int dx = x2 - x1;
            double angle = Math.atan2(dy, dx);
            double lineLength = Math.sqrt(dy * dy + dx * dx);
            double ax = (double)x1 + lineLength - (double)arrowHeight;
            double ay = y1 - arrowWidth;
            int rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            int ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
            ay = y1 + arrowWidth;
            rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
        }
    }

    public static void drawCross(@NotNull NlDrawingStyle style, @NotNull Graphics g, int radius) {
        int size2 = (radius - 3) / 2;
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.fillRect(style, g, 0, size2, radius, 3);
            NlGraphics.fillRect(style, g, size2, 0, 3, radius);
        } else {
            NlGraphics.drawLine(style, g, 0, size2 + 1, radius, size2 + 1);
            NlGraphics.drawLine(style, g, size2 + 1, 0, size2 + 1, radius);
        }
    }

    public static void useStroke(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != gc.getColor()) {
            gc.setColor(strokeColor);
        }
        if (gc instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)gc;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
    }

    public static void useFill(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        Color fillColor = style.getFillColor();
        if (fillColor != null && fillColor != gc.getColor()) {
            gc.setColor(fillColor);
        }
    }
}

