/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.SdkConstants;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawerLayoutHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"context", (Object)"openDrawer", (Object)"fitsSystemWindows");
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        if (SdkConstants.NAVIGATION_VIEW.isEquals(childComponent.getNlComponent().getTagName())) {
            NavigationViewSelectionTarget target = new NavigationViewSelectionTarget();
            target.setComponent(childComponent);
            return ImmutableList.of((Object)target);
        }
        return Collections.emptyList();
    }

    private static class NavigationViewSelectionTarget
    extends BaseTarget {
        private NavigationViewSelectionTarget() {
        }

        @Override
        public int getPreferenceLevel() {
            return 0;
        }

        @Override
        public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
            this.myLeft = this.myComponent.getDrawX();
            this.myRight = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
            this.myTop = this.myComponent.getDrawY();
            this.myBottom = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        }

        @Override
        @Nullable
        public List<SceneComponent> newSelection() {
            return ImmutableList.of((Object)this.myComponent);
        }

        @Override
        protected boolean isHittable() {
            return true;
        }
    }
}

