/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingActionButtonHandler
extends ImageViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"src", (Object)"style", (Object)"backgroundTint", (Object)"backgroundTintMode", (Object)"rippleColor", (Object)"tint", (Object)"fabSize", (Object)"fabCustomSize", (Object)"elevation", (Object)"hoveredFocusedTranslationZ", (Object)"pressedTranslationZ", (Object)"borderWidth", (Object[])new String[]{"useCompatPadding", "maxImageSize", "showMotionSpec", "hideMotionSpec"});
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        XmlBuilder builder = new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").androidAttribute("clickable", true);
        if (xmlType.equals((Object)XmlType.PREVIEW_ON_PALETTE)) {
            builder.attribute("app", "elevation", "0dp");
        }
        return builder.endTag(tagName).toString();
    }

    @Override
    @NotNull
    public String getSampleImageSrc() {
        return "@android:drawable/ic_input_add";
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        return 0.8;
    }

    @Override
    public boolean acceptsParent(@NotNull NlComponent layout2, @NotNull NlComponent newChild) {
        NlComponent appBar = FloatingActionButtonHandler.getAppBar(layout2);
        if (appBar == null) {
            return super.acceptsParent(layout2, newChild);
        }
        return layout2 == appBar.getParent();
    }

    @Nullable
    private static NlComponent getAppBar(@NotNull NlComponent component) {
        NlComponent parent = component.getParent();
        while (parent != null) {
            component = parent;
            parent = component.getParent();
        }
        if (!SdkConstants.COORDINATOR_LAYOUT.isEquals(component.getTagName())) {
            return null;
        }
        for (NlComponent child : component.getChildren()) {
            if (!SdkConstants.APP_BAR_LAYOUT.isEquals(child.getTagName())) continue;
            return child;
        }
        return null;
    }
}

