/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncludeHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"layout", (Object)"visibility");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String layout2 = component.getAttribute(null, "layout");
        return StringUtil.isEmpty((String)layout2) ? "" : "- " + layout2;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<include/>";
            }
        }
        return "";
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        String layoutAttr = newChild.getAttribute(null, "layout");
        if (insertType == InsertType.CREATE && layoutAttr == null) {
            String src = editor2.displayResourceInput(EnumSet.of(ResourceType.LAYOUT));
            if (src != null) {
                return (Boolean)NlWriteCommandActionUtil.compute(newChild, "Create Include", () -> {
                    newChild.setAttribute(null, "layout", src);
                    return true;
                });
            }
            return false;
        }
        return true;
    }

    @Override
    public void onActivateInComponentTree(@NotNull NlComponent component, @NotNull ViewEditor editor2) {
        IncludeHandler.openIncludedLayout(component, editor2);
    }

    @Override
    public void onActivateInDesignSurface(@NotNull NlComponent component, @NotNull ViewEditor editor2, int x, int y) {
        IncludeHandler.openIncludedLayout(component, editor2);
    }

    private static void openIncludedLayout(@NotNull NlComponent component, @NotNull ViewEditor editor2) {
        NlModel model2 = component.getModel();
        String attribute = component.getAttribute(null, "layout");
        if (attribute == null) {
            return;
        }
        editor2.openResourceFile(attribute);
    }
}

