/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedScrollViewHandler
extends ScrollViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"context", (Object)"showIn", (Object)"fillViewport", (Object)"clipToPadding");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(editor2, parent, newChild, type)) {
            return false;
        }
        if (type.isCreate()) {
            NlWriteCommandActionUtil.run(newChild, "Setting fill_viewport", () -> newChild.setAndroidAttribute("fillViewport", "true"));
        }
        return true;
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor2, @NotNull NlComponent component) {
        int maxScrollableHeight;
        boolean nestedScrollingParent;
        ViewGroup viewGroup = ScrollViewHandler.getViewGroupFromComponent(component);
        if (viewGroup == null) {
            return null;
        }
        ViewParent parent = viewGroup.getParent();
        if (parent instanceof ViewGroup && (nestedScrollingParent = Arrays.stream(parent.getClass().getInterfaces()).map(Class::getName).anyMatch("android.support.v4.view.NestedScrollingParent"::equals))) {
            viewGroup = (ViewGroup)parent;
        }
        if ((maxScrollableHeight = ScrollViewScrollHandler.getMaxScrollable(viewGroup, View::getHeight, View::getMeasuredHeight)) > 0) {
            return ScrollViewScrollHandler.createHandler(viewGroup, maxScrollableHeight, 10, ScrollViewScrollHandler.Orientation.VERTICAL);
        }
        return null;
    }
}

