/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ComponentAssistantViewAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.actions.PickSampleListDataViewAction;
import com.android.tools.idea.uibuilder.handlers.assistant.RecyclerViewAssistant;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistantFactory;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclerViewHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case DRAG_PREVIEW: {
                return new XmlBuilder().startTag(tagName).wrapContent().endTag(tagName).toString();
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"scrollbars", (Object)"background", (Object)"tools:itemCount", (Object)"tools:listitem", (Object)"clipToPadding", (Object)"clipChildren");
    }

    @Override
    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        return tagName.startsWith("androidx.") ? AndroidxNameUtils.getCoordinateMapping((String)"com.android.support:recyclerview-v7") : "com.android.support:recyclerview-v7";
    }

    @Nullable
    private static ComponentAssistantFactory getComponentAssistant(@NotNull NlComponent component) {
        if (!((Boolean)StudioFlags.NELE_SAMPLE_DATA_UI.get()).booleanValue()) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(component.getModel().getModule());
        if (facet == null) {
            return null;
        }
        return RecyclerViewAssistant::createComponent;
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        boolean cacheable = super.addPopupMenuActions(component, actions2);
        actions2.add(new ComponentAssistantViewAction((Function1<? super NlComponent, ? extends ComponentAssistantFactory>)((Function1)RecyclerViewHandler::getComponentAssistant)));
        return cacheable;
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component) {
        return Collections.emptyList();
    }

    @Override
    public List<ViewAction> getPropertyActions(@NotNull List<NlComponent> components) {
        return ImmutableList.of((Object)new PickSampleListDataViewAction("http://schemas.android.com/tools", "listitem"));
    }
}

