/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.frame.FrameDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollViewHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"scrollbarStyle", (Object)"style", (Object)"fillViewport", (Object)"clipToPadding");
    }

    @Override
    public void onChildInserted(@NotNull ViewEditor editor2, @NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "match_parent");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (insertType.isCreate()) {
            NlWriteCommandActionUtil.run(node, "Create Scroll View", () -> {
                NlComponent linear = NlComponentHelperKt.createChild(node, editor2, "android.widget.LinearLayout", null, InsertType.PROGRAMMATIC);
                if (linear != null) {
                    linear.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                }
            });
        }
        return true;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor2, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new FrameDragHandler(editor2, (ViewGroupHandler)this, layout2, (List<? extends NlComponent>)components, type);
    }

    @Nullable
    public static ScrollHandler createScrollHandler(@NotNull ViewGroup viewGroup) {
        int maxScrollableHeight = ScrollViewScrollHandler.getMaxScrollable(viewGroup, View::getHeight, View::getMeasuredHeight);
        if (maxScrollableHeight > 0) {
            return ScrollViewScrollHandler.createHandler(viewGroup, maxScrollableHeight, 10, ScrollViewScrollHandler.Orientation.VERTICAL);
        }
        return null;
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor2, @NotNull NlComponent component) {
        ViewGroup viewGroup = ScrollViewHandler.getViewGroupFromComponent(component);
        if (viewGroup == null) {
            return null;
        }
        return ScrollViewHandler.createScrollHandler(viewGroup);
    }

    @Nullable
    static ViewGroup getViewGroupFromComponent(@NotNull NlComponent component) {
        Object viewObject;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        Object object = viewObject = viewInfo != null ? viewInfo.getViewObject() : null;
        if (viewObject instanceof ViewGroup) {
            return (ViewGroup)viewObject;
        }
        return null;
    }

    @Override
    public boolean acceptsChild(@NotNull NlComponent layout2, @NotNull NlComponent newChild) {
        return layout2.getChildCount() == 0;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        actions2.add(new ToggleRenderModeAction());
    }

    static class ToggleRenderModeAction
    extends ToggleViewAction {
        ToggleRenderModeAction() {
            super(StudioIcons.LayoutEditor.Toolbar.VIEWPORT_RENDER, StudioIcons.LayoutEditor.Toolbar.NORMAL_RENDER, "Toggle Viewport Render Mode", null);
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            return LayoutlibSceneManager.isRenderViewPort();
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            LayoutlibSceneManager.setRenderViewPort(selected);
            editor2.getSceneBuilder().requestRender();
        }
    }
}

