/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.AdapterViewHandler;
import com.android.tools.idea.uibuilder.handlers.AppBarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.AutoCompleteTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.BottomAppBarHandler;
import com.android.tools.idea.uibuilder.handlers.BottomNavigationViewHandler;
import com.android.tools.idea.uibuilder.handlers.ButtonHandler;
import com.android.tools.idea.uibuilder.handlers.CardViewHandler;
import com.android.tools.idea.uibuilder.handlers.CheckBoxHandler;
import com.android.tools.idea.uibuilder.handlers.CheckedTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ChipGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ChipHandler;
import com.android.tools.idea.uibuilder.handlers.ChronometerHandler;
import com.android.tools.idea.uibuilder.handlers.CollapsingToolbarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.DrawerLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.EditTextHandler;
import com.android.tools.idea.uibuilder.handlers.FloatingActionButtonHandler;
import com.android.tools.idea.uibuilder.handlers.FragmentHandler;
import com.android.tools.idea.uibuilder.handlers.HorizontalScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ImageSwitcherHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.IncludeHandler;
import com.android.tools.idea.uibuilder.handlers.LayoutHandler;
import com.android.tools.idea.uibuilder.handlers.ListViewHandler;
import com.android.tools.idea.uibuilder.handlers.MergeDelegateHandler;
import com.android.tools.idea.uibuilder.handlers.MergeHandler;
import com.android.tools.idea.uibuilder.handlers.NavigationViewHandler;
import com.android.tools.idea.uibuilder.handlers.NestedScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.NoPreviewHandler;
import com.android.tools.idea.uibuilder.handlers.ProgressBarHandler;
import com.android.tools.idea.uibuilder.handlers.RatingBarHandler;
import com.android.tools.idea.uibuilder.handlers.RecyclerViewHandler;
import com.android.tools.idea.uibuilder.handlers.RequestFocusHandler;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.SeekBarHandler;
import com.android.tools.idea.uibuilder.handlers.SpaceHandler;
import com.android.tools.idea.uibuilder.handlers.SpinnerHandler;
import com.android.tools.idea.uibuilder.handlers.SwitchHandler;
import com.android.tools.idea.uibuilder.handlers.TabHostHandler;
import com.android.tools.idea.uibuilder.handlers.TabItemHandler;
import com.android.tools.idea.uibuilder.handlers.TabLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableRowHandler;
import com.android.tools.idea.uibuilder.handlers.TextInputLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ToggleButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ToolbarHandler;
import com.android.tools.idea.uibuilder.handlers.ViewPagerHandler;
import com.android.tools.idea.uibuilder.handlers.ViewStubHandler;
import com.android.tools.idea.uibuilder.handlers.ViewTagHandler;
import com.android.tools.idea.uibuilder.handlers.ZoomButtonHandler;
import com.android.tools.idea.uibuilder.handlers.absolute.AbsoluteLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutBarrierHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutChainHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutGuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutLayerHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.frame.FrameLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.google.AdViewHandler;
import com.android.tools.idea.uibuilder.handlers.google.MapViewHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutV7Handler;
import com.android.tools.idea.uibuilder.handlers.leanback.BrowseFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.DetailsFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.PlaybackOverlayFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.SearchFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.preference.CheckBoxPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.EditTextPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.ListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.MultiSelectListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceScreenHandler;
import com.android.tools.idea.uibuilder.handlers.preference.RingtonePreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.SwitchPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandler;
import com.android.tools.idea.uibuilder.menu.GroupHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.android.tools.idea.uibuilder.statelist.SelectorHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewHandlerManager
implements ProjectComponent {
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private static final Set<String> NO_PREFIX_PACKAGES = ImmutableSet.of((Object)"android.widget.", (Object)"android.view.", (Object)"android.webkit.", (Object)"android.app.");
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers = Maps.newHashMap();
    public static final ViewHandler NONE = new ViewHandler();
    private static final ViewHandler STANDARD_HANDLER = new ViewHandler();
    private static final ViewHandler TEXT_HANDLER = new TextViewHandler();
    private static final ViewHandler NO_PREVIEW_HANDLER = new NoPreviewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions = Maps.newHashMap();
    private final Map<ViewHandler, List<ViewAction>> myMenuActions = Maps.newHashMap();

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        ViewHandlerManager manager = (ViewHandlerManager)project.getComponent(ViewHandlerManager.class);
        assert (manager != null);
        return manager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet) {
        return ViewHandlerManager.get(facet.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component) {
        String tag;
        switch (tag = component.getTagName()) {
            case "item": {
                ViewHandler handler = MenuViewHandlerManager.getHandler(component);
                if (handler != null) {
                    return handler;
                }
                return new ItemHandler();
            }
            case "merge": {
                ViewHandler groupHandler;
                String parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag");
                if (parentTag != null && (groupHandler = this.getHandler(parentTag)) instanceof ViewGroupHandler) {
                    return new MergeDelegateHandler((ViewGroupHandler)groupHandler);
                }
                return this.getHandler("merge");
            }
        }
        return this.getHandler(tag);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component) {
        ViewHandler handler = this.getHandler(component);
        return handler != null ? handler : NONE;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler = this.getHandler(viewTag);
        return handler != null ? handler : NONE;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        ViewHandler handler = this.myHandlers.get(viewTag);
        if (handler == null) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler = this.getHandler(tag)) != null) {
                this.myHandlers.put(viewTag, handler);
                return handler;
            }
            handler = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler);
        }
        return handler != NONE ? handler : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler) {
        this.myHandlers.put(viewTag, handler);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component, boolean strict) {
        NlComponent curr = component;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler = this.getHandler(curr);
            if (handler instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler;
            }
            curr = curr.getParent();
        }
        return null;
    }

    public ViewHandler createBuiltInHandler(@NotNull String viewTag) {
        switch (viewTag) {
            case "AbsoluteLayout": 
            case "WebView": {
                return new AbsoluteLayoutHandler();
            }
            case "AbsListView": 
            case "AdapterViewAnimator": 
            case "AdapterViewFlipper": 
            case "GridView": 
            case "ViewGroup": {
                return new ViewGroupHandler();
            }
            case "AdapterView": 
            case "StackView": {
                return new AdapterViewHandler();
            }
            case "com.google.android.gms.ads.AdView": {
                return new AdViewHandler();
            }
            case "AutoCompleteTextView": {
                return new AutoCompleteTextViewHandler();
            }
            case "com.google.android.material.bottomappbar.BottomAppBar": {
                return new BottomAppBarHandler();
            }
            case "Button": 
            case "com.google.android.material.button.MaterialButton": {
                return new ButtonHandler();
            }
            case "CheckedTextView": {
                return new CheckedTextViewHandler();
            }
            case "CheckBox": 
            case "RadioButton": {
                return new CheckBoxHandler();
            }
            case "com.google.android.material.chip.Chip": {
                return new ChipHandler();
            }
            case "com.google.android.material.chip.ChipGroup": {
                return new ChipGroupHandler();
            }
            case "Chronometer": {
                return new ChronometerHandler();
            }
            case "DialerFilter": 
            case "android.widget.RelativeLayout": 
            case "RelativeLayout": {
                return new RelativeLayoutHandler();
            }
            case "EditText": {
                return new EditTextHandler();
            }
            case "ExpandableListView": {
                return new ListViewHandler();
            }
            case "com.google.android.flexbox.FlexboxLayout": {
                return NONE;
            }
            case "android.widget.LinearLayout": 
            case "LinearLayout": 
            case "SearchView": {
                return new LinearLayoutHandler();
            }
            case "FrameLayout": 
            case "GestureOverlayView": 
            case "TextSwitcher": 
            case "ViewAnimator": 
            case "ViewFlipper": 
            case "ViewSwitcher": {
                return new FrameLayoutHandler();
            }
            case "GridLayout": {
                return new GridLayoutHandler();
            }
            case "HorizontalScrollView": {
                return new HorizontalScrollViewHandler();
            }
            case "ImageButton": {
                return new ImageButtonHandler();
            }
            case "ImageSwitcher": {
                return new ImageSwitcherHandler();
            }
            case "ImageView": 
            case "QuickContactBadge": {
                return new ImageViewHandler();
            }
            case "com.google.android.gms.maps.MapView": {
                return new MapViewHandler();
            }
            case "MultiAutoCompleteTextView": 
            case "TextView": {
                return TEXT_HANDLER;
            }
            case "ProgressBar": {
                return new ProgressBarHandler();
            }
            case "CheckBoxPreference": {
                return new CheckBoxPreferenceHandler();
            }
            case "EditTextPreference": {
                return new EditTextPreferenceHandler();
            }
            case "ListPreference": {
                return new ListPreferenceHandler();
            }
            case "MultiSelectListPreference": {
                return new MultiSelectListPreferenceHandler();
            }
            case "PreferenceCategory": {
                return new PreferenceCategoryHandler();
            }
            case "PreferenceScreen": {
                return new PreferenceScreenHandler();
            }
            case "RingtonePreference": {
                return new RingtonePreferenceHandler();
            }
            case "SwitchPreference": {
                return new SwitchPreferenceHandler();
            }
            case "RatingBar": {
                return new RatingBarHandler();
            }
            case "requestFocus": {
                return new RequestFocusHandler();
            }
            case "ScrollView": {
                return new ScrollViewHandler();
            }
            case "SeekBar": {
                return new SeekBarHandler();
            }
            case "Space": {
                return new SpaceHandler();
            }
            case "Spinner": {
                return new SpinnerHandler();
            }
            case "SurfaceView": 
            case "TextureView": 
            case "VideoView": {
                return NO_PREVIEW_HANDLER;
            }
            case "Switch": {
                return new SwitchHandler();
            }
            case "TableLayout": {
                return new TableLayoutHandler();
            }
            case "TableRow": {
                return new TableRowHandler();
            }
            case "TabHost": {
                return new TabHostHandler();
            }
            case "group": {
                return new GroupHandler();
            }
            case "layout": {
                return new LayoutHandler();
            }
            case "menu": {
                return new MenuHandler();
            }
            case "selector": {
                return new SelectorHandler();
            }
            case "TextClock": {
                return STANDARD_HANDLER;
            }
            case "ToggleButton": {
                return new ToggleButtonHandler();
            }
            case "View": {
                return STANDARD_HANDLER;
            }
            case "fragment": {
                return new FragmentHandler();
            }
            case "include": {
                return new IncludeHandler();
            }
            case "merge": {
                return new MergeHandler();
            }
            case "ViewStub": {
                return new ViewStubHandler();
            }
            case "view": {
                return new ViewTagHandler();
            }
            case "ZoomButton": {
                return new ZoomButtonHandler();
            }
        }
        if (SdkConstants.ACTION_MENU_VIEW.isEquals(viewTag)) {
            return new ActionMenuViewHandler();
        }
        if (SdkConstants.APP_BAR_LAYOUT.isEquals(viewTag)) {
            return new AppBarLayoutHandler();
        }
        if (SdkConstants.BOTTOM_NAVIGATION_VIEW.isEquals(viewTag)) {
            return new BottomNavigationViewHandler();
        }
        if (SdkConstants.BROWSE_FRAGMENT.isEquals(viewTag)) {
            return new BrowseFragmentHandler();
        }
        if (SdkConstants.CARD_VIEW.isEquals(viewTag)) {
            return new CardViewHandler();
        }
        if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(viewTag)) {
            return new ConstraintLayoutBarrierHandler();
        }
        if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_CHAIN.isEquals(viewTag)) {
            return new ConstraintLayoutChainHandler();
        }
        if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_HELPER.isEquals(viewTag)) {
            return new ConstraintHelperHandler();
        }
        if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.isEquals(viewTag)) {
            return new ConstraintLayoutLayerHandler();
        }
        if (SdkConstants.COLLAPSING_TOOLBAR_LAYOUT.isEquals(viewTag)) {
            return new CollapsingToolbarLayoutHandler();
        }
        if (SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEquals(viewTag)) {
            return new ConstraintLayoutGuidelineHandler();
        }
        if (SdkConstants.CONSTRAINT_LAYOUT.isEquals(viewTag)) {
            return new ConstraintLayoutHandler();
        }
        if (SdkConstants.COORDINATOR_LAYOUT.isEquals(viewTag)) {
            return new CoordinatorLayoutHandler();
        }
        if (SdkConstants.DETAILS_FRAGMENT.isEquals(viewTag)) {
            return new DetailsFragmentHandler();
        }
        if (SdkConstants.DRAWER_LAYOUT.isEquals(viewTag)) {
            return new DrawerLayoutHandler();
        }
        if (SdkConstants.FLOATING_ACTION_BUTTON.isEquals(viewTag)) {
            return new FloatingActionButtonHandler();
        }
        if (SdkConstants.GRID_LAYOUT_V7.isEquals(viewTag)) {
            return new GridLayoutV7Handler();
        }
        if (SdkConstants.MOTION_LAYOUT.isEquals(viewTag)) {
            if (((Boolean)StudioFlags.NELE_MOTION_LAYOUT_EDITOR.get()).booleanValue()) {
                return new MotionLayoutHandler();
            }
        } else {
            if (SdkConstants.NAVIGATION_VIEW.isEquals(viewTag)) {
                return new NavigationViewHandler();
            }
            if (SdkConstants.NESTED_SCROLL_VIEW.isEquals(viewTag)) {
                return new NestedScrollViewHandler();
            }
            if (SdkConstants.PLAYBACK_OVERLAY_FRAGMENT.isEquals(viewTag)) {
                return new PlaybackOverlayFragmentHandler();
            }
            if (SdkConstants.RECYCLER_VIEW.isEquals(viewTag)) {
                return new RecyclerViewHandler();
            }
            if (SdkConstants.SEARCH_FRAGMENT.isEquals(viewTag)) {
                return new SearchFragmentHandler();
            }
            if (SdkConstants.SNACKBAR.isEquals(viewTag)) {
                return STANDARD_HANDLER;
            }
        }
        if (SdkConstants.TAB_ITEM.isEquals(viewTag)) {
            return new TabItemHandler();
        }
        if (SdkConstants.TAB_LAYOUT.isEquals(viewTag)) {
            return new TabLayoutHandler();
        }
        if (SdkConstants.TABLE_CONSTRAINT_LAYOUT.isEquals(viewTag)) {
            return new ConstraintLayoutHandler();
        }
        if (SdkConstants.TEXT_INPUT_LAYOUT.isEquals(viewTag)) {
            return new TextInputLayoutHandler();
        }
        if (SdkConstants.TOOLBAR_V7.isEquals(viewTag)) {
            return new ToolbarHandler();
        }
        if (SdkConstants.VIEW_PAGER.isEquals(viewTag)) {
            return new ViewPagerHandler();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        ViewHandler builtInHandler = this.createBuiltInHandler(viewTag);
        if (builtInHandler != null) {
            return builtInHandler;
        }
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    String qualifiedClassName = this.getFullyQualifiedClassName(viewTag);
                    if (qualifiedClassName != null) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
                        PsiClass[] classes = facade.findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                        if (classes.length == 0) {
                            for (PsiClass cls : classes = facade.findClasses(qualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject))) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : classes) {
                                System.out.println("Find view handler " + cls.getQualifiedName() + " of type " + cls.getClass().getName());
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    @Nullable
    private String getFullyQualifiedClassName(@NotNull String viewTag) {
        if (viewTag.indexOf(46) > 0) {
            return viewTag;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        for (String packageName : NO_PREFIX_PACKAGES) {
            PsiClass[] classes = facade.findClasses(packageName + viewTag, GlobalSearchScope.allScope((Project)this.myProject));
            if (classes.length <= 0) continue;
            return packageName + viewTag;
        }
        return null;
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler) {
        ArrayList actions2 = this.myToolbarActions.get(handler);
        if (actions2 == null) {
            actions2 = Lists.newArrayList();
            handler.addToolbarActions(actions2);
            this.myToolbarActions.put(handler, actions2);
        }
        return actions2;
    }

    @NotNull
    public List<ViewAction> getPopupMenuActions(@NotNull SceneComponent component, @NotNull ViewHandler handler) {
        ArrayList actions2 = this.myMenuActions.get(handler);
        if (actions2 == null && handler.addPopupMenuActions(component, actions2 = Lists.newArrayList())) {
            this.myMenuActions.put(handler, actions2);
        }
        return actions2;
    }

    public void projectClosed() {
        this.myHandlers.clear();
    }

    public void disposeComponent() {
        this.myHandlers.clear();
    }

    @NotNull
    public String getComponentName() {
        return "ViewHandlerManager";
    }
}

