/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.utils.Pair;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentModification
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final NlComponentDelegate myComponentDelegate;
    private final String myLabel;
    HashMap<Pair<String, String>, String> myAttributes = new HashMap();

    public ComponentModification(@NotNull NlComponent component, @NotNull String label) {
        this.myComponent = component;
        this.myLabel = label;
        this.myComponentDelegate = this.myComponent.getDelegate();
        List<AttributeSnapshot> attributeSnapshots = component.getAttributes();
        for (AttributeSnapshot snapshot : attributeSnapshots) {
            this.setAttribute(snapshot.namespace, snapshot.name, snapshot.value);
        }
    }

    public NlComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value2) {
        this.myAttributes.put((Pair<String, String>)Pair.of((Object)namespace, (Object)name), value2);
    }

    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        return this.myAttributes.get(Pair.of((Object)namespace, (Object)attribute));
    }

    public HashMap<Pair<String, String>, String> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void removeAttribute(@NotNull String namespace, @NotNull String name) {
        this.myAttributes.remove(Pair.of((Object)namespace, (Object)name));
    }

    public void apply() {
        if (this.myComponentDelegate != null && this.myComponentDelegate.handlesApply(this)) {
            this.myComponentDelegate.apply(this);
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value2 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value2);
            }
            transaction.apply();
        } else {
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value3 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value3);
            }
            transaction.apply();
        }
    }

    public void commit() {
        if (this.myComponentDelegate != null && this.myComponentDelegate.handlesCommit(this)) {
            this.myComponentDelegate.commit(this);
            this.myComponent.clearTransaction();
            AttributesTransaction transaction = null;
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                if (this.myComponentDelegate.commitToMotionScene(key)) continue;
                String value2 = this.myAttributes.get(key);
                if (transaction == null) {
                    transaction = this.myComponent.startAttributeTransaction();
                }
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value2);
            }
            if (transaction != null) {
                transaction.apply();
                NlWriteCommandActionUtil.run(this.myComponent, this.myLabel, transaction::commit);
            }
        } else {
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value3 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value3);
            }
            transaction.apply();
            NlWriteCommandActionUtil.run(this.myComponent, this.myLabel, transaction::commit);
        }
    }

    public void commitTo(XmlTag view) {
        for (Pair<String, String> key : this.myAttributes.keySet()) {
            String value2 = this.myAttributes.get(key);
            if (this.myComponentDelegate != null && !this.myComponentDelegate.commitToMotionScene(key)) continue;
            String namespace = (String)key.getFirst();
            if (namespace.equalsIgnoreCase("http://schemas.android.com/tools")) {
                namespace = "http://schemas.android.com/apk/res-auto";
            }
            view.setAttribute((String)key.getSecond(), namespace, value2);
        }
    }
}

