/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.resources.ResourceType;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.handlers.constraint.ScrollToViewFocusListener;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarginWidget
extends JComboBox<String> {
    private static final String POPUP_MENU = "@ ...";
    private static final String DEFAULT = "0";
    private static final String PICK_A_DIMENSION = "Pick a Dimension";
    private static final String[] MENU_LIST = new String[]{"0", "8", "16", "24", "32", "@ ..."};
    private final String myBaseToolTipText;
    private final JTextField myTextField;

    public MarginWidget(@NotNull String name, String tooltip) {
        super(new CollectionComboBoxModel(Arrays.asList(MENU_LIST)));
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.setEditable(true);
        this.myTextField = (JTextField)this.getEditor().getEditorComponent();
        this.myTextField.setFont(this.myTextField.getFont().deriveFont((float)JBUI.scaleFontSize((float)12.0f)));
        this.myTextField.addFocusListener(new ScrollToViewFocusListener(this));
        this.initComboBox(name);
        this.setName(name);
        this.setToolTipText(tooltip);
        this.myBaseToolTipText = tooltip;
    }

    private void italicFont() {
        Font font = this.myTextField.getFont();
        int style = font.getStyle();
        font = font.deriveFont(style |= 2);
        this.myTextField.setFont(font);
    }

    private void normalFont() {
        Font font = this.myTextField.getFont();
        int style = font.getStyle();
        font = font.deriveFont(style &= 0xFFFFFFFD);
        this.myTextField.setFont(font);
    }

    private void updateToolTip(@Nullable String resourceName) {
        if (resourceName == null) {
            this.setToolTipText(this.myBaseToolTipText);
            return;
        }
        this.setToolTipText(this.myBaseToolTipText + " (" + resourceName + ")");
    }

    private void initComboBox(@NotNull String name) {
        this.setAlignmentX(1.0f);
        this.setEditable(true);
        this.setName(name + "ComboBox");
    }

    public void setMargin(int margin) {
        String marginText = String.valueOf(margin);
        if (this.getSelectedItem().equals(marginText)) {
            return;
        }
        this.setSelectedItem(marginText);
    }

    public String getMargin(@Nullable NlComponent component) {
        String toReturn;
        String item = (String)this.getSelectedItem();
        String string = toReturn = item != null ? item : DEFAULT;
        if (POPUP_MENU.equals(toReturn)) {
            toReturn = this.selectFromResourceDialog(component);
        }
        if (toReturn.startsWith("@")) {
            this.italicFont();
            this.updateToolTip(toReturn);
        } else {
            this.normalFont();
            this.updateToolTip(null);
        }
        return toReturn;
    }

    private String selectFromResourceDialog(@Nullable NlComponent component) {
        if (component == null) {
            return DEFAULT;
        }
        Module module = component.getModel().getModule();
        XmlTag tag = component.getBackend().getTag();
        if (tag == null) {
            return DEFAULT;
        }
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        types.add(ResourceType.DIMEN);
        ChooseResourceDialog dialog2 = ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(DEFAULT).setTag(tag).setDefaultType(ResourceType.DIMEN).build();
        dialog2.setTitle(PICK_A_DIMENSION);
        if (dialog2.showAndGet()) {
            return dialog2.getResourceName();
        }
        return DEFAULT;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject != null && anObject.equals(this.getSelectedItem())) {
            return;
        }
        super.setSelectedItem(anObject);
        if (this.hasFocus()) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener2) {
        super.addActionListener(actionListener2);
    }

    public static enum Show {
        IN_WIDGET,
        OUT_WIDGET,
        OUT_PANEL;

    }
}

