/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import java.util.Arrays;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetConstraintModel
implements SelectionListener {
    private static final String[][] ourConstraintString_ltr = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourConstraintString_rtl = new String[][]{{"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourMarginString_ltr = new String[][]{{"layout_marginLeft", "layout_marginStart"}, {"layout_marginRight", "layout_marginEnd"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourMarginString_rtl = new String[][]{{"layout_marginLeft", "layout_marginEnd"}, {"layout_marginRight", "layout_marginStart"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourDeleteAttributes_ltr = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourDeleteAttributes_rtl = new String[][]{{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourDeleteNamespace = new String[][]{{"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto"}};
    private static final String[][] ourOverConstrainedAttributes = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf"}, {"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf"}, {"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}};
    public static final int CONNECTION_LEFT = 0;
    public static final int CONNECTION_RIGHT = 1;
    public static final int CONNECTION_TOP = 2;
    public static final int CONNECTION_BOTTOM = 3;
    public static final int CONNECTION_BASELINE = 4;
    private static final int DELAY_BEFORE_COMMIT = 400;
    private boolean myIsInCallback = false;
    private Runnable myUpdateCallback;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private NlModel myModel;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private Object previousSecondarySelection = null;
    @NotNull
    private final ChangeListener myChangeLiveListener = e -> this.fireUIUpdate();
    @NotNull
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            WidgetConstraintModel.this.fireUIUpdate();
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model2, boolean animate) {
            WidgetConstraintModel.this.fireUIUpdate();
        }
    };
    @Nullable
    private ComponentModification myModification;
    @NotNull
    private final Timer myTimer = new Timer(400, c -> {
        if (this.myModification != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    WidgetConstraintModel.this.myModification.commit();
                    WidgetConstraintModel.this.myModification = null;
                }
            });
        }
    });

    private void fireUIUpdate() {
        if (this.myUpdateCallback != null) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                this.myIsInCallback = true;
                try {
                    this.myUpdateCallback.run();
                }
                finally {
                    this.myIsInCallback = false;
                }
            }, (ModalityState)ModalityState.any());
        }
    }

    public WidgetConstraintModel(@NotNull Runnable modelUpdateCallback) {
        this.myUpdateCallback = modelUpdateCallback;
    }

    void setUpdateCallback(@NotNull Runnable modelUpdateCallback) {
        this.myUpdateCallback = modelUpdateCallback;
    }

    public int getMargin(int type) {
        if (this.myComponent == null) {
            return 0;
        }
        boolean rtl = ConstraintUtilities.isInRTL(this.myComponent);
        String[][] marginsAttr = rtl ? ourMarginString_rtl : ourMarginString_ltr;
        String marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][0]);
        for (int i2 = 1; marginString == null && marginsAttr[type].length > i2; ++i2) {
            marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][i2]);
        }
        int margin = 0;
        if (marginString != null) {
            margin = ConstraintUtilities.getDpValue(this.myComponent, marginString);
        }
        String[][] ourConstraintString = rtl ? ourConstraintString_rtl : ourConstraintString_ltr;
        String connection = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][0]);
        for (int i3 = 1; connection == null && i3 < ourConstraintString[type].length; ++i3) {
            connection = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][i3]);
        }
        if (connection == null) {
            margin = -1;
        }
        return margin;
    }

    public void setMargin(int type, String margin) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        boolean rtl = ConstraintUtilities.isInRTL(this.myComponent);
        String[][] marginsAttr = rtl ? ourMarginString_rtl : ourMarginString_ltr;
        for (int i2 = 0; i2 < marginsAttr[type].length; ++i2) {
            this.setDimension(marginsAttr[type][i2], margin);
        }
    }

    public boolean hasBaseline() {
        return this.myComponent != null && this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    public void setSurface(@Nullable DesignSurface surface) {
        if (surface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().removeListener(this);
        }
        this.mySurface = surface;
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().addListener(this);
        }
        this.fireUIUpdate();
    }

    @Nullable
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (this.myComponent == null || !selection.contains(this.myComponent)) {
            this.previousSecondarySelection = null;
        }
        if (!model2.isSecondarySelected(this.previousSecondarySelection)) {
            this.previousSecondarySelection = model2.getSecondarySelection();
        }
        this.fireUIUpdate();
    }

    public void setComponent(@Nullable NlComponent component) {
        if (this.myModel != null) {
            this.myModel.removeListener(this.myModelListener);
        }
        if (this.myComponent != null) {
            this.myComponent.removeLiveChangeListener(this.myChangeLiveListener);
        }
        this.myComponent = WidgetConstraintModel.isApplicable(component) ? component : null;
        NlModel nlModel = this.myModel = this.myComponent != null ? this.myComponent.getModel() : null;
        if (this.myModel != null) {
            this.myModel.addListener(this.myModelListener);
        }
        if (this.myComponent != null) {
            this.myComponent.addLiveChangeListener(this.myChangeLiveListener);
            this.fireUIUpdate();
        }
    }

    @Nullable
    public NlComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public String getRatioString() {
        return this.myComponent == null ? null : this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
    }

    private static boolean isApplicable(@Nullable NlComponent component) {
        if (component == null) {
            return false;
        }
        NlComponent parent = component.getParent();
        return parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT);
    }

    public void removeAttributes(@NotNull String namespace, @NotNull String attribute) {
        NlComponent component = this.myComponent;
        if (component == null || this.myIsInCallback) {
            return;
        }
        ComponentModification modification = new ComponentModification(component, "Change Widget");
        modification.setAttribute(namespace, attribute, null);
        ConstraintComponentUtilities.ensureHorizontalPosition(component, modification);
        ConstraintComponentUtilities.ensureVerticalPosition(component, modification);
        modification.apply();
        modification.commit();
    }

    public void killConstraint(@NotNull ConstraintAnchor.Type type) {
        switch (type) {
            case LEFT: {
                this.removeAttribute(0);
                break;
            }
            case TOP: {
                this.removeAttribute(2);
                break;
            }
            case RIGHT: {
                this.removeAttribute(1);
                break;
            }
            case BOTTOM: {
                this.removeAttribute(3);
                break;
            }
            case BASELINE: {
                this.removeAttribute(4);
                break;
            }
        }
    }

    private void removeAttribute(int type) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        boolean rtl = ConstraintUtilities.isInRTL(this.myComponent);
        String label = "Constraint Disconnected";
        String[] attribute = rtl ? ourDeleteAttributes_rtl[type] : ourDeleteAttributes_ltr[type];
        String[] namespace = ourDeleteNamespace[type];
        ComponentModification modification = new ComponentModification(this.myComponent, label);
        for (int i2 = 0; i2 < attribute.length; ++i2) {
            modification.setAttribute(namespace[i2], attribute[i2], null);
        }
        ConstraintComponentUtilities.ensureHorizontalPosition(this.myComponent, modification);
        ConstraintComponentUtilities.ensureVerticalPosition(this.myComponent, modification);
        modification.apply();
        modification.commit();
    }

    public void setHorizontalBias(int biasPercent) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        float bias = (float)biasPercent / 100.0f;
        String biasString = biasPercent == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintModel.findHorizontalChainHead(this.myComponent);
        if (chain != null && chain != this.myComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintHorizontal_bias", biasString);
        }
    }

    public void setVerticalBias(int biasPercent) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        float bias = 1.0f - (float)biasPercent / 100.0f;
        String biasString = biasPercent == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintModel.findVerticalChainHead(this.myComponent);
        if (chain != null && chain != this.myComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintVertical_bias", biasString);
        }
    }

    public float getVerticalBias() {
        String verticalBias = this.getVerticalBiasString();
        return WidgetConstraintModel.parseBiasStringFloat(verticalBias);
    }

    public float getHorizontalBias() {
        String horizontalBias = this.getHorizontalBiasString();
        return WidgetConstraintModel.parseBiasStringFloat(horizontalBias);
    }

    @Nullable
    public String getVerticalBiasString() {
        if (this.myComponent == null) {
            return null;
        }
        NlComponent source = WidgetConstraintModel.findVerticalChainHead(this.myComponent);
        if (source == null) {
            source = this.myComponent;
        }
        return source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
    }

    @Nullable
    public String getHorizontalBiasString() {
        if (this.myComponent == null) {
            return null;
        }
        NlComponent source = WidgetConstraintModel.findHorizontalChainHead(this.myComponent);
        if (source == null) {
            source = this.myComponent;
        }
        return source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
    }

    private static float parseBiasStringFloat(@Nullable String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.5f;
    }

    private int getDimension(@NotNull String attribute) {
        if (this.myComponent == null) {
            return 0;
        }
        String v = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        if ("wrap_content".equalsIgnoreCase(v)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(this.myComponent, v);
    }

    private void setDimension(@Nullable String attribute, String currentValue) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        attribute = ConstraintComponentUtilities.mapStartEndStrings(this.myComponent, attribute);
        boolean isCurrentValueReference = currentValue.startsWith("@");
        if (isCurrentValueReference) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, currentValue);
            return;
        }
        int currentValueInInt = 0;
        try {
            currentValueInInt = Integer.parseInt(currentValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = ConstraintComponentUtilities.getDpValue(this.myComponent, this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute));
        }
        if (marginValue != -1 && marginValue == currentValueInInt) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValueInInt);
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    private void setAndroidAttribute(@NotNull String attribute, @Nullable String value2) {
        this.setAttribute("http://schemas.android.com/apk/res/android", attribute, value2);
    }

    private void setSherpaAttribute(@NotNull String attribute, @Nullable String value2) {
        this.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value2);
    }

    private void setAttribute(@NotNull String nameSpace, @NotNull String attribute, @Nullable String value2) {
        if (this.myComponent != null) {
            this.setAttribute(this.myComponent, nameSpace, attribute, value2);
        }
    }

    private void setAttribute(@NotNull NlComponent component, @NotNull String nameSpace, @NotNull String attribute, @Nullable String value2) {
        NlModel model2 = component.getModel();
        if (this.myModification == null || this.myModification.getComponent() != component) {
            this.myModification = new ComponentModification(component, "Change Widget");
        }
        this.myModification.setAttribute(nameSpace, attribute, value2);
        this.myModification.apply();
        model2.notifyLiveUpdate(false);
        this.myTimer.setRepeats(false);
        this.myTimer.restart();
    }

    public int convertFromNL(@NotNull String attribute) {
        if (this.myComponent == null) {
            return 2;
        }
        int dimen = this.getDimension(attribute);
        switch (dimen) {
            default: {
                return 0;
            }
            case -1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    @Nullable
    public static NlComponent findHorizontalChainHead(@NotNull NlComponent component) {
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
        }
        return null;
    }

    @Nullable
    public static NlComponent findVerticalChainHead(@NotNull NlComponent component) {
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes);
        }
        return null;
    }

    public void setAspect(String aspect) {
        this.setSherpaAttribute("layout_constraintDimensionRatio", aspect);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        String width = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (width == null) {
            width = "wrap_content";
        }
        if (width.endsWith("dp") && !width.equals("0dp")) {
            this.myComponent.putClientProperty("layout_width", width);
        }
        switch (horizontalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_width", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.myComponent.getClientProperty("layout_width");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.myComponent.getModel(), NlComponentHelperKt.getW(this.myComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_width", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_width", "wrap_content");
            }
        }
    }

    public void setVerticalConstraint(int verticalConstraint) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        String height = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (height == null) {
            height = "wrap_content";
        }
        if (height.endsWith("dp") && !height.equals("0dp")) {
            this.myComponent.putClientProperty("layout_height", height);
        }
        switch (verticalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_height", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.myComponent.getClientProperty("layout_height");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.myComponent.getModel(), NlComponentHelperKt.getH(this.myComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_height", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_height", "wrap_content");
            }
        }
    }

    public boolean isMissingHorizontalConstrained() {
        if (this.myComponent != null) {
            String tagName = this.myComponent.getTagName();
            if (SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEquals(tagName) || SdkConstants.CONSTRAINT_LAYOUT_BARRIER.isEquals(tagName)) {
                return false;
            }
            return !ConstraintComponentUtilities.hasHorizontalConstraints(this.myComponent);
        }
        return false;
    }

    public boolean isMissingVerticalConstrained() {
        if (this.myComponent != null) {
            String tagName = this.myComponent.getTagName();
            if (SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEquals(tagName) || SdkConstants.CONSTRAINT_LAYOUT_BARRIER.isEquals(tagName)) {
                return false;
            }
            return !ConstraintComponentUtilities.hasVerticalConstraints(this.myComponent);
        }
        return false;
    }

    public boolean isOverConstrained() {
        if (this.myComponent != null) {
            for (String[] overConstrainedSet : ourOverConstrainedAttributes) {
                if (Arrays.stream(overConstrainedSet).filter(s -> this.myComponent.getAttribute("http://schemas.android.com/apk/res-auto", (String)s) != null).count() <= 1L) continue;
                return true;
            }
        }
        return false;
    }
}

