/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnimatedFrame;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutDecorator
extends SceneDecorator {
    public static final String CONSTRAINT_HOVER = "CONSTRAINT_HOVER";
    private static boolean ourBlockSelection = (Boolean)StudioFlags.NELE_CONSTRAINT_SELECTOR.get() == false;
    private static final String[] LEFT_DIR = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[] TOP_DIR = new String[]{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"};
    private static final String[] BOTTOM_DIR = new String[]{"layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf"};
    private static final String[] LEFT_DIR_RTL = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR_RTL = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[][] ourConnections = new String[][]{LEFT_DIR, RIGHT_DIR, TOP_DIR, BOTTOM_DIR};
    private static final String[][] ourConnections_rtl = new String[][]{LEFT_DIR_RTL, RIGHT_DIR_RTL, TOP_DIR, BOTTOM_DIR};
    private static final String BASELINE = "BASELINE";
    private static final String[] BASELINE_DIR = new String[]{"layout_constraintBaseline_toBaselineOf"};
    private static final String BASELINE_TYPE = "BASELINE_TYPE";
    private static final String[][] MARGIN_ATTR_LTR = new String[][]{{"layout_marginStart", "layout_marginLeft"}, {"layout_marginEnd", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] MARGIN_ATTR_RTL = new String[][]{{"layout_marginEnd", "layout_marginLeft"}, {"layout_marginStart", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[] BIAS_ATTR = new String[]{"layout_constraintHorizontal_bias", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintVertical_bias"};
    private static final boolean[] FLIP_BIAS = new boolean[]{true, false, false, true};
    private static final ConnectionType[] DIR_TABLE = new ConnectionType[]{ConnectionType.SAME, ConnectionType.BACKWARD, ConnectionType.SAME, ConnectionType.BACKWARD};
    private static final String[] ourDirections = new String[]{"LEFT", "RIGHT", "TOP", "BOTTOM"};
    private static final String[] ourChainDirections = new String[]{"CHAIN_LEFT", "CHAIN_RIGHT", "CHAIN_TOP", "CHAIN_BOTTOM"};
    private static final String[] ourDirectionsType = new String[]{"LEFT_TYPE", "RIGHT_TYPE", "TOP_TYPE", "BOTTOM_TYPE"};
    private static final AnchorTarget.Type[] ourAnchorTypes = new AnchorTarget.Type[]{AnchorTarget.Type.LEFT, AnchorTarget.Type.RIGHT, AnchorTarget.Type.TOP, AnchorTarget.Type.BOTTOM};
    private static final boolean[] isLeftRight = new boolean[]{true, true, false, false};
    private static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};

    private static void convert(@NotNull SceneContext sceneContext, Rectangle rect) {
        rect.x = sceneContext.getSwingXDip(rect.x);
        rect.y = sceneContext.getSwingYDip(rect.y);
        rect.width = sceneContext.getSwingDimensionDip(rect.width);
        rect.height = sceneContext.getSwingDimensionDip(rect.height);
    }

    private static void gatherProperties(@NotNull SceneComponent component, @NotNull SceneComponent child) {
        boolean rtl = component.getScene().isInRTL();
        String[][] connections = rtl ? ourConnections_rtl : ourConnections;
        for (int i2 = 0; i2 < ourDirections.length; ++i2) {
            ConstraintLayoutDecorator.getConnection(component, child, connections[i2], ourDirections[i2], ourDirectionsType[i2]);
        }
        ConstraintLayoutDecorator.getConnection(component, child, BASELINE_DIR, BASELINE, BASELINE_TYPE);
    }

    private static void getConnection(SceneComponent component, SceneComponent child, String[] atributes, String dir, String dirType) {
        String id = null;
        ConnectionType type = ConnectionType.SAME;
        for (int i2 = 0; i2 < atributes.length; ++i2) {
            id = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", atributes[i2]);
            type = DIR_TABLE[i2];
            if (id != null) break;
        }
        if (id == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (id.equalsIgnoreCase("parent")) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        String cleanId = NlComponent.extractId(id);
        if (cleanId == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (cleanId.equals(component.getId())) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        for (SceneComponent con : component.getChildren()) {
            if (!cleanId.equals(con.getId())) continue;
            child.myCache.put(dir, con);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        child.myCache.put(dirType, (Object)ConnectionType.SAME);
    }

    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        List<SceneComponent> children = component.getChildren();
        if (!children.isEmpty()) {
            for (SceneComponent child : component.getChildren()) {
                ConstraintLayoutDecorator.gatherProperties(component, child);
            }
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            list.pushClip(sceneContext, rect);
            Scene scene = component.getScene();
            boolean showAllConstraints = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowAllConstraints");
            List<NlComponent> selection = scene.getSelection();
            for (SceneComponent child : children) {
                child.buildDisplayList(time2, list, sceneContext);
                if (sceneContext.showOnlySelection() && !child.isSelected() || (!showAllConstraints || scene.getRoot() != component) && !selection.contains(child.getNlComponent())) continue;
                ConstraintLayoutDecorator.buildListConnections(list, time2, sceneContext, component, child);
            }
            list.popClip();
        }
    }

    private static void buildListConnections(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent constraintComponent, @NotNull SceneComponent child) {
        long changeStart;
        int i2;
        Rectangle dest_rect = new Rectangle();
        Rectangle source_rect = new Rectangle();
        child.fillDrawRect(time2, source_rect);
        ConstraintLayoutDecorator.convert(sceneContext, source_rect);
        ConnectionStatus connectStatus = new ConnectionStatus();
        List<NlComponent> selection = constraintComponent.getScene().getSelection();
        NlComponent component = child.getNlComponent();
        int hover = -1;
        Object hover_obj = component.getClientProperty(CONSTRAINT_HOVER);
        if (hover_obj != null && hover_obj instanceof SecondarySelector.Constraint) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)hover_obj);
            hover = constraint.ordinal();
        }
        Object ss = constraintComponent.getScene().getSecondarySelection();
        int selectedDirection = -1;
        if (ss != null && ss instanceof SecondarySelector.Constraint) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)ss);
            selectedDirection = constraint.ordinal();
        }
        boolean constraintSelected = selectedDirection != -1;
        boolean anyViewSelected = selection != null && !selection.isEmpty();
        boolean fade = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceFadeUnselected");
        if (fade && selection.isEmpty()) {
            fade = false;
        }
        if (fade && selection.contains(component) && selection.size() == 1) {
            fade = false;
        }
        boolean viewSelected = selection.contains(child.getNlComponent());
        connectStatus.getConnectionInfo(child.getNlComponent(), viewSelected);
        ConnectionType[] connectionTypes = new ConnectionType[ourDirections.length];
        SceneComponent[] connectionTo = new SceneComponent[ourDirections.length];
        for (i2 = 0; i2 < ourDirections.length; ++i2) {
            connectionTypes[i2] = (ConnectionType)((Object)child.myCache.get(ourDirectionsType[i2]));
            Object obj = child.myCache.get(ourDirections[i2]);
            connectionTo[i2] = obj instanceof SceneComponent ? (SceneComponent)obj : null;
        }
        for (i2 = 0; i2 < ourDirections.length; ++i2) {
            boolean overlap;
            AnchorTarget anchorTarget;
            boolean shift;
            String biasString;
            int connect;
            boolean selectedConnection = selectedDirection == i2 && viewSelected;
            boolean hoverConnection = hover == i2;
            ConnectionType type = connectionTypes[i2];
            SceneComponent sc = connectionTo[i2];
            int destType = 0;
            if (sc == null) continue;
            sc.fillDrawRect(time2, dest_rect);
            ConstraintLayoutDecorator.convert(sceneContext, dest_rect);
            int n = connect = type == ConnectionType.SAME ? i2 : ourOppositeDirection[i2];
            if (child.getParent().equals(sc)) {
                destType = 1;
            } else if (SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent())) || SdkConstants.CONSTRAINT_LAYOUT_BARRIER.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent()))) {
                destType = 2;
            }
            int connectType = 1;
            if (connectionTo[ourOppositeDirection[i2]] != null) {
                connectType = 2;
                if (connectionTo[ourOppositeDirection[i2]] == sc && destType != 1) {
                    connectType = connectionTypes[ourOppositeDirection[i2]] != type ? 4 : 6;
                }
            }
            SceneComponent toComponentsTo = (SceneComponent)sc.myCache.get(ourDirections[connect]);
            if (type == ConnectionType.BACKWARD && toComponentsTo == child && sc.myCache.get(ourDirectionsType[connect]) == ConnectionType.BACKWARD) {
                connectType = 3;
                if (sc.myCache.containsKey(ourChainDirections[ourOppositeDirection[i2]])) continue;
            }
            int margin = 0;
            int marginDistance = 0;
            boolean isMarginReference = false;
            float bias = 0.5f;
            boolean rtl = constraintComponent.getScene().isInRTL();
            String[] margin_attr = rtl ? MARGIN_ATTR_RTL[i2] : MARGIN_ATTR_LTR[i2];
            String marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr[0]);
            if (marginString == null && margin_attr.length > 1) {
                marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr[1]);
            }
            if (marginString == null) {
                if (i2 == 0) {
                    marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
                } else if (i2 == 1) {
                    marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
                }
            }
            if (marginString != null) {
                if (marginString.startsWith("@")) {
                    isMarginReference = true;
                }
                margin = ConstraintUtilities.getDpValue(child.getAuthoritativeNlComponent(), marginString);
                marginDistance = sceneContext.getSwingDimensionDip(margin);
            }
            if ((biasString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", BIAS_ATTR[i2])) != null) {
                try {
                    bias = Float.parseFloat(biasString);
                    if (FLIP_BIAS[i2]) {
                        bias = 1.0f - bias;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = shift = toComponentsTo != null;
            if (destType == 2) {
                connect = ourOppositeDirection[i2];
            }
            boolean onDelete = (anchorTarget = AnchorTarget.findAnchorTarget(child, ourAnchorTypes[i2])) != null && anchorTarget.canDisconnect() && anchorTarget.isMouseHovered();
            changeStart = connectStatus.getTime(i2);
            int previousMode = connectStatus.getPreviousMode(i2);
            int currentMode = connectStatus.getCurrentMode(i2, selectedConnection, fade, constraintSelected, anyViewSelected, hoverConnection, onDelete);
            int x1 = ConstraintLayoutDecorator.getX(source_rect, i2);
            int x2 = ConstraintLayoutDecorator.getX(dest_rect, connect);
            int y1 = ConstraintLayoutDecorator.getY(source_rect, i2);
            int y2 = ConstraintLayoutDecorator.getY(dest_rect, connect);
            boolean bl2 = overlap = i2 != connect && (isLeftRight[i2] && Math.abs(x1 - x2) < 4 && Math.abs(y1 - y2) < dest_rect.height / 2 || !isLeftRight[i2] && Math.abs(y1 - y2) < 4 && Math.abs(x1 - x2) < dest_rect.width / 2);
            if (overlap) {
                connectType = 7;
            }
            if (!ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowMargins")) {
                margin = 0;
                marginDistance = 0;
            }
            DrawConnection.buildDisplayList(list, ourBlockSelection ? null : SecondarySelector.get(child.getNlComponent(), SecondarySelector.Constraint.values()[i2]), connectType, source_rect, i2, dest_rect, connect, destType, shift, margin, marginDistance, isMarginReference, Float.valueOf(bias), previousMode, currentMode, changeStart);
            if ((anchorTarget == null || !anchorTarget.isMouseHovered()) && !hoverConnection || !viewSelected) continue;
            if (destType == 2) {
                int over_size_line = 3000;
                dest_rect.grow(connect < 2 ? 1 : over_size_line, connect < 2 ? over_size_line : 1);
            }
            boolean drawFrameAsDelete = (currentMode & 0xFFFFFEFF) == 6;
            DrawAnimatedFrame.add(list, dest_rect, connect, drawFrameAsDelete);
        }
        SceneComponent baseLineConnection = (SceneComponent)child.myCache.get(BASELINE);
        if (baseLineConnection != null) {
            baseLineConnection.fillDrawRect(time2, dest_rect);
            ConstraintLayoutDecorator.convert(sceneContext, dest_rect);
            int dest_offset = sceneContext.getSwingDimensionDip(baseLineConnection.getBaseline());
            int source_offset = sceneContext.getSwingDimensionDip(child.getBaseline());
            source_rect.y += source_offset;
            source_rect.height = 0;
            dest_rect.y += dest_offset;
            dest_rect.height = 0;
            changeStart = connectStatus.getTime(4);
            AnchorTarget anchorTarget = AnchorTarget.findAnchorTarget(child, AnchorTarget.Type.BASELINE);
            boolean onDelete = anchorTarget != null && anchorTarget.canDisconnect() && anchorTarget.isMouseHovered();
            int previousMode = connectStatus.getPreviousMode(4);
            boolean selectedConnection = selectedDirection == SecondarySelector.Constraint.BASELINE.ordinal() && viewSelected;
            boolean hoverConnection = hover == SecondarySelector.Constraint.BASELINE.ordinal();
            int currentMode = connectStatus.getCurrentMode(4, selectedConnection, fade, constraintSelected, anyViewSelected, hoverConnection, onDelete);
            DrawConnection.buildDisplayList(list, ourBlockSelection ? null : SecondarySelector.get(child.getNlComponent(), SecondarySelector.Constraint.BASELINE), 5, source_rect, 5, dest_rect, 5, 0, false, 0, 0, false, Float.valueOf(0.0f), previousMode, currentMode, changeStart);
        }
    }

    private static int getX(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.x;
            }
            case 1: {
                return rectangle.x + rectangle.width + 1;
            }
            case 2: {
                return rectangle.x + rectangle.width / 2;
            }
            case 3: {
                return rectangle.x + rectangle.width / 2;
            }
        }
        return 0;
    }

    private static int getY(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.y + rectangle.height / 2;
            }
            case 1: {
                return rectangle.y + rectangle.height / 2;
            }
            case 2: {
                return rectangle.y;
            }
            case 3: {
                return rectangle.y + rectangle.height + 1;
            }
        }
        return 0;
    }

    static class ConnectionStatus {
        static String[] connectTypes = new String[]{"left", "right", "north", "bottom", "baseline"};
        public static final int DIRECTION_BASELINE = 4;
        int[] mPrevious = new int[connectTypes.length];
        int[] mCurrent = new int[connectTypes.length];
        long[] mStartTime = new long[connectTypes.length];
        DecoratorUtilities.ViewStates componentPrevState;
        DecoratorUtilities.ViewStates componentCurrentState;
        Long componentChangeStateTime;
        boolean mMyViewSelected = true;

        ConnectionStatus() {
        }

        void getConnectionInfo(NlComponent c, boolean isSelected) {
            this.componentPrevState = DecoratorUtilities.getTimedChange_prev(c, "view");
            this.componentCurrentState = DecoratorUtilities.getTimedChange_value(c, "view");
            this.componentChangeStateTime = DecoratorUtilities.getTimedChange_time(c, "drawState");
            this.mMyViewSelected = isSelected;
            for (int i2 = 0; i2 < connectTypes.length; ++i2) {
                DecoratorUtilities.ViewStates current;
                String type = connectTypes[i2];
                if (this.componentCurrentState != DecoratorUtilities.ViewStates.SELECTED && (current = DecoratorUtilities.getTimedChange_value(c, type)) == DecoratorUtilities.ViewStates.SELECTED) {
                    long t = this.componentChangeStateTime != null ? this.componentChangeStateTime : System.nanoTime();
                    DecoratorUtilities.setTimeChange(c, type, t, current, DecoratorUtilities.ViewStates.NORMAL);
                }
                DecoratorUtilities.ViewStates prev = DecoratorUtilities.getTimedChange_prev(c, type);
                current = DecoratorUtilities.getTimedChange_value(c, type);
                Long event = DecoratorUtilities.getTimedChange_time(c, type);
                if (event != null) {
                    this.mStartTime[i2] = event;
                    this.mPrevious[i2] = prev.getVal();
                    this.mCurrent[i2] = current.getVal();
                    continue;
                }
                this.mStartTime[i2] = -1L;
            }
        }

        int getPreviousMode(int direction) {
            if (this.mStartTime[direction] == -1L) {
                if (this.componentPrevState == DecoratorUtilities.ViewStates.NORMAL) {
                    return 0;
                }
                return this.mCurrent[direction];
            }
            return this.mPrevious[direction];
        }

        int getCurrentMode(int direction, boolean thisConstraintSelected, boolean fade, boolean anyConstraintSelected, boolean anyViewSelected, boolean hoverConnection, boolean onDelete) {
            int hoverFlag;
            int ret = 0;
            int n = hoverFlag = hoverConnection ? 256 : 0;
            if (onDelete) {
                return hoverFlag | 6;
            }
            if (thisConstraintSelected) {
                return hoverFlag | 5;
            }
            if (anyConstraintSelected) {
                return hoverFlag | 1;
            }
            if (anyViewSelected && !this.mMyViewSelected) {
                return hoverFlag | 1;
            }
            ret = this.mStartTime[direction] == -1L ? this.mCurrent[direction] : this.mCurrent[direction];
            if (ret == 0 && fade) {
                ret = 1;
            }
            return hoverFlag | ret;
        }

        long getTime(int direction) {
            if (this.mStartTime[direction] == -1L) {
                return this.componentChangeStateTime == null ? 0L : this.componentChangeStateTime;
            }
            return this.mStartTime[direction];
        }
    }

    static enum ConnectionType {
        SAME,
        BACKWARD;

    }
}

