/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawBarrier
extends DrawRegion {
    private static final int GAP = 12;
    private int myDirection;
    private boolean myIsSelected;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myDirection + "," + this.myIsSelected;
    }

    public DrawBarrier(String s) {
        super(s);
    }

    @Override
    protected int parse(String[] sp, int c) {
        c = super.parse(sp, c);
        this.myDirection = Integer.parseInt(sp[c++]);
        this.myIsSelected = Boolean.parseBoolean(sp[c++]);
        return c;
    }

    public DrawBarrier(int x, int y, int size, int direction, boolean selected) {
        super(x, y, direction == 1 || direction == 2 ? size : 1, direction == 3 || direction == 4 ? size : 1);
        this.myDirection = direction;
        this.myIsSelected = selected;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color solid = this.myIsSelected ? colorSet.getSelectedFrames() : colorSet.getFrames();
        int baseRgb = solid.getRGB();
        int darkRgb = solid.darker().darker().getRGB();
        Color transparent1 = new Color(darkRgb & 0xFFFFFF | 0x8F000000, true);
        Color transparent2 = new Color(baseRgb & 0xFFFFFF, true);
        int dx = 0;
        int dy = 0;
        int w = 0;
        int h = 0;
        switch (this.myDirection) {
            case 1: {
                dy = -12;
                h = 12;
                break;
            }
            case 2: {
                dy = 12;
                h = 12;
                break;
            }
            case 3: {
                dx = -12;
                w = 12;
                break;
            }
            case 4: {
                dx = 12;
                w = 12;
            }
        }
        g.setColor(solid);
        Stroke previous = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x + this.width, this.y + this.height);
        GradientPaint p = new GradientPaint(this.x - dx, this.y - dy, transparent1, this.x + dx, this.y + dy, transparent2);
        g.setPaint(p);
        g.fillRect(this.x + (dx < 0 ? -12 : 0), this.y + (dy < 0 ? -12 : 0), this.width + w, this.height + h);
        g.setStroke(previous);
    }

    public static void add(DisplayList list, SceneContext transform2, float left2, float top, float size, int direction, boolean selected) {
        int l = transform2.getSwingXDip(left2);
        int t = transform2.getSwingYDip(top);
        int pixSze = transform2.getSwingDimensionDip(size);
        list.add(new DrawBarrier(l, t, pixSze, direction, selected));
    }
}

