/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Guideline;
import com.android.tools.idea.uibuilder.handlers.constraint.model.WidgetContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstraintWidgetContainer
extends WidgetContainer {
    int mPaddingLeft;
    int mPaddingTop;
    int mPaddingRight;
    int mPaddingBottom;
    int mHorizontalChainsSize = 0;
    int mVerticalChainsSize = 0;
    ConstraintWidget[] mVerticalChainsArray = new ConstraintWidget[4];
    ConstraintWidget[] mHorizontalChainsArray = new ConstraintWidget[4];
    private boolean mWidthMeasuredTooSmall = false;
    private boolean mHeightMeasuredTooSmall = false;

    public ConstraintWidgetContainer() {
    }

    public ConstraintWidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintWidgetContainer(int width, int height) {
        super(width, height);
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    @Override
    public void reset() {
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        super.reset();
    }

    public boolean isWidthMeasuredTooSmall() {
        return this.mWidthMeasuredTooSmall;
    }

    public boolean isHeightMeasuredTooSmall() {
        return this.mHeightMeasuredTooSmall;
    }

    public void setPadding(int left2, int top, int right2, int bottom2) {
        this.mPaddingLeft = left2;
        this.mPaddingTop = top;
        this.mPaddingRight = right2;
        this.mPaddingBottom = bottom2;
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i2 = 0; i2 < mChildrenSize; ++i2) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i2);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 1) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i2 = 0; i2 < mChildrenSize; ++i2) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i2);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 0) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    private void resetChains() {
        this.mHorizontalChainsSize = 0;
        this.mVerticalChainsSize = 0;
    }

    void addChain(ConstraintWidget constraintWidget, int type) {
        ConstraintWidget widget = constraintWidget;
        if (type == 0) {
            while (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget == widget.mLeft && widget.mLeft.mTarget.mOwner != widget) {
                widget = widget.mLeft.mTarget.mOwner;
            }
            this.addHorizontalChain(widget);
        } else if (type == 1) {
            while (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget == widget.mTop && widget.mTop.mTarget.mOwner != widget) {
                widget = widget.mTop.mTarget.mOwner;
            }
            this.addVerticalChain(widget);
        }
    }

    private void addHorizontalChain(ConstraintWidget widget) {
        for (int i2 = 0; i2 < this.mHorizontalChainsSize; ++i2) {
            if (this.mHorizontalChainsArray[i2] != widget) continue;
            return;
        }
        if (this.mHorizontalChainsSize + 1 >= this.mHorizontalChainsArray.length) {
            this.mHorizontalChainsArray = Arrays.copyOf(this.mHorizontalChainsArray, this.mHorizontalChainsArray.length * 2);
        }
        this.mHorizontalChainsArray[this.mHorizontalChainsSize] = widget;
        ++this.mHorizontalChainsSize;
    }

    private void addVerticalChain(ConstraintWidget widget) {
        for (int i2 = 0; i2 < this.mVerticalChainsSize; ++i2) {
            if (this.mVerticalChainsArray[i2] != widget) continue;
            return;
        }
        if (this.mVerticalChainsSize + 1 >= this.mVerticalChainsArray.length) {
            this.mVerticalChainsArray = Arrays.copyOf(this.mVerticalChainsArray, this.mVerticalChainsArray.length * 2);
        }
        this.mVerticalChainsArray[this.mVerticalChainsSize] = widget;
        ++this.mVerticalChainsSize;
    }
}

