/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawBarrier;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrierTarget
extends BaseTarget {
    int myDirection;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public static int parseDirection(String dir) {
        if ("TOP".equalsIgnoreCase(dir)) {
            return 1;
        }
        if ("BOTTOM".equalsIgnoreCase(dir)) {
            return 2;
        }
        if ("LEFT".equalsIgnoreCase(dir)) {
            return 3;
        }
        if ("RIGHT".equalsIgnoreCase(dir)) {
            return 4;
        }
        if ("START".equalsIgnoreCase(dir)) {
            return 3;
        }
        if ("END".equalsIgnoreCase(dir)) {
            return 4;
        }
        return 1;
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        return ImmutableList.of((Object)this.getComponent());
    }

    private boolean isHorizontal() {
        return this.myDirection == 1 || this.myDirection == 2;
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    public BarrierTarget(int direction) {
        this.myDirection = direction;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.isHorizontal()) {
            DrawBarrier.add(list, sceneContext, this.myLeft, this.myTop, this.myRight - this.myLeft, this.myDirection, this.myComponent.isSelected());
        } else {
            DrawBarrier.add(list, sceneContext, this.myLeft, this.myTop, this.myBottom - this.myTop, this.myDirection, this.myComponent.isSelected());
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int dist = 4;
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            this.myLeft = parent.getDrawX();
            this.myRight = parent.getDrawX() + parent.getDrawWidth();
            this.myTop = parent.getDrawY();
            this.myBottom = parent.getDrawY() + parent.getDrawHeight();
            switch (this.myDirection) {
                case 1: {
                    this.myTop = t;
                    this.myBottom = t + dist;
                    break;
                }
                case 2: {
                    this.myTop = t;
                    this.myBottom = t + dist;
                    break;
                }
                case 3: {
                    this.myLeft = l;
                    this.myRight = l + dist;
                    break;
                }
                case 4: {
                    this.myLeft = l;
                    this.myRight = l + dist;
                }
            }
        }
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myComponent.setSelected(true);
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    protected boolean isHittable() {
        return true;
    }

    @Override
    public String getToolTipText() {
        switch (this.myDirection) {
            case 1: {
                return "Barrier Top";
            }
            case 2: {
                return "Barrier Bottom";
            }
            case 3: {
                return "Barrier Left";
            }
            case 4: {
                return "Barrier Right";
            }
        }
        return "Barrier Unknown";
    }
}

