/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChainCycleViewAction
extends DirectViewAction {
    private static final String CHAIN_LABEL = "Cycle Chain mode";
    private ChainChecker myChainChecker = new ChainChecker();

    public ChainCycleViewAction() {
        super(StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD_INLINE, CHAIN_LABEL);
    }

    @Override
    public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        if (selectedChildren.size() != 1) {
            return;
        }
        SceneComponent selectedComponent = editor2.getScene().getSceneComponent(selectedChildren.get(0));
        if (selectedComponent != null) {
            this.myChainChecker.checkIsInChain(selectedComponent);
            if (this.myChainChecker.isInHorizontalChain()) {
                ConstraintComponentUtilities.cycleChainStyle(this.myChainChecker.getHorizontalChainHead(), "layout_constraintHorizontal_chainStyle", selectedComponent);
            } else if (this.myChainChecker.isInVerticalChain()) {
                ConstraintComponentUtilities.cycleChainStyle(this.myChainChecker.getVerticalChainHead(), "layout_constraintVertical_chainStyle", selectedComponent);
            }
        }
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        SceneComponent selectedComponent;
        super.updatePresentation(presentation, editor2, handler, component, selectedChildren, modifiers);
        boolean isVisible = false;
        if (selectedChildren.size() == 1 && (selectedComponent = editor2.getScene().getSceneComponent(selectedChildren.get(0))) != null) {
            this.myChainChecker.checkIsInChain(selectedComponent);
            isVisible = this.myChainChecker.isInHorizontalChain() || this.myChainChecker.isInVerticalChain();
        }
        presentation.setVisible(isVisible);
    }
}

