/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.SdkConstants;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneComponentHelperKt;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintAnchorTarget
extends AnchorTarget {
    private final AnchorTarget.Type myType;
    private boolean myRenderingTemporaryConnection = false;
    private int myConnectedX = -1;
    private int myConnectedY = -1;
    private final HashMap<String, String> mPreviousAttributes = new HashMap();

    public ConstraintAnchorTarget(@NotNull AnchorTarget.Type type, boolean isEdge) {
        super(type, isEdge);
        this.myType = type;
    }

    public boolean isHorizontalAnchor() {
        return this.myType == AnchorTarget.Type.LEFT || this.myType == AnchorTarget.Type.RIGHT;
    }

    public boolean isVerticalAnchor() {
        return this.myType == AnchorTarget.Type.TOP || this.myType == AnchorTarget.Type.BOTTOM;
    }

    public boolean isBaselineAnchor() {
        return this.myType == AnchorTarget.Type.BASELINE;
    }

    private boolean isConnected(ConstraintAnchorTarget target) {
        if (target == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        String attribute = null;
        switch (this.myType) {
            case LEFT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                break;
            }
            case RIGHT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                break;
            }
            case TOP: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                break;
            }
            case BOTTOM: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                break;
            }
            case BASELINE: {
                attribute = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
                if (attribute == null) break;
                attribute = NlComponent.extractId(attribute);
            }
        }
        if (attribute == null) {
            return false;
        }
        return attribute.equalsIgnoreCase(target.getComponent().getId());
    }

    @Override
    protected boolean isConnected() {
        return ConstraintComponentUtilities.isAnchorConnected(this.myType, this.myComponent.getAuthoritativeNlComponent(), this.useRtlAttributes(), this.isRtl());
    }

    @Override
    public boolean canDisconnect() {
        return this.myComponent.getScene().isCtrlMetaDown();
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myIsEdge) {
            return;
        }
        super.render(list, sceneContext);
        if (!this.myRenderingTemporaryConnection && this.myLastX != -1 && this.myLastY != -1 && (this.myConnectedX == -1 && this.myConnectedY == -1 || this.myLastX != this.myConnectedX || this.myLastY != this.myConnectedY)) {
            float x = this.getCenterX();
            float y = this.getCenterY();
            list.addConnection(sceneContext, x, y, this.myLastX, this.myLastY, this.myType.ordinal());
        }
    }

    @Override
    public boolean isEnabled() {
        boolean matchesFilter;
        if (!super.isEnabled()) {
            return false;
        }
        if (this.myComponent.getScene().getSelection().size() > 1) {
            return false;
        }
        if (this.myComponent.isSelected()) {
            boolean hasBaselineConnection = this.isBaselineConnected();
            if (this.getType() == AnchorTarget.Type.BASELINE) {
                return this.myComponent.canShowBaseline() || hasBaselineConnection;
            }
            return !hasBaselineConnection && !this.myComponent.canShowBaseline() || hasBaselineConnection && this.isHorizontalAnchor();
        }
        Scene.FilterType filerType = this.myComponent.getScene().getFilterType();
        switch (filerType) {
            case BASELINE_ANCHOR: {
                matchesFilter = this.isBaselineAnchor();
                break;
            }
            case VERTICAL_ANCHOR: {
                matchesFilter = this.isVerticalAnchor();
                break;
            }
            case HORIZONTAL_ANCHOR: {
                matchesFilter = this.isHorizontalAnchor();
                break;
            }
            case ANCHOR: {
                matchesFilter = true;
                break;
            }
            default: {
                matchesFilter = false;
            }
        }
        Integer state = DecoratorUtilities.getTryingToConnectState(this.myComponent.getNlComponent());
        boolean tryingToConnect = state != null && (state & this.myType.getMask()) != 0 && this.isTargeted();
        return matchesFilter || tryingToConnect;
    }

    @Override
    public boolean isConnectible(@NotNull AnchorTarget dest) {
        if (!(dest instanceof ConstraintAnchorTarget)) {
            return false;
        }
        ConstraintAnchorTarget constraintAnchorDest = (ConstraintAnchorTarget)dest;
        if (this.isVerticalAnchor() && !constraintAnchorDest.isVerticalAnchor()) {
            return false;
        }
        if (this.isHorizontalAnchor() && !constraintAnchorDest.isHorizontalAnchor()) {
            return false;
        }
        if (constraintAnchorDest.isEdge()) {
            return this.myComponent.getParent() == constraintAnchorDest.myComponent;
        }
        return this.myComponent.getParent() == constraintAnchorDest.myComponent.getParent();
    }

    private boolean isBaselineConnected() {
        return this.myComponent.getAuthoritativeNlComponent().getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    @Override
    @NotNull
    protected DrawAnchor.Mode getDrawMode() {
        Integer state = DecoratorUtilities.getTryingToConnectState(this.myComponent.getNlComponent());
        boolean can_connect = state != null && (state & this.myType.getMask()) != 0;
        boolean doing_connection = state != null;
        boolean is_connected = this.isConnected();
        int drawState = (can_connect ? 1 : 0) | (this.mIsOver ? 2 : 0) | (is_connected ? 4 : 0) | (doing_connection ? 8 : 0) | (this.myComponent.isSelected() ? 16 : 0);
        DrawAnchor.Mode[] modeTable = new DrawAnchor.Mode[]{DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.OVER, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DELETE, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER};
        return modeTable[drawState];
    }

    private void clearMe(@NotNull NlAttributesHolder transaction) {
        ConstraintComponentUtilities.clearAnchor(this.myType, transaction, this.useRtlAttributes(), this.isRtl());
    }

    private void rememberPreviousAttribute(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        for (String attribute : attributes) {
            this.mPreviousAttributes.put(attribute, component.getLiveAttribute(uri, attribute));
        }
    }

    private boolean useRtlAttributes() {
        return this.myComponent.useRtlAttributes();
    }

    private boolean isRtl() {
        return this.myComponent.getScene().isInRTL();
    }

    private String getAttribute(@NotNull Target target) {
        if (!(target instanceof ConstraintAnchorTarget)) {
            return null;
        }
        ConstraintAnchorTarget anchorTarget = (ConstraintAnchorTarget)target;
        return ConstraintComponentUtilities.getAttribute(this.myType, anchorTarget.myType, this.useRtlAttributes(), this.isRtl());
    }

    private void revertToPreviousState() {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(component, "Revert");
        modification.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
        for (String key : this.mPreviousAttributes.keySet()) {
            if (key.equalsIgnoreCase("layout_editor_absoluteX") || key.equalsIgnoreCase("layout_editor_absoluteY")) {
                modification.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_marginTop") || key.equalsIgnoreCase("layout_marginBottom") || key.equalsIgnoreCase("layout_marginLeft") || key.equalsIgnoreCase("layout_marginRight") || key.equalsIgnoreCase("layout_marginStart") || key.equalsIgnoreCase("layout_marginEnd")) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", key, this.mPreviousAttributes.get(key));
                continue;
            }
            modification.setAttribute("http://schemas.android.com/apk/res-auto", key, this.mPreviousAttributes.get(key));
        }
        modification.apply();
        this.myComponent.getScene().needsLayout(2);
    }

    private ComponentModification connectMe(NlComponent component, String attribute, NlComponent targetComponent) {
        String otherSideAttrValue;
        ComponentModification modification = new ComponentModification(component, "Connect Constraint");
        NlComponent parent = component.getParent();
        assert (parent != null);
        if (NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) {
            parent = parent.getParent();
        }
        String targetId = targetComponent == parent ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(targetComponent);
        modification.setAttribute("http://schemas.android.com/apk/res-auto", attribute, targetId);
        if (this.myType == AnchorTarget.Type.BASELINE) {
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes, (NlAttributesHolder)modification);
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes, (NlAttributesHolder)modification);
            modification.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        } else if (ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute) != null) {
            modification.setAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute), null);
        }
        String otherSideAttr = ConstraintComponentUtilities.ourOtherSideAttributes.get(attribute);
        String string = otherSideAttrValue = otherSideAttr != null ? component.getAttribute("http://schemas.android.com/apk/res-auto", otherSideAttr) : null;
        if (ConstraintAnchorTarget.isOppositeSideConnectedToSameTarget(targetId, otherSideAttrValue)) {
            this.removeOppositeSideMargin(modification, otherSideAttr);
        } else if (ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute) != null) {
            Scene scene = this.myComponent.getScene();
            int marginValue = this.getDistance(attribute, targetComponent, scene);
            marginValue = !scene.isCtrlMetaDown() ? (marginValue < 0 ? 0 : Scout.getMargin()) : Math.max(marginValue, 0);
            String margin = Scout.getMarginResource() == null ? String.format("%ddp", marginValue) : Scout.getMarginResource();
            String attr = ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute);
            modification.setAttribute("http://schemas.android.com/apk/res/android", attr, margin);
            if ("layout_marginEnd".equals(attr)) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", margin);
            } else if ("layout_marginStart".equals(attr)) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", margin);
            }
            scene.needsRebuildList();
            this.myConnectedX = this.myLastX;
            this.myConnectedY = this.myLastY;
        }
        ConstraintComponentUtilities.cleanup(modification, this.myComponent.getNlComponent());
        modification.apply();
        this.myComponent.getScene().needsLayout(2);
        this.myRenderingTemporaryConnection = true;
        return modification;
    }

    private void removeOppositeSideMargin(@NotNull NlAttributesHolder attributes, @NotNull String otherSideAttr) {
        String alternateAttr;
        String otherSideMargin = ConstraintComponentUtilities.ourMapMarginAttributes.get(otherSideAttr);
        if (otherSideMargin == null) {
            return;
        }
        boolean rtl = this.isRtl();
        switch (otherSideMargin) {
            case "layout_marginLeft": {
                alternateAttr = rtl ? "layout_marginEnd" : "layout_marginStart";
                break;
            }
            case "layout_marginRight": {
                alternateAttr = rtl ? "layout_marginStart" : "layout_marginEnd";
                break;
            }
            case "layout_marginStart": {
                alternateAttr = rtl ? "layout_marginRight" : "layout_marginLeft";
                break;
            }
            case "layout_marginEnd": {
                alternateAttr = rtl ? "layout_marginLeft" : "layout_marginRight";
                break;
            }
            default: {
                alternateAttr = null;
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", otherSideMargin, null);
        if (alternateAttr != null) {
            attributes.setAttribute("http://schemas.android.com/apk/res/android", alternateAttr, null);
        }
    }

    private static boolean isOppositeSideConnectedToSameTarget(@NotNull String targetId, @Nullable String otherSideAttrValue) {
        String strippedId = NlComponent.stripId(otherSideAttrValue);
        return strippedId != null && strippedId.equals(NlComponent.stripId(targetId));
    }

    private int getDistance(String attribute, NlComponent targetComponent, Scene scene) {
        int marginValue;
        ConstraintAnchorTarget targetAnchor = ConstraintComponentUtilities.getTargetAnchor(scene, targetComponent, attribute, this.useRtlAttributes(), this.isRtl());
        if (targetAnchor == null) {
            return 0;
        }
        block0 : switch (this.myType) {
            case LEFT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(this.getCenterX() - targetAnchor.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case RIGHT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(targetAnchor.getCenterX() - this.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case TOP: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(this.getCenterY() - targetAnchor.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case BOTTOM: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(targetAnchor.getCenterY() - this.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            default: {
                marginValue = 0;
            }
        }
        return marginValue;
    }

    private void disconnectMe(NlComponent component) {
        ComponentModification modification = new ComponentModification(component, "Constraint Disconnected");
        this.clearMe(modification);
        ConstraintComponentUtilities.cleanup(modification, this.myComponent.getNlComponent());
        modification.commit();
        this.myComponent.getScene().needsLayout(2);
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        Scene scene = this.myComponent.getScene();
        if (this.isHorizontalAnchor()) {
            scene.setFilterType(Scene.FilterType.HORIZONTAL_ANCHOR);
        } else {
            scene.setFilterType(Scene.FilterType.VERTICAL_ANCHOR);
        }
        if (this.getType() == AnchorTarget.Type.BASELINE) {
            scene.setFilterType(Scene.FilterType.BASELINE_ANCHOR);
        }
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        this.mPreviousAttributes.clear();
        this.mPreviousAttributes.put("layout_editor_absoluteX", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX"));
        this.mPreviousAttributes.put("layout_editor_absoluteY", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY"));
        this.mPreviousAttributes.put("layout_constraintBaseline_toBaselineOf", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf"));
        switch (this.myType) {
            case LEFT: 
            case RIGHT: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourStartAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourEndAttributes);
                this.mPreviousAttributes.put("layout_marginLeft", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft"));
                this.mPreviousAttributes.put("layout_marginRight", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight"));
                this.mPreviousAttributes.put("layout_marginStart", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart"));
                this.mPreviousAttributes.put("layout_marginEnd", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd"));
                this.mPreviousAttributes.put("layout_constraintHorizontal_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias"));
                break;
            }
            case TOP: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BOTTOM: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginBottom", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BASELINE: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_marginBottom", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
            }
        }
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        super.mouseDrag(x, y, closestTargets);
        ConstraintAnchorTarget targetAnchor = null;
        for (Target target : closestTargets) {
            if (!(target instanceof ConstraintAnchorTarget) || target == this) continue;
            targetAnchor = (ConstraintAnchorTarget)target;
            break;
        }
        if (!this.myIsDragging) {
            this.myIsDragging = true;
            DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, true);
        }
        if (targetAnchor != null) {
            NlComponent component = this.myComponent.getAuthoritativeNlComponent();
            String attribute = this.getAttribute(targetAnchor);
            if (attribute != null && targetAnchor.myComponent != this.myComponent && !targetAnchor.isConnected(this)) {
                if (this.myComponent.getParent() != targetAnchor.myComponent) {
                    Integer state = DecoratorUtilities.getTryingToConnectState(targetAnchor.myComponent.getNlComponent());
                    if (state == null) {
                        return;
                    }
                    int mask = state & targetAnchor.myType.getMask();
                    if (mask == 0) {
                        return;
                    }
                }
                NlComponent targetComponent = targetAnchor.myComponent.getAuthoritativeNlComponent();
                this.connectMe(component, attribute, targetComponent);
                return;
            }
        }
        if (this.myRenderingTemporaryConnection) {
            this.revertToPreviousState();
            this.myRenderingTemporaryConnection = false;
            return;
        }
        this.myComponent.getScene().needsRebuildList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        super.mouseRelease(x, y, closestTargets);
        try {
            ConstraintAnchorTarget closestTarget = null;
            for (Target target : closestTargets) {
                if (!(target instanceof ConstraintAnchorTarget) || target == this) continue;
                closestTarget = (ConstraintAnchorTarget)target;
                break;
            }
            if (closestTarget == null && closestTargets.contains(this)) {
                closestTarget = this;
            }
            if (closestTarget != null && !super.isConnected(this)) {
                NlComponent component = this.myComponent.getAuthoritativeNlComponent();
                if (closestTarget == this) {
                    if (this.canDisconnect()) {
                        this.disconnectMe(component);
                    }
                } else {
                    String attribute = this.getAttribute(closestTarget);
                    if (attribute != null) {
                        if (closestTarget.myComponent == this.myComponent) {
                            return;
                        }
                        if (this.myComponent.getParent() != closestTarget.myComponent) {
                            Integer state = DecoratorUtilities.getTryingToConnectState(closestTarget.myComponent.getNlComponent());
                            if (state == null) {
                                return;
                            }
                            int mask = state & closestTarget.myType.getMask();
                            if (mask == 0) {
                                return;
                            }
                        }
                        NlComponent targetComponent = closestTarget.myComponent.getAuthoritativeNlComponent();
                        ComponentModification modification = this.connectMe(component, attribute, targetComponent);
                        modification.commit();
                        this.myComponent.getScene().needsLayout(2);
                    }
                }
            } else {
                Collection<SceneComponent> components = this.myComponent.getScene().getSceneComponents();
                Rectangle rectangle = new Rectangle();
                ArrayList<NlComponent> list = new ArrayList<NlComponent>();
                list.add(this.myComponent.getAuthoritativeNlComponent());
                list.add(this.myComponent.getAuthoritativeNlComponent());
                ArrayList<SceneComponent> allItems = new ArrayList<SceneComponent>();
                for (SceneComponent sceneComponent : components) {
                    rectangle.width = sceneComponent.getDrawWidth();
                    rectangle.height = sceneComponent.getDrawHeight();
                    rectangle.x = sceneComponent.getDrawX();
                    rectangle.y = sceneComponent.getDrawY();
                    if (!rectangle.contains(x, y) || !SceneComponentHelperKt.isSibling(this.myComponent, sceneComponent)) continue;
                    allItems.add(sceneComponent);
                }
                if (!allItems.isEmpty()) {
                    JBPopupMenu menu = new JBPopupMenu("Connect to:");
                    for (SceneComponent component : allItems) {
                        list.set(1, component.getAuthoritativeNlComponent());
                        switch (this.myType) {
                            case LEFT: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectStartToStart, "start ", " start", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_START);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectStartToEnd, "end ", " start", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_END);
                                break;
                            }
                            case RIGHT: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectEndToStart, "End ", " start", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_START);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectEndToEnd, "End ", " end", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_END);
                                break;
                            }
                            case TOP: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectTopToTop, "Top ", " top", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_TOP);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectTopToBottom, "Top ", " bottom", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_BOTTOM);
                                break;
                            }
                            case BOTTOM: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBottomToTop, "Bottom ", " top", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_TOP);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBottomToBottom, "Bottom ", " bottom", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_BOTTOM);
                                break;
                            }
                            case BASELINE: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBaseLineToBaseLine, "Baseline ", " baseline", StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT);
                            }
                        }
                    }
                    double d = this.myComponent.getScene().getDesignSurface().getScale();
                    d *= (double)this.myComponent.getScene().getDesignSurface().getSceneScalingFactor();
                    float dx = this.myComponent.getScene().getDesignSurface().getContentOriginX();
                    float dy = this.myComponent.getScene().getDesignSurface().getContentOriginY();
                    this.myIsDragging = false;
                    DecoratorUtilities.setTryingToConnectState(this.myComponent.getAuthoritativeNlComponent(), this.myType, false);
                    final List allItemsNlComponents = allItems.stream().map(item -> item.getAuthoritativeNlComponent()).collect(Collectors.toCollection(ArrayList::new));
                    menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                            super.popupMenuWillBecomeVisible(e);
                            DecoratorUtilities.setTryingToConnectState(ConstraintAnchorTarget.this.myComponent.getAuthoritativeNlComponent(), allItemsNlComponents, ConstraintAnchorTarget.this.myType, true);
                        }

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            super.popupMenuWillBecomeInvisible(e);
                            DecoratorUtilities.setTryingToConnectState(ConstraintAnchorTarget.this.myComponent.getAuthoritativeNlComponent(), allItemsNlComponents, ConstraintAnchorTarget.this.myType, false);
                            ConstraintAnchorTarget.this.myComponent.getScene().setFilterType(Scene.FilterType.NONE);
                        }
                    });
                    if (menu.getComponentCount() > 0) {
                        menu.show((Component)this.myComponent.getScene().getDesignSurface().getPreferredFocusedComponent(), (int)((double)x * d + (double)dx), (int)((double)y * d + (double)dy));
                    }
                }
            }
        }
        finally {
            if (this.myIsDragging) {
                this.myIsDragging = false;
                DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, false);
                this.myComponent.getScene().needsRebuildList();
            }
        }
    }

    @Override
    public void mouseCancel() {
        super.mouseCancel();
        DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, false);
        this.revertToPreviousState();
    }

    @Override
    public String getToolTipText() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getToolTipText());
        if (this.isConnected()) {
            builder.append(" (").append(AdtUiUtils.getActionKeyText()).append("+Click)");
        }
        return builder.toString();
    }

    private void addConnectMenu(ArrayList<NlComponent> list, List<SceneComponent> allItems, SceneComponent component, JBPopupMenu menu, Scout.Connect type, String from, String to, Icon icon2) {
        if (Scout.connectCheck(list, type, false)) {
            menu.add((JMenuItem)((Object)new ConnectMenu(allItems, this.myComponent, from, component, to, icon2, type)));
        }
    }

    static class ConnectMenu
    extends JBMenuItem
    implements ActionListener,
    ChangeListener {
        SceneComponent mySrc;
        SceneComponent myDest;
        Scout.Connect myType;
        @Nullable
        AnchorTarget myDestTarget;
        List<SceneComponent> mAllItems;

        public ConnectMenu(List<SceneComponent> allItems, SceneComponent src, String from, SceneComponent dest, String text, Icon icon2, Scout.Connect type) {
            super(from + " to " + dest.getId() + text, icon2);
            this.mAllItems = allItems;
            this.mySrc = src;
            this.myDest = dest;
            this.myType = type;
            for (Target target : this.myDest.getTargets()) {
                if (!(target instanceof AnchorTarget) || ((AnchorTarget)target).getType() != this.myType.getDstAnchorType()) continue;
                this.myDestTarget = (AnchorTarget)target;
            }
            this.addActionListener(this);
            this.addChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<NlComponent> list = Arrays.asList(this.mySrc.getAuthoritativeNlComponent(), this.myDest.getAuthoritativeNlComponent());
            Scout.connect(list, this.myType, false, true);
            NlDesignSurface designSurface = (NlDesignSurface)this.mySrc.getScene().getDesignSurface();
            designSurface.forceLayersPaint(true);
            designSurface.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (SceneComponent item : this.mAllItems) {
                item.setDrawState(SceneComponent.DrawState.NORMAL);
            }
            if (this.myDestTarget != null) {
                this.myDestTarget.setMouseHovered(this.isSelected() || this.isArmed());
            }
            this.myDest.setDrawState(this.isSelected() || this.isArmed() ? SceneComponent.DrawState.HOVER : SceneComponent.DrawState.NORMAL);
            this.myDest.getScene().needsRebuildList();
            this.myDest.getScene().repaint();
        }
    }
}

