/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.grid.CellInfo;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.InsetsAttributes;
import com.android.tools.idea.uibuilder.model.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\n2\u0006\u0010\u0017\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"MARGIN_ATTRIBUTES", "Lcom/android/tools/idea/uibuilder/handlers/grid/InsetsAttributes;", "PADDING_ATTRIBUTES", "getGridBarriers", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "gridComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "getPxValue", "", "nlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "value", "", "retrieveCellData", "Lcom/android/tools/idea/uibuilder/handlers/grid/CellInfo;", "isSupportLibrary", "", "retrieveInsets", "Lcom/android/tools/idea/uibuilder/model/Insets;", "attrs", "retrieveMargins", "retrievePaddings", "getLiveAndroidAttribute", "androidAttribute", "intellij.android.designer"})
public final class GridUtilsKt {
    private static final InsetsAttributes PADDING_ATTRIBUTES = new InsetsAttributes("padding", (Pair<String, String>)new Pair((Object)"paddingStart", (Object)"paddingLeft"), "paddingTop", (Pair<String, String>)new Pair((Object)"paddingEnd", (Object)"paddingRight"), "paddingBottom");
    private static final InsetsAttributes MARGIN_ATTRIBUTES = new InsetsAttributes("layout_margin", (Pair<String, String>)new Pair((Object)"layout_marginStart", (Object)"layout_marginLeft"), "layout_marginTop", (Pair<String, String>)new Pair((Object)"layout_marginEnd", (Object)"layout_marginRight"), "layout_marginBottom");

    @NotNull
    public static final GridBarriers getGridBarriers(@NotNull SceneComponent gridComponent) {
        boolean isSupportLibrary = SdkConstants.GRID_LAYOUT_V7.isEquals(gridComponent.getNlComponent().getTagName());
        Function1<Integer, Integer> toDp$ = new Function1<Integer, Integer>(gridComponent){
            final /* synthetic */ SceneComponent $gridComponent;

            public final int invoke(int $receiver) {
                return Coordinates.pxToDp(this.$gridComponent.getScene().getDesignSurface(), $receiver);
            }
            {
                this.$gridComponent = sceneComponent;
                super(1);
            }
        };
        Insets padding = GridUtilsKt.retrievePaddings(gridComponent.getAuthoritativeNlComponent());
        int left2 = gridComponent.getDrawX() + toDp$.invoke(padding.left);
        int top = gridComponent.getDrawY() + toDp$.invoke(padding.top);
        int right2 = gridComponent.getDrawX() + gridComponent.getDrawWidth() - toDp$.invoke(padding.right);
        int bottom2 = gridComponent.getDrawY() + gridComponent.getDrawHeight() - toDp$.invoke(padding.bottom);
        List<SceneComponent> children = gridComponent.getChildren();
        boolean bl = false;
        HashMap rowMap = new HashMap();
        boolean bl2 = false;
        HashMap columnMap = new HashMap();
        int previousRow = 0;
        int previousColumn = -1;
        for (SceneComponent child : children) {
            boolean bl3;
            Integer n;
            int n2;
            Object object;
            Map map2;
            if (child instanceof TemporarySceneComponent) continue;
            CellInfo cellData = GridUtilsKt.retrieveCellData(child.getAuthoritativeNlComponent(), isSupportLibrary);
            if (cellData.getColumn() == -1) {
                cellData.setColumn(previousColumn + 1);
            }
            if (cellData.getRow() == -1) {
                cellData.setRow(previousRow);
            }
            Insets marginInsets = GridUtilsKt.retrieveMargins(child.getAuthoritativeNlComponent());
            int cellLeft = child.getDrawX() - toDp$.invoke(marginInsets.left);
            int cellTop = child.getDrawY() - toDp$.invoke(marginInsets.top);
            int cellRight = child.getDrawX() + child.getDrawWidth() + toDp$.invoke(marginInsets.right);
            int cellBottom = child.getDrawY() + child.getDrawHeight() + toDp$.invoke(marginInsets.bottom);
            if (cellData.getColumn() != 0) {
                map2 = columnMap;
                object = cellData.getColumn();
                Integer n3 = (Integer)columnMap.get(cellData.getColumn());
                if (n3 == null) {
                    n3 = Integer.MAX_VALUE;
                }
                int n4 = n3;
                n2 = 0;
                n = Math.min(cellLeft, n4);
                n2 = 0;
                map2.put(object, n);
            }
            if (cellData.getRow() != 0) {
                map2 = rowMap;
                object = cellData.getRow();
                Integer n5 = (Integer)rowMap.get(cellData.getRow());
                if (n5 == null) {
                    n5 = Integer.MAX_VALUE;
                }
                int n6 = n5;
                n2 = 0;
                n = Math.min(cellTop, n6);
                n2 = 0;
                map2.put(object, n);
            }
            if (cellData.getColumn() != -1 && cellData.getColumnSpan() != 0) {
                int rightIndex = cellData.getColumn() + cellData.getColumnSpan();
                object = columnMap;
                n = rightIndex;
                Integer n7 = (Integer)columnMap.get(rightIndex);
                if (n7 == null) {
                    n7 = Integer.MIN_VALUE;
                }
                n2 = n7;
                bl3 = false;
                Integer n8 = Math.max(cellRight, n2);
                bl3 = false;
                object.put(n, n8);
            }
            if (cellData.getRow() != -1 && cellData.getRowSpan() != 0) {
                int bottomIndex = cellData.getRow() + cellData.getRowSpan();
                object = rowMap;
                n = bottomIndex;
                Integer n9 = (Integer)rowMap.get(bottomIndex);
                if (n9 == null) {
                    n9 = Integer.MIN_VALUE;
                }
                int n10 = n9;
                bl3 = false;
                Integer n11 = Math.max(cellBottom, n10);
                bl3 = false;
                object.put(n, n11);
            }
            previousRow = cellData.getRow();
            previousColumn = cellData.getColumn();
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)columnMap.keySet());
        int columnCount = n != null ? n + 1 : 1;
        Integer n12 = (Integer)CollectionsKt.max((Iterable)rowMap.keySet());
        int rowCount = n12 != null ? n12 + 1 : 1;
        Map map3 = columnMap;
        Integer n13 = 0;
        Integer n14 = left2;
        boolean bl4 = false;
        map3.put(n13, n14);
        map3 = columnMap;
        n13 = columnCount;
        n14 = right2;
        bl4 = false;
        map3.put(n13, n14);
        map3 = rowMap;
        n13 = 0;
        n14 = top;
        bl4 = false;
        map3.put(n13, n14);
        map3 = rowMap;
        n13 = rowCount;
        n14 = bottom2;
        bl4 = false;
        map3.put(n13, n14);
        return new GridBarriers(rowMap, columnMap);
    }

    private static final CellInfo retrieveCellData(NlComponent nlComponent, boolean isSupportLibrary) {
        String namespace = isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        Function2 getAttribute2 = (Function2)new Function2<String, Integer, Integer>(nlComponent, namespace){
            final /* synthetic */ NlComponent $nlComponent;
            final /* synthetic */ String $namespace;

            public final int invoke(@NotNull String name, int defaultValue) {
                Object object = this.$nlComponent.getLiveAttribute(this.$namespace, name);
                return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
            }
            {
                this.$nlComponent = nlComponent;
                this.$namespace = string;
                super(2);
            }
        };
        return new CellInfo(((Number)getAttribute2.invoke((Object)"layout_row", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_column", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_rowSpan", (Object)1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_columnSpan", (Object)1)).intValue());
    }

    private static final String getLiveAndroidAttribute(@NotNull NlComponent $receiver, String androidAttribute) {
        return $receiver.getLiveAttribute("http://schemas.android.com/apk/res/android", androidAttribute);
    }

    private static final Insets retrieveMargins(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, MARGIN_ATTRIBUTES);
    }

    private static final Insets retrievePaddings(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, PADDING_ATTRIBUTES);
    }

    private static final Insets retrieveInsets(NlComponent nlComponent, InsetsAttributes attrs) {
        int left2 = 0;
        int top = 0;
        int right2 = 0;
        int bottom2 = 0;
        String valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getAll());
        if (valueString != null) {
            int padding;
            left2 = padding = GridUtilsKt.getPxValue(nlComponent, valueString);
            top = padding;
            right2 = padding;
            bottom2 = padding;
        } else {
            String string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getFirst());
            if (string == null) {
                string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getSecond());
            }
            valueString = string;
            left2 = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getTop());
            top = GridUtilsKt.getPxValue(nlComponent, valueString);
            String string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getFirst());
            if (string2 == null) {
                string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getSecond());
            }
            valueString = string2;
            right2 = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getBottom());
            bottom2 = GridUtilsKt.getPxValue(nlComponent, valueString);
        }
        return new Insets(left2, top, right2, bottom2);
    }

    private static final int getPxValue(NlComponent nlComponent, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (value2 != null && (resourceResolver = (configuration = nlComponent.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer n = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration);
            return n != null ? n : 0;
        }
        return 0;
    }
}

