/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.actions;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.LinearLayoutAction;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ToggleOrientationAction
extends LinearLayoutAction {
    @Override
    protected void perform(@NotNull ViewEditor editor2, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
        boolean isHorizontal = !handler.isVertical(component);
        String value2 = isHorizontal ? "vertical" : null;
        NlWriteCommandActionUtil.run(component, "Change LinearLayout orientation", () -> component.setAttribute("http://schemas.android.com/apk/res/android", "orientation", value2));
    }

    @Override
    protected void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        boolean vertical = handler.isVertical(component);
        presentation.setLabel("Convert orientation to " + (vertical ? "horizontal" : "vertical"));
        Icon icon2 = vertical ? StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ : StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_VERT;
        presentation.setIcon(icon2);
    }
}

