/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutTimelinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.AttributeTagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.MotionSceneStatusPanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.OnSwipePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.TransitionPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributePanel
implements AccessoryPanelInterface {
    static Color ourSecondaryPanelBackground;
    static Color ourMainBackground;
    private final ViewGroupHandler.AccessoryPanelVisibility myVisibilityCallback;
    private final NlComponent myMotionLayout;
    private JPanel myPanel;
    private NlComponent mySelection;
    private MotionLayoutTimelinePanel myTimelinePanel;
    public MotionSceneModel.KeyFrame myCurrentKeyframe;
    public NlModel myNlModel;
    JPanel myAttribGroups;
    TransitionPanel myTransitionPanel = new TransitionPanel(this);
    AttributeTagPanel myAttributeTagPanel = new AttributeTagPanel(this);
    private OnSwipePanel myOnSwipeTagPanel = new OnSwipePanel(this);
    private MotionSceneStatusPanel myMotionSceneStatusPanel = new MotionSceneStatusPanel(this);

    public MotionLayoutAttributePanel(@NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        this.myMotionLayout = parent;
        this.myVisibilityCallback = visibility;
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = this.createPanel(AccessoryPanel.Type.EAST_PANEL);
        }
        return this.myPanel;
    }

    @Override
    @NotNull
    public JPanel createPanel(@NotNull AccessoryPanel.Type type) {
        JPanel panel2 = new JPanel(new BorderLayout()){
            {
                this.setPreferredSize(new Dimension(250, 250));
            }
        };
        this.myAttribGroups = new JPanel();
        this.myAttribGroups.setBorder((Border)JBUI.Borders.empty());
        this.myAttribGroups.setLayout(new GridBagLayout());
        this.myAttribGroups.setBackground(ourMainBackground);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = JBUI.insetsTop((int)10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.myAttribGroups.add((Component)this.myMotionSceneStatusPanel, gbc);
        ++gbc.gridy;
        this.myAttribGroups.add((Component)this.myTransitionPanel, gbc);
        ++gbc.gridy;
        this.myAttribGroups.add((Component)this.myOnSwipeTagPanel, gbc);
        ++gbc.gridy;
        this.myAttribGroups.add((Component)this.myAttributeTagPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.myAttribGroups.add(Box.createVerticalGlue(), gbc);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myAttribGroups);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        panel2.add((Component)scrollPane, "Center");
        panel2.setBackground(ourMainBackground);
        return panel2;
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            this.mySelection = null;
            this.myTimelinePanel = null;
            return;
        }
        this.mySelection = selection.get(0);
        Object property2 = this.mySelection.getClientProperty("Timeline");
        if (property2 == null && this.mySelection.getParent() != null) {
            property2 = this.mySelection.getParent().getClientProperty("Timeline");
        }
        if (property2 != null) {
            this.myTimelinePanel = (MotionLayoutTimelinePanel)property2;
            this.myTimelinePanel.setMotionLayoutAttributePanel(this);
        }
        this.updatePanel();
    }

    public void updateSelection() {
        this.updatePanel();
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
        this.updatePanel();
    }

    @Override
    @Nullable
    public Object getSelectedAccessory() {
        return null;
    }

    @Override
    public void addListener(@NotNull AccessorySelectionListener listener2) {
    }

    @Override
    public void removeListener(@NotNull AccessorySelectionListener listener2) {
    }

    public void clearSelectedKeyframe() {
        this.myTimelinePanel.clearSelectedKeyframe();
    }

    private void updatePanel() {
        if (this.myTimelinePanel != null && this.mySelection != null) {
            this.myNlModel = this.mySelection.getModel();
            MotionSceneModel.KeyFrame keyframe = this.myTimelinePanel.getSelectedKeyframe();
            this.myTransitionPanel.setTransitionTag(this.myTimelinePanel.getTransitionTag());
            this.myOnSwipeTagPanel.setOnSwipeTag(this.myTimelinePanel.getOnSwipeTag());
            this.myCurrentKeyframe = keyframe;
            this.myAttributeTagPanel.setKeyFrame(keyframe);
            this.myMotionSceneStatusPanel.setModel(this.myTimelinePanel.getModel());
        }
    }

    static {
        ourMainBackground = ourSecondaryPanelBackground = new JBColor(0xFCFCFC, 3224629);
    }
}

