/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import android.view.View;
import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutTimelinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.utils.Pair;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutComponentDelegate
implements NlComponentDelegate {
    private static final boolean USE_CACHE = false;
    private final MotionLayoutTimelinePanel myPanel;
    private static List<String> ourDefaultAttributes = Arrays.asList("layout_width", "layout_height", "id", "layout_editor_absoluteX", "layout_editor_absoluteY");
    private static List<String> ourInterceptedAttributes = Arrays.asList("layout_editor_absoluteX", "layout_editor_absoluteY", "layout_width", "layout_height", "layout_margin", "layout_marginLeft", "layout_marginRight", "layout_marginTop", "layout_marginBottom", "layout_marginStart", "layout_marginEnd", "layout_goneMarginLeft", "layout_goneMarginRight", "layout_goneMarginTop", "layout_goneMarginBottom", "layout_goneMarginStart", "layout_goneMarginEnd", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintHorizontal_chainStyle", "layout_constraintVertical_chainStyle", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintHorizontal_weight", "layout_constraintVertical_weight");
    private MotionLayoutTimelinePanel.State myLastReadState;
    HashMap<NlComponent, HashMap<Pair<String, String>, String>> mAttributesCacheStart = new HashMap();
    HashMap<NlComponent, HashMap<Pair<String, String>, String>> mAttributesCacheEnd = new HashMap();
    HashMap<NlComponent, List<AttributeSnapshot>> mCachedAttributes = new HashMap();

    public MotionLayoutComponentDelegate(@NotNull MotionLayoutTimelinePanel panel2) {
        this.myPanel = panel2;
    }

    @Override
    public boolean handlesAttribute(@NotNull NlComponent component, @Nullable String namespace, @NotNull String attribute) {
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            return false;
        }
        if (ourInterceptedAttributes.contains(attribute)) {
            return this.myPanel.handlesWriteForComponent(component.getId());
        }
        return false;
    }

    @Override
    public boolean handlesAttributes(NlComponent component) {
        return true;
    }

    @Override
    public boolean handlesApply(ComponentModification modification) {
        return true;
    }

    @Override
    public boolean handlesCommit(ComponentModification modification) {
        SmartPsiElementPointer<XmlTag> constraint = this.myPanel.getSelectedConstraint();
        return constraint != null;
    }

    @Nullable
    private XmlTag getConstrainedView(@NotNull NlComponent component) {
        SmartPsiElementPointer<XmlTag> constraint = this.myPanel.getSelectedConstraint();
        if (constraint == null) {
            return null;
        }
        XmlTag tag = ((XmlTag)constraint.getElement()).getParentTag();
        XmlTag[] child = tag.getSubTags();
        for (int i2 = 0; i2 < child.length; ++i2) {
            XmlTag xmlTag = child[i2];
            if (!component.getId().equals(MotionSceneModel.stripID(xmlTag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")))) continue;
            return xmlTag;
        }
        return null;
    }

    @Override
    public String getAttribute(@NotNull NlComponent component, @Nullable String namespace, @NotNull String attribute) {
        return this.getCachedAttribute(this.mAttributesCacheStart, component, namespace, attribute);
    }

    @Nullable
    private String getCachedAttribute(@NotNull HashMap<NlComponent, HashMap<Pair<String, String>, String>> cache2, @NotNull NlComponent component, @Nullable String namespace, @NotNull String attribute) {
        Object cachedComponent = null;
        String cachedAttribute = null;
        Object key = null;
        if (namespace.equalsIgnoreCase("http://schemas.android.com/tools")) {
            namespace = "http://schemas.android.com/apk/res-auto";
        }
        if (cachedAttribute == null) {
            XmlTag constrainedView = this.getConstrainedView(component);
            if (constrainedView == null) {
                return component.getAttributeImpl(namespace, attribute);
            }
            cachedAttribute = constrainedView.getAttributeValue(attribute, namespace);
        }
        return cachedAttribute;
    }

    private void clearCache(@NotNull NlComponent component) {
        this.mCachedAttributes.remove(component);
        this.mAttributesCacheStart.remove(component);
        this.mAttributesCacheEnd.remove(component);
    }

    @Override
    public void clearCaches() {
        this.mCachedAttributes.clear();
        this.mAttributesCacheStart.clear();
        this.mAttributesCacheEnd.clear();
    }

    @Override
    public void willRemoveChild(final @NotNull NlComponent component) {
        final XmlFile file = this.myPanel.getTransitionFile(component);
        if (file == null) {
            return;
        }
        Project project = component.getModel().getProject();
        new WriteCommandAction(project, "Remove component", new PsiFile[]{file}){

            protected void run(@NotNull Result result2) throws Throwable {
                XmlTag constrainedView;
                XmlTag constraintSet = MotionLayoutComponentDelegate.this.myPanel.getConstraintSet(file, "@+id/start");
                if (constraintSet != null && (constrainedView = MotionLayoutComponentDelegate.this.myPanel.getConstrainView(constraintSet, component.getId())) != null) {
                    constrainedView.delete();
                }
                if ((constraintSet = MotionLayoutComponentDelegate.this.myPanel.getConstraintSet(file, "@+id/end")) != null && (constrainedView = MotionLayoutComponentDelegate.this.myPanel.getConstrainView(constraintSet, component.getId())) != null) {
                    constrainedView.delete();
                }
                List<XmlTag> keyframes = MotionLayoutComponentDelegate.this.myPanel.getKeyframes(file, component.getId());
                for (XmlTag keyframe : keyframes) {
                    keyframe.delete();
                }
            }
        }.execute();
        LayoutPullParsers.saveFileIfNecessary((PsiFile)file);
        NlModel model2 = component.getModel();
        model2.notifyModified(NlModel.ChangeType.EDIT);
        this.clearCache(component);
    }

    @Override
    public boolean commitToMotionScene(Pair<String, String> key) {
        return true;
    }

    @Override
    public List<AttributeSnapshot> getAttributes(NlComponent component) {
        List<AttributeSnapshot> attributes = null;
        if (attributes == null) {
            XmlTag constrainedView = this.getConstrainedView(component);
            if (constrainedView != null) {
                attributes = AttributeSnapshot.createAttributesForTag(constrainedView);
            }
            if (attributes == null) {
                attributes = new ArrayList<AttributeSnapshot>();
                List<AttributeSnapshot> originalAttributes = component.getAttributesImpl();
                for (AttributeSnapshot attributeSnapshot : originalAttributes) {
                    if (!ourDefaultAttributes.contains(attributeSnapshot.name)) continue;
                    attributes.add(attributeSnapshot);
                }
            }
        }
        return attributes;
    }

    @Override
    public void apply(ComponentModification modification) {
        String constraintSetId = null;
        boolean position = false;
        SmartPsiElementPointer<XmlTag> constraint = this.myPanel.getSelectedConstraint();
        if (constraint != null) {
            XmlTag tag = ((XmlTag)constraint.getElement()).getParentTag();
            String id = MotionSceneModel.stripID(tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
            constraintSetId = "@+id/" + id;
            if (id.equalsIgnoreCase("end")) {
                position = true;
            }
        } else {
            return;
        }
        ResourceIdManager manager = ResourceIdManager.get(modification.getComponent().getModel().getModule());
        NlComponent parent = modification.getComponent().getParent();
        ViewInfo info = NlComponentHelperKt.getViewInfo(modification.getComponent());
        if (info == null || info != null && info.getViewObject() == null) {
            return;
        }
        MotionLayoutComponentHelper helper = new MotionLayoutComponentHelper(parent);
        Configuration configuration = modification.getComponent().getModel().getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        HashMap<Object, String> attributes = new HashMap<Object, String>();
        for (Pair<String, String> key : modification.getAttributes().keySet()) {
            String value2 = modification.getAttributes().get(key);
            if (value2 != null) {
                if (value2.startsWith("@id/") || value2.startsWith("@+id/")) {
                    Integer resolved = manager.getCompiledId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2 = value2.substring(value2.indexOf(47) + 1)));
                    if (resolved == null) {
                        this.updateIds(modification.getComponent());
                        resolved = manager.getOrGenerateId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2));
                    }
                    if (resolved != null) {
                        value2 = resolved.toString();
                    }
                } else if (value2.equalsIgnoreCase("parent")) {
                    value2 = "0";
                }
            }
            attributes.put(key.getSecond(), value2);
        }
        helper.setAttributes(dpiValue, constraintSetId, info.getViewObject(), attributes);
        helper.setProgress((float)position);
    }

    void updateIds(@NotNull NlComponent component) {
        ResourceIdManager manager = ResourceIdManager.get(component.getModel().getModule());
        this.updateId(manager, component);
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component.getChildren()) {
                this.updateId(manager, child);
            }
        }
        if ((component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component.getChildren()) {
                this.updateId(manager, child);
            }
        }
    }

    private void updateId(@NotNull ResourceIdManager manager, @NotNull NlComponent component) {
        ViewInfo view;
        String id = component.getId();
        ResourceReference reference2 = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, id);
        Integer resolved = manager.getCompiledId(reference2);
        if (resolved == null && (resolved = Integer.valueOf(manager.getOrGenerateId(reference2))) != null && (view = NlComponentHelperKt.getViewInfo(component)) != null && view.getViewObject() != null) {
            View androidView = (View)view.getViewObject();
            androidView.setId(resolved.intValue());
        }
    }

    @Override
    public void commit(final ComponentModification modification) {
        final NlComponent component = modification.getComponent();
        Project project = component.getModel().getProject();
        String constraintSetId = null;
        SmartPsiElementPointer<XmlTag> constraint = this.myPanel.getSelectedConstraint();
        if (constraint == null) {
            return;
        }
        XmlTag tag = ((XmlTag)constraint.getElement()).getParentTag();
        String id = MotionSceneModel.stripID(tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
        constraintSetId = "@+id/" + id;
        final XmlFile file = this.myPanel.getTransitionFile(component);
        if (file == null) {
            return;
        }
        final String finalConstraintSetId = constraintSetId;
        new WriteCommandAction(project, "Set In Transition", new PsiFile[]{file}){

            protected void run(@NotNull Result result2) throws Throwable {
                XmlTag constraintSet = MotionLayoutComponentDelegate.this.myPanel.getConstraintSet(file, finalConstraintSetId);
                if (constraintSet == null) {
                    return;
                }
                XmlTag constrainedView = MotionLayoutComponentDelegate.this.myPanel.getConstrainView(constraintSet, component.getId());
                if (constrainedView == null) {
                    constrainedView = constraintSet.createChildTag("Constraint", null, null, false);
                    constrainedView = constraintSet.addSubTag(constrainedView, false);
                    String componentId = "@+id/" + component.getId();
                    constrainedView.setAttribute("id", "http://schemas.android.com/apk/res/android", componentId);
                    constrainedView.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", component.getAttributeImpl("http://schemas.android.com/apk/res/android", "layout_width"));
                    constrainedView.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", component.getAttributeImpl("http://schemas.android.com/apk/res/android", "layout_height"));
                    modification.commitTo(constrainedView);
                } else {
                    modification.commitTo(constrainedView);
                }
            }
        }.execute();
        MotionSceneModel.saveAndNotify((PsiFile)file, component.getModel());
        this.clearCache(component);
    }

    @Override
    public void setAttribute(NlComponent component, String namespace, String attribute, String value2) {
        ComponentModification modification = new ComponentModification(component, "Set Attribute " + attribute);
        modification.setAttribute(namespace, attribute, value2);
        modification.commit();
    }
}

