/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.ComponentAssistantViewAction;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.assistant.MotionLayoutAssistantPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutTimelinePanel;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistantFactory;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutHandler
extends ConstraintLayoutHandler
implements NlComponentDelegate {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"showPaths");
    }

    @Nullable
    private static ComponentAssistantFactory getComponentAssistant(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (!((Boolean)StudioFlags.NELE_MOTION_LAYOUT_ANIMATIONS.get()).booleanValue() || !SdkConstants.MOTION_LAYOUT.isEquals(component.getTagName())) {
            return null;
        }
        return context -> new MotionLayoutAssistantPanel(surface, context.getComponent(), context.getDoClose());
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        sceneComponent.setNotchProvider(new ConstraintLayoutNotchProvider());
        return ImmutableList.of((Object)new LassoTarget(), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.LEFT, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.TOP, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.RIGHT, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.BOTTOM, false));
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(component.getNlComponent());
        if (panel2 == null || panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_START || panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_END) {
            super.addPopupMenuActions(component, actions2);
        }
        actions2.add(new ComponentAssistantViewAction((Function1<? super NlComponent, ? extends ComponentAssistantFactory>)((Function1)nlComponent -> MotionLayoutHandler.getComponentAssistant(component.getScene().getDesignSurface(), nlComponent))));
        return false;
    }

    @Override
    public boolean needsAccessoryPanel(@NotNull AccessoryPanel.Type type) {
        switch (type) {
            case SOUTH_PANEL: 
            case EAST_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public AccessoryPanelInterface createAccessoryPanel(@NotNull DesignSurface surface, @NotNull AccessoryPanel.Type type, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility panelVisibility) {
        switch (type) {
            case SOUTH_PANEL: {
                return new MotionLayoutTimelinePanel(surface, parent, panelVisibility);
            }
            case EAST_PANEL: {
                return new MotionLayoutAttributePanel(parent, panelVisibility);
            }
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component) {
        return new MotionLayoutSceneInteraction(screenView, component);
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(childComponent.getNlComponent());
        if (panel2 != null && (panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_PLAY || panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_PAUSE || panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_TRANSITION || panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_UNKNOWN)) {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            listBuilder.add((Object)new ConstraintDragTarget());
            return listBuilder.build();
        }
        return super.createChildTargets(parentComponent, childComponent);
    }

    @Override
    public NlComponentDelegate getNlComponentDelegate() {
        return this;
    }

    public static MotionLayoutTimelinePanel getTimeline(@NotNull NlComponent component) {
        Object property2 = component.getClientProperty("Timeline");
        if (property2 == null && component.getParent() != null) {
            property2 = component.getParent().getClientProperty("Timeline");
        }
        if (property2 == null || !(property2 instanceof MotionLayoutTimelinePanel)) {
            return null;
        }
        return (MotionLayoutTimelinePanel)property2;
    }

    @Override
    public boolean handlesAttribute(@NotNull NlComponent component, @Nullable String namespace, @NotNull String attribute) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(component);
        if (panel2 == null) {
            return false;
        }
        return panel2.getNlComponentDelegate().handlesAttribute(component, namespace, attribute);
    }

    @Override
    public boolean handlesAttributes(NlComponent component) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(component);
        if (panel2 == null) {
            return false;
        }
        return panel2.getNlComponentDelegate().handlesAttributes(component);
    }

    @Override
    public boolean handlesApply(ComponentModification modification) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(modification.getComponent());
        if (panel2 == null) {
            return false;
        }
        return panel2.getNlComponentDelegate().handlesApply(modification);
    }

    @Override
    public boolean handlesCommit(ComponentModification modification) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(modification.getComponent());
        if (panel2 == null) {
            return false;
        }
        return panel2.getNlComponentDelegate().handlesCommit(modification);
    }

    @Override
    public String getAttribute(@NotNull NlComponent component, @Nullable String namespace, @NotNull String attribute) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(component);
        if (panel2 == null) {
            return null;
        }
        return panel2.getNlComponentDelegate().getAttribute(component, namespace, attribute);
    }

    @Override
    public List<AttributeSnapshot> getAttributes(NlComponent component) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(component);
        if (panel2 == null) {
            return Collections.emptyList();
        }
        return panel2.getNlComponentDelegate().getAttributes(component);
    }

    @Override
    public void apply(ComponentModification modification) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(modification.getComponent());
        if (panel2 != null) {
            panel2.getNlComponentDelegate().apply(modification);
        }
    }

    @Override
    public void commit(ComponentModification modification) {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(modification.getComponent());
        if (panel2 != null) {
            panel2.getNlComponentDelegate().commit(modification);
        }
    }

    @Override
    public void setAttribute(NlComponent component, String namespace, String attribute, String value2) {
        ComponentModification modification = new ComponentModification(component, "Set Attribute " + attribute);
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(modification.getComponent());
        if (panel2 != null) {
            modification.setAttribute(namespace, attribute, value2);
            panel2.getNlComponentDelegate().commit(modification);
        }
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public void willRemoveChild(@NotNull NlComponent component) {
    }

    @Override
    public boolean commitToMotionScene(Pair<String, String> key) {
        return false;
    }
}

