/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutTimelinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanelListener;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutTimelineHelper {
    private final AccessoryPanelListener myAccessoryPanelListener = new MyAccessoryPanelListener();
    private final AccessorySelectionListener myTimelineListener;
    private AccessoryPanelInterface myTimeline;
    private NlDesignSurface mySurface;
    private List<NlComponent> mySelection;

    public MotionLayoutTimelineHelper(@NotNull AccessorySelectionListener timelineListener) {
        this.myTimelineListener = timelineListener;
        this.mySelection = Collections.emptyList();
    }

    @NotNull
    public List<NlComponent> getSelection() {
        return this.mySelection;
    }

    @Nullable
    public NlDesignSurface getSurface() {
        return this.mySurface;
    }

    public void setSurface(@Nullable DesignSurface designSurface) {
        NlDesignSurface surface;
        NlDesignSurface nlDesignSurface = surface = designSurface instanceof NlDesignSurface ? (NlDesignSurface)designSurface : null;
        if (surface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.getAccessoryPanel().removeAccessoryPanelListener(this.myAccessoryPanelListener);
            this.setTimeline(null);
        }
        this.mySurface = surface;
        if (this.mySurface != null) {
            this.mySurface.getAccessoryPanel().addAccessoryPanelListener(this.myAccessoryPanelListener);
            this.setTimeline(this.mySurface.getAccessoryPanel().getCurrentPanel());
        }
    }

    private void setTimeline(@Nullable AccessoryPanelInterface timeline) {
        if (!(timeline instanceof GanttEventListener)) {
            timeline = null;
        }
        if (timeline == this.myTimeline) {
            return;
        }
        if (this.myTimeline != null) {
            this.myTimeline.removeListener(this.myTimelineListener);
        }
        this.myTimeline = timeline;
        if (this.myTimeline != null) {
            this.myTimeline.addListener(this.myTimelineListener);
        }
    }

    private class MyAccessoryPanelListener
    implements AccessoryPanelListener {
        private MyAccessoryPanelListener() {
        }

        @Override
        public void panelChange(@Nullable AccessoryPanelInterface panel2) {
            MotionLayoutTimelineHelper.this.setTimeline(panel2);
            MotionLayoutTimelineHelper.this.myTimeline = panel2 instanceof MotionLayoutTimelinePanel ? (MotionLayoutTimelinePanel)panel2 : null;
        }
    }
}

