/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.AttrName;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentDelegate;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttCommands;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MotionLayoutTimelinePanel
implements AccessoryPanelInterface,
GanttEventListener,
ModelListener {
    public static final boolean DEBUG = false;
    private final ViewGroupHandler.AccessoryPanelVisibility myVisibilityCallback;
    private final DesignSurface mySurface;
    private final List<AccessorySelectionListener> myListeners;
    private NlComponent myMotionLayout;
    private MotionLayoutComponentHelper myMotionLayoutComponentHelper;
    private Gantt myPanel;
    private GanttCommands mGanttCommands;
    private Timer myPositionTimer;
    public static boolean myLoopMode;
    public static boolean myDirectionBackward;
    private float myLastPos;
    private NlComponent mySelection;
    MotionLayoutAttributePanel myMotionLayoutAttributePanel;
    private boolean myInStateChange;
    private NlComponentDelegate myNlComponentDelegate = new MotionLayoutComponentDelegate(this);
    private NlModel myModel;
    private MotionSceneModel myMotionSceneModel;
    private Object myLastSelectedAccessory = new Object();
    private State myCurrentState = State.TL_UNKNOWN;
    public static final String TIMELINE = "Timeline";

    public State getCurrentState() {
        return this.myCurrentState;
    }

    public NlComponentDelegate getNlComponentDelegate() {
        return this.myNlComponentDelegate;
    }

    public void setTimelineProgress(float progress) {
        this.myPanel.setProgress(progress);
    }

    public boolean handlesWriteForComponent(String id) {
        SmartPsiElementPointer<XmlTag> constraint = this.getSelectedConstraint();
        if (constraint != null) {
            String constraintId = ((XmlTag)constraint.getElement()).getAttribute("android:id").getValue();
            return id.equals(MotionSceneModel.stripID(constraintId));
        }
        return false;
    }

    public MotionLayoutTimelinePanel(@NotNull DesignSurface surface, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        this.mySurface = surface;
        this.myVisibilityCallback = visibility;
        this.myListeners = new ArrayList<AccessorySelectionListener>();
        this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(parent);
        parent.putClientProperty(TIMELINE, this);
        this.updateModel(parent.getModel());
        this.mySurface.getSelectionModel().addListener((SelectionModel model2, List<NlComponent> selection) -> this.handleSelectionChanged(model2, selection));
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = (Gantt)this.createPanel(AccessoryPanel.Type.SOUTH_PANEL);
        }
        return this.myPanel;
    }

    @Override
    @NotNull
    public JPanel createPanel(AccessoryPanel.Type type) {
        Gantt panel2 = new Gantt(this);
        panel2.setPreferredSize(new Dimension(0, 300));
        return panel2;
    }

    @Nullable
    public MotionSceneModel.KeyFrame getSelectedKeyframe() {
        return this.mySelection != null ? this.myPanel.getSelectedKey(this.mySelection.getId()) : null;
    }

    public MotionSceneModel.ConstraintView getSelectedConstraintView() {
        return this.mySelection != null ? this.myPanel.getSelectedConstraintView(this.mySelection.getId()) : null;
    }

    public SmartPsiElementPointer<XmlTag> getSelectedConstraint() {
        return this.myPanel.getChart().getSelectedConstraint();
    }

    public void clearSelectedKeyframe() {
        this.myPanel.clearSelectedKey();
    }

    @Nullable
    public MotionSceneModel.TransitionTag getTransitionTag() {
        return this.myPanel.getTransitionTag();
    }

    @Nullable
    public MotionSceneModel.OnSwipeTag getOnSwipeTag() {
        return this.myPanel.getOnSwipeTag();
    }

    private void updateModel(@Nullable NlModel model2) {
        if (this.myModel == model2) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        this.myModel = model2;
        if (this.myModel != null) {
            this.myModel.addListener(this);
        }
    }

    private void handleSelectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (this.myPanel != null) {
            this.myPanel.handleSelectionChanged(model2, selection);
        }
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        this.myCurrentState = State.TL_UNKNOWN;
        if (selection.isEmpty()) {
            this.mySelection = null;
            return;
        }
        NlComponent component = selection.get(0);
        if (component != this.mySelection) {
            this.myNlComponentDelegate.clearCaches();
        }
        this.mySelection = component;
        if (!NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT) && (component = component.getParent()) != null && !NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            return;
        }
        if (this.myMotionLayout != component) {
            this.myMotionLayout = component;
            this.updateModel(this.myMotionLayout != null ? this.myMotionLayout.getModel() : null);
            this.loadMotionScene();
        }
        this.updateState();
        this.addDelegate();
        if (this.getSelectedAccessory() == null) {
            this.fireSelectionChanged(selection);
        }
    }

    public void updateState() {
        if (this.myCurrentState == State.TL_UNKNOWN) {
            float position = this.myPanel.getChart().getProgress();
            SceneComponent root = this.mySurface.getScene().getRoot();
            if (root != null) {
                root.updateTargets();
            }
        }
    }

    private void addDelegate() {
        if (this.myMotionLayout == null) {
            return;
        }
        this.myMotionLayout.setDelegate(this.myNlComponentDelegate);
        for (NlComponent child : this.myMotionLayout.getChildren()) {
            child.setDelegate(this.myNlComponentDelegate);
        }
    }

    private void loadMotionScene() {
        if (this.myMotionLayout == null) {
            return;
        }
        String referencedFile = this.myMotionLayout.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (referencedFile != null) {
            this.parseMotionScene(this.myMotionLayout, referencedFile);
        }
        this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
        switch (this.myPanel.getMode()) {
            case START: {
                this.setState(State.TL_START);
                this.setProgress(0.0f);
                break;
            }
            case PLAY: {
                this.setState(State.TL_PLAY);
                myDirectionBackward = false;
                break;
            }
            case PAUSE: {
                this.setState(State.TL_PAUSE);
                myDirectionBackward = false;
                break;
            }
            case TRANSITION: {
                float position = this.myPanel.getChart().getProgress();
                this.setProgress(position);
                break;
            }
            case END: {
                this.setState(State.TL_END);
                this.setProgress(1.0f);
                break;
            }
        }
        MotionSceneModel.KeyFrame keyFrame = this.getSelectedKeyframe();
        if (keyFrame != null) {
            this.setProgress((float)keyFrame.getFramePosition() / 100.0f);
        }
    }

    private void parseMotionScene(@NotNull NlComponent component, @NotNull String file) {
        if (file == null) {
            return;
        }
        int index = file.lastIndexOf("@xml/");
        String fileName = file.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        Project project = component.getModel().getProject();
        AndroidFacet facet = component.getModel().getFacet();
        List<VirtualFile> resourcesXML = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.XML, facet.getAllResourceDirectories());
        if (resourcesXML.isEmpty()) {
            return;
        }
        VirtualFile directory = resourcesXML.get(0);
        VirtualFile virtualFile = directory.findFileByRelativePath(fileName + ".xml");
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
        MotionSceneModel motionSceneModel = MotionSceneModel.parse(component, project, virtualFile, xmlFile);
        this.myPanel.setMotionScene(motionSceneModel);
        this.myMotionSceneModel = motionSceneModel;
    }

    public MotionSceneModel getModel() {
        return this.myMotionSceneModel;
    }

    @Override
    public void deactivate() {
        this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
        this.stopPlaying();
        this.updateModel(null);
        this.myMotionLayout = null;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model2) {
        this.updateAfterModelDerivedDataChanged();
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.loadMotionScene();
            if (this.myMotionLayoutAttributePanel != null) {
                this.myMotionLayoutAttributePanel.updateAfterModelDerivedDataChanged();
            }
        });
    }

    @Override
    public void setProgress(float percent) {
        if (!this.myMotionLayoutComponentHelper.setProgress(percent)) {
            this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
        }
        this.fireSelectionChanged();
    }

    private void setState(State state) {
        if (this.myCurrentState == state || this.myInStateChange) {
            return;
        }
        this.myInStateChange = true;
        switch (state) {
            case TL_START: {
                this.mGanttCommands.setMode(GanttCommands.Mode.START);
                this.stopPlaying();
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
                this.mGanttCommands.setProgress(0.0f);
                break;
            }
            case TL_END: {
                this.mGanttCommands.setMode(GanttCommands.Mode.END);
                this.stopPlaying();
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
                this.mGanttCommands.setProgress(1.0f);
                break;
            }
            case TL_PLAY: {
                this.mGanttCommands.setMode(GanttCommands.Mode.PLAY);
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, true);
                this.startPlaying();
                break;
            }
            case TL_PAUSE: {
                this.stopPlaying();
                this.mGanttCommands.setMode(GanttCommands.Mode.PAUSE);
                break;
            }
            case TL_TRANSITION: {
                this.stopPlaying();
                this.mGanttCommands.setMode(GanttCommands.Mode.TRANSITION);
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, true);
                break;
            }
            case TL_UNKNOWN: {
                this.stopPlaying();
            }
        }
        this.myCurrentState = state;
        this.myInStateChange = false;
        SceneComponent root = this.mySurface.getScene().getRoot();
        if (root != null) {
            root.updateTargets();
        }
    }

    private void startPlaying() {
        int timer_delay_in_ms = 16;
        if (this.myPositionTimer != null) {
            this.myPositionTimer.stop();
        }
        this.myPositionTimer = new Timer(0, e -> {
            float increment = 0.016f;
            if (this.myPanel != null) {
                float speedMultiplier = this.myPanel.getChart().getPlayBackSpeed();
                float timeMs = this.myPanel.getChart().getAnimationTimeInMs();
                increment = speedMultiplier * 16.0f / timeMs;
            }
            float value2 = this.myLastPos + increment;
            if (myDirectionBackward) {
                value2 = this.myLastPos - increment;
                if (value2 < 0.0f) {
                    if (myLoopMode) {
                        value2 = 0.0f;
                        myDirectionBackward = false;
                    } else {
                        value2 = 100.0f;
                    }
                }
            } else if (value2 > 1.0f) {
                if (myLoopMode) {
                    value2 = 1.0f;
                    myDirectionBackward = true;
                } else {
                    value2 = 0.0f;
                }
            }
            this.myLastPos = value2;
            if (!this.myMotionLayoutComponentHelper.setProgress(value2)) {
                this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
            }
            if (this.mGanttCommands != null) {
                this.mGanttCommands.setProgress(value2);
            }
        });
        this.myPositionTimer.setRepeats(true);
        this.myPositionTimer.setDelay(16);
        this.myPositionTimer.start();
    }

    private void stopPlaying() {
        if (this.myCurrentState == State.TL_PLAY && this.myPositionTimer != null) {
            this.myPositionTimer.stop();
        }
    }

    @Override
    @Nullable
    public Object getSelectedAccessory() {
        MotionSceneModel.KeyFrame keyframe = this.getSelectedKeyframe();
        if (keyframe != null) {
            return keyframe.getTag();
        }
        MotionSceneModel.ConstraintView cv = this.getSelectedConstraintView();
        if (cv != null) {
            return cv.getTag();
        }
        return null;
    }

    @Override
    public void addListener(@NotNull AccessorySelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull AccessorySelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void fireSelectionChanged(@NotNull List<NlComponent> components) {
        ArrayList<AccessorySelectionListener> copy = new ArrayList<AccessorySelectionListener>(this.myListeners);
        copy.forEach(listener2 -> listener2.selectionChanged(this, components));
    }

    private void fireSelectionChanged() {
        Object newValue = this.getSelectedAccessory();
        if (this.myLastSelectedAccessory == newValue) {
            return;
        }
        List<NlComponent> selection = this.mySelection != null ? Collections.singletonList(this.mySelection) : Collections.emptyList();
        this.fireSelectionChanged(selection);
        this.myLastSelectedAccessory = newValue;
    }

    @Override
    public void buttonPressed(ActionEvent e, GanttEventListener.Actions action2) {
        switch (action2) {
            case START_ACTION: {
                this.setState(State.TL_START);
                break;
            }
            case END_ACTION: {
                this.setState(State.TL_END);
                break;
            }
            case LOOP_ACTION: {
                myLoopMode = !myLoopMode;
                myDirectionBackward = false;
                if (this.myCurrentState != State.TL_PAUSE) break;
                this.setState(State.TL_PLAY);
                break;
            }
            case PLAY_ACTION: 
            case SLOW_MOTION: {
                if (this.myCurrentState == State.TL_PLAY) {
                    this.setState(State.TL_PAUSE);
                    break;
                }
                this.setState(State.TL_PLAY);
                break;
            }
        }
    }

    @Override
    public void selectionEvent() {
        XmlTag constraintSet;
        String id;
        SmartPsiElementPointer<XmlTag> constraint;
        String selectedElementName;
        if (this.myMotionLayoutAttributePanel != null) {
            this.myMotionLayoutAttributePanel.updateSelection();
        }
        if ((selectedElementName = this.myPanel.getChart().getSelectedKeyView()) != null && this.myMotionLayout != null) {
            List<NlComponent> selection = this.getSelectionFrom(this.myMotionLayout, selectedElementName);
            SwingUtilities.invokeLater(() -> this.mySurface.getSelectionModel().setSelection(selection));
        }
        if ((constraint = this.myPanel.getChart().getSelectedConstraint()) != null && (id = MotionSceneModel.stripID((constraintSet = ((XmlTag)constraint.getElement()).getParentTag()).getAttributeValue("id", "http://schemas.android.com/apk/res/android"))) != null) {
            if (id.equalsIgnoreCase("start")) {
                this.setState(State.TL_START);
            } else if (id.equalsIgnoreCase("end")) {
                this.setState(State.TL_END);
            }
        }
    }

    private List<NlComponent> getSelectionFrom(@NotNull NlComponent component, @NotNull String id) {
        if (id.equals(component.getId())) {
            return Collections.singletonList(component);
        }
        for (NlComponent child : component.getChildren()) {
            if (!id.equals(child.getId())) continue;
            return Collections.singletonList(child);
        }
        return Collections.emptyList();
    }

    @Override
    public void transitionDuration(int duration) {
    }

    @Override
    public void motionLayoutAccess(int cmd, String type, float[] in, int inLength, float[] out, int outLength) {
        this.myMotionLayoutComponentHelper.motionLayoutAccess(cmd, type, null, in, inLength, out, outLength);
    }

    @Override
    public void onInit(GanttCommands commands2) {
        this.mGanttCommands = commands2;
    }

    public void setKeyframeAttribute(@NotNull AttrName attributeName, float value2) {
        MotionSceneModel.KeyFrame keyFrame = this.myPanel.getChart().getSelectedKeyFrame();
        if (keyFrame != null) {
            keyFrame.setValue(attributeName, Float.toString(value2));
        }
    }

    public void setKeyframeAttributes(@NotNull HashMap<AttrName, String> values) {
        MotionSceneModel.KeyFrame keyFrame = this.myPanel.getChart().getSelectedKeyFrame();
        if (keyFrame != null) {
            keyFrame.setValues(values);
        }
    }

    @Nullable
    XmlFile getTransitionFile(@NotNull NlComponent component) {
        if (!(NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT) || (component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT))) {
            return null;
        }
        String file = component.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (file == null) {
            return null;
        }
        int index = file.lastIndexOf("@xml/");
        String fileName = file.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        Project project = component.getModel().getProject();
        AndroidFacet facet = component.getModel().getFacet();
        List<VirtualFile> resourcesXML = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.XML, facet.getAllResourceDirectories());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile directory = resourcesXML.get(0);
        VirtualFile virtualFile = directory.findFileByRelativePath(fileName + ".xml");
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
    }

    @Nullable
    List<XmlTag> getKeyframes(XmlFile file, String componentId) {
        XmlTag[] children = file.getRootTag().findSubTags("KeyFrames");
        ArrayList<XmlTag> found = new ArrayList<XmlTag>();
        for (int i2 = 0; i2 < children.length; ++i2) {
            XmlTag[] keyframes = children[i2].getSubTags();
            for (int j = 0; j < keyframes.length; ++j) {
                XmlTag keyframe = keyframes[j];
                XmlAttribute attribute = keyframe.getAttribute("motion:target");
                if (attribute == null) continue;
                String keyframeTarget = attribute.getValue();
                int index = keyframeTarget.indexOf(47);
                if (index != -1) {
                    keyframeTarget = keyframeTarget.substring(index + 1);
                }
                if (!componentId.equalsIgnoreCase(keyframeTarget)) continue;
                found.add(keyframe);
            }
        }
        return found;
    }

    @Nullable
    XmlTag getConstraintSet(XmlFile file, String constraintSetId) {
        XmlTag[] children = file.getRootTag().findSubTags("ConstraintSet");
        for (int i2 = 0; i2 < children.length; ++i2) {
            XmlAttribute attribute = children[i2].getAttribute("android:id");
            if (attribute == null || !attribute.getValue().equalsIgnoreCase(constraintSetId)) continue;
            return children[i2];
        }
        return null;
    }

    @Nullable
    XmlTag getConstrainView(XmlTag constraintSet, String id) {
        XmlTag[] children = constraintSet.getSubTags();
        for (int i2 = 0; i2 < children.length; ++i2) {
            XmlAttribute attribute = children[i2].getAttribute("android:id");
            if (attribute == null) continue;
            String value2 = attribute.getValue();
            int index = value2.lastIndexOf("id/");
            if ((value2 = value2.substring(index + 3)) == null || !value2.equalsIgnoreCase(id)) continue;
            return children[i2];
        }
        return null;
    }

    public void setInTransition(@NotNull NlComponent component, final boolean inTransition) {
        if (!(NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT) || (component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT))) {
            return;
        }
        NlModel myModel = component.getModel();
        final NlComponent finalComponent = component;
        new WriteCommandAction(myModel.getProject(), "Set In Transition", new PsiFile[]{myModel.getFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                finalComponent.setAttribute("http://schemas.android.com/apk/res-auto", "applyTransition", Boolean.toString(inTransition));
            }
        }.execute();
        NlModel model2 = component.getModel();
        model2.notifyModified(NlModel.ChangeType.EDIT);
    }

    public void setMotionLayoutAttributePanel(MotionLayoutAttributePanel panel2) {
        this.myMotionLayoutAttributePanel = panel2;
    }

    static enum State {
        TL_UNKNOWN,
        TL_START,
        TL_PLAY,
        TL_PAUSE,
        TL_TRANSITION,
        TL_END;

    }
}

