/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.GraphBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EasingCurve
extends GraphBase {
    private static final String STANDARD_CURVE = "cubic(0.4, 0.0, 0.2, 1)";
    private static final String ACCELERATE_CURVE = "cubic(0.4, 0.05, 0.8, 0.7)";
    private static final String DECELERATE_CURVE = "cubic(0.0, 0.0, 0.2, 0.95)";
    private static final String LINEAR_CURVE = "cubic(1, 1, 0, 0)";
    final double[] param = new double[]{0.2, 0.2, 0.8, 0.8};
    private boolean mDown;
    private boolean myOnUpdateNotify = true;
    ArrayList<ActionListener> listeners = new ArrayList();

    public void setOnUpdateNotify(boolean notify) {
        this.myOnUpdateNotify = notify;
    }

    public EasingCurve() {
        this.addMouseMotionListener(new MouseMotionAdapter(){
            Point2D click = new Point2D.Float();

            @Override
            public void mouseDragged(MouseEvent e) {
                EasingCurve.this.screenToGraph(e.getPoint(), this.click);
                if (EasingCurve.this.mDown) {
                    EasingCurve.this.param[2] = Math.min(1.0, Math.max(0.0, this.click.getX()));
                    EasingCurve.this.param[3] = Math.min(1.0, Math.max(0.0, this.click.getY()));
                } else {
                    EasingCurve.this.param[0] = Math.min(1.0, Math.max(0.0, this.click.getX()));
                    EasingCurve.this.param[1] = Math.min(1.0, Math.max(0.0, this.click.getY()));
                }
                EasingCurve.this.notifyListeners();
                EasingCurve.this.setUp(EasingCurve.this.param);
                EasingCurve.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){
            Point2D click = new Point2D.Float();

            @Override
            public void mousePressed(MouseEvent e) {
                EasingCurve.this.screenToGraph(e.getPoint(), this.click);
                if (this.click.distance(EasingCurve.this.param[0], EasingCurve.this.param[1]) > this.click.distance(EasingCurve.this.param[2], EasingCurve.this.param[3])) {
                    EasingCurve.this.mDown = true;
                } else {
                    EasingCurve.this.mDown = false;
                }
            }
        });
        this.setUp(this.param);
    }

    public void setControlPoints(double x1, double y1, double x2, double y2) {
        this.param[0] = x1;
        this.param[1] = y1;
        this.param[2] = x2;
        this.param[3] = y2;
        if (this.myOnUpdateNotify) {
            this.notifyListeners();
        }
        this.setUp(this.param);
        this.repaint();
    }

    public int getComboIndex() {
        if (this.param[0] == 0.2 && this.param[1] == 0.2 && this.param[2] == 0.8 && this.param[3] == 0.8) {
            return 0;
        }
        if (this.param[0] == 0.4 && this.param[1] == 0.0 && this.param[2] == 0.2 && this.param[3] == 1.0) {
            return 1;
        }
        if (this.param[0] == 0.4 && this.param[1] == 0.0 && this.param[2] == 1.0 && this.param[3] == 1.0) {
            return 2;
        }
        if (this.param[0] == 0.0 && this.param[1] == 0.0 && this.param[2] == 0.2 && this.param[3] == 1.0) {
            return 3;
        }
        if (this.param[0] == 0.4 && this.param[1] == 0.0 && this.param[2] == 0.6 && this.param[3] == 1.0) {
            return 4;
        }
        return 5;
    }

    public boolean isNone() {
        return this.param[0] == 0.2 && this.param[1] == 0.2 && this.param[2] == 0.8 && this.param[3] == 0.8;
    }

    public void setControlPoints(String curve) {
        if (!curve.startsWith("cubic")) {
            switch (curve) {
                case "standard": {
                    curve = STANDARD_CURVE;
                    break;
                }
                case "accelerate": {
                    curve = ACCELERATE_CURVE;
                    break;
                }
                case "decelerate": {
                    curve = DECELERATE_CURVE;
                    break;
                }
                case "linear": {
                    curve = LINEAR_CURVE;
                    break;
                }
                default: {
                    System.err.println("non standard curve \"" + curve + "\"");
                }
            }
        }
        if (curve == null) {
            this.setControlPoints(0.2, 0.2, 0.8, 0.8);
        } else {
            int start = curve.indexOf(40);
            int off1 = curve.indexOf(44, start);
            double x1 = Double.parseDouble(curve.substring(start + 1, off1).trim());
            int off2 = curve.indexOf(44, off1 + 1);
            double y1 = Double.parseDouble(curve.substring(off1 + 1, off2).trim());
            int off3 = curve.indexOf(44, off2 + 1);
            double x2 = Double.parseDouble(curve.substring(off2 + 1, off3).trim());
            int end = curve.indexOf(41, off3 + 1);
            double y2 = Double.parseDouble(curve.substring(off3 + 1, end).trim());
            this.setControlPoints(x1, y1, x2, y2);
        }
    }

    public String getControlPoints() {
        DecimalFormat df = new DecimalFormat("##.##");
        return "cubic(" + df.format(this.param[0]) + "," + df.format(this.param[1]) + "," + df.format(this.param[2]) + "," + df.format(this.param[3]) + ")";
    }

    public void addActionListener(ActionListener actionListener2) {
        this.listeners.add(actionListener2);
    }

    public void removeActionListener(ActionListener actionListener2) {
        this.listeners.remove(actionListener2);
    }

    protected void notifyListeners() {
        DecimalFormat df = new DecimalFormat("#.##");
        String cubic = "cubic(" + df.format(this.param[0]) + "," + df.format(this.param[1]) + "," + df.format(this.param[2]) + "," + df.format(this.param[3]) + ")";
        ActionEvent actionEvent = new ActionEvent(this, 0, cubic);
        for (ActionListener listener2 : this.listeners) {
            listener2.actionPerformed(actionEvent);
        }
    }

    static double[][] cubic(double x1, double y1, double x2, double y2) {
        double[][] ret = new double[100][2];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            double t = (double)i2 / (double)(ret.length - 1);
            double f0 = (1.0 - t) * (1.0 - t) * (1.0 - t);
            double f1 = 3.0 * (1.0 - t) * (1.0 - t) * t;
            double f2 = 3.0 * (1.0 - t) * t * t;
            double f3 = t * t * t;
            double x = x1 * f1 + x2 * f2 + f3;
            double y = y1 * f1 + y2 * f2 + f3;
            ret[i2][0] = x;
            ret[i2][1] = y;
        }
        return ret;
    }

    public void setUp(double[] param) {
        double[][] points = new double[][]{{0.0, 0.0}, {param[0], param[1]}, {param[2], param[3]}, {1.0, 1.0}};
        double[][] curve = EasingCurve.cubic(param[0], param[1], param[2], param[3]);
        double[] fitX = new double[curve.length];
        double[] fitY = new double[curve.length];
        for (int i2 = 0; i2 < fitY.length; ++i2) {
            fitX[i2] = curve[i2][0];
            fitY[i2] = curve[i2][1];
        }
        this.addGraph(1, points, (Color)EditorUtils.ourEasingControlsColor, 1);
        CubicInterpolator interpolator = new CubicInterpolator(param[0], param[1], param[2], param[3]);
        double[][] fit2 = new double[100][2];
        for (int i3 = 0; i3 < fit2.length; ++i3) {
            fit2[i3][0] = (double)i3 / (double)(fit2.length - 1);
            fit2[i3][1] = interpolator.get(fit2[i3][0]);
        }
        this.addGraph(0, fit2, (Color)EditorUtils.ourEasingGraphColor, 0);
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame("test panel");
        f.setBounds(new Rectangle(200, 200));
        f.setDefaultCloseOperation(3);
        JPanel base = new JPanel(new BorderLayout());
        JPanel ctl = new JPanel();
        base.add((Component)ctl, "South");
        JLabel button2 = new JLabel("Save...");
        EasingCurve p = new EasingCurve();
        ctl.add(button2);
        base.add(p);
        p.addActionListener(e -> button2.setText(e.getActionCommand()));
        f.setContentPane(base);
        f.validate();
        f.setVisible(true);
    }

    static class CubicInterpolator {
        private static double error = 0.01;
        double x1;
        double y1;
        double x2;
        double y2;

        public CubicInterpolator(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        private double getX(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.x1 * f1 + this.x2 * f2 + f3;
        }

        private double getY(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.y1 * f1 + this.y2 * f2 + f3;
        }

        private double getDiffX(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.x1 + 6.0 * t1 * t * (this.x2 - this.x1) + 3.0 * t * t * (1.0 - this.x2);
        }

        private double getDiffY(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.y1 + 6.0 * t1 * t * (this.y2 - this.y1) + 3.0 * t * t * (1.0 - this.y2);
        }

        public double getDiff(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            double t = 0.5;
            double range = 0.5;
            while (range > error) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getDiffY(t - range);
            double y2 = this.getDiffY(t + range);
            return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        }

        public double get(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            double t = 0.5;
            double range = 0.5;
            while (range > error) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        }
    }
}

