/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.AttrName;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.TagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TransitionPanel
extends TagPanel {
    private Vector<String> colNames = new Vector<String>(Arrays.asList("Name", "Value"));
    private Vector<Vector<Object>> data = new Vector();
    private DefaultTableModel myTableModel = new TransitionTableModel(this.data, this.colNames);
    private MotionSceneModel.TransitionTag myTag;
    private JBPopupMenu myPopupMenu = new JBPopupMenu("Add Attribute");
    private static final String ATTR_ATTRIBUTE_NAME = "AttributeName";
    public ActionListener myAddItemAction = new ActionListener(){

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            JMenuItem menu = (JMenuItem)event.getSource();
            AttrName attributeName = (AttrName)menu.getClientProperty(TransitionPanel.ATTR_ATTRIBUTE_NAME);
            String value2 = "";
            if (TransitionPanel.this.myTag == null || !TransitionPanel.this.myTag.setValue(attributeName, value2)) {
                return;
            }
            TransitionPanel.this.myTableModel.addRow(new Object[]{attributeName, value2});
        }
    };

    public TransitionPanel(MotionLayoutAttributePanel panel2) {
        super(panel2);
        this.myTitle.setText("Transition");
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.setup();
        this.myTable.setSelectionMode(0);
        this.myTable.setDefaultRenderer(EditorUtils.AttributesNamesHolder.class, new EditorUtils.AttributesNamesCellRenderer());
        this.myTable.setDefaultRenderer(String.class, new EditorUtils.AttributesValueCellRenderer());
        this.myTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    c.setForeground((Color)(column > 0 ? EditorUtils.ourValueColor : EditorUtils.ourNameColor));
                }
                return c;
            }
        });
        this.myPopupMenu.add(new JMenuItem("place holder"));
        this.myAddRemovePanel.myAddButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TransitionPanel.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        this.add((Component)this.myTitle, gbc);
        ++gbc.gridy;
        this.add((Component)this.myTable, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.myAddRemovePanel, gbc);
    }

    private void setupPopup(MotionSceneModel.TransitionTag tag) {
        this.myPopupMenu.removeAll();
        AttrName[] names = tag.getPossibleAttr();
        Set<AttrName> keys = tag.getAttributes().keySet();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (keys.contains(names[i2])) continue;
            JMenuItem menuItem = new JMenuItem(names[i2].getName());
            menuItem.putClientProperty(ATTR_ATTRIBUTE_NAME, names[i2]);
            menuItem.addActionListener(this.myAddItemAction);
            this.myPopupMenu.add(menuItem);
        }
    }

    @Override
    protected void deleteAttr(int selection) {
        AttrName attributeName = (AttrName)this.myTable.getValueAt(selection, 0);
        if (this.myTag == null || !this.myTag.deleteAttribute(attributeName)) {
            return;
        }
        this.myTableModel.removeRow(selection);
    }

    public void setTransitionTag(MotionSceneModel.TransitionTag tag) {
        this.myTag = tag;
        if (tag == null) {
            return;
        }
        HashMap<AttrName, Object> attr = tag.getAttributes();
        this.data.clear();
        for (AttrName s : attr.keySet()) {
            Vector<Object> v = new Vector<Object>(Arrays.asList(s, attr.get(s)));
            this.data.add(v);
        }
        this.myTableModel.fireTableDataChanged();
        this.setupPopup(tag);
    }

    private class TransitionTableModel
    extends DefaultTableModel {
        private TransitionTableModel(@NotNull Vector data, Vector columnNames) {
            super(data, columnNames);
        }

        @Override
        public void setValueAt(@NotNull Object value2, int rowIndex, int columnIndex) {
            super.setValueAt(value2, rowIndex, columnIndex);
            AttrName key = (AttrName)this.getValueAt(rowIndex, 0);
            TransitionPanel.this.myTag.setValue(key, (String)value2);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

