/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.property2.NelePropertiesModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesModel
extends NelePropertiesModel {
    public MotionLayoutAttributesModel(@NotNull Disposable parentDisposable, @NotNull AndroidFacet facet) {
        super(parentDisposable, new MotionLayoutPropertyProvider(facet), facet, false);
    }

    @Override
    @Nullable
    public String getPropertyValue(@NotNull NelePropertyItem property2) {
        XmlTag tag = MotionLayoutAttributesModel.getTag(property2);
        if (tag == null) {
            return null;
        }
        NlComponent component = MotionLayoutAttributesModel.getComponent(property2);
        if (component == null) {
            return null;
        }
        NlComponentDelegate delegate = component.getDelegate();
        if (delegate != null && delegate.handlesAttribute(component, property2.getNamespace(), property2.getName())) {
            return component.getLiveAttribute(property2.getNamespace(), property2.getName());
        }
        if (tag.getLocalName().equals("CustomAttribute")) {
            return tag.getAttributeValue(MotionLayoutPropertyProvider.mapToCustomType(property2.getType()), "http://schemas.android.com/apk/res-auto");
        }
        return tag.getAttributeValue(property2.getName(), property2.getNamespace());
    }

    @Override
    public void setPropertyValue(@NotNull NelePropertyItem property2, @Nullable String newValue) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TransactionGuard.submitTransaction((Disposable)this, () -> {
            XmlTag tag = MotionLayoutAttributesModel.getTag(property2);
            NlComponent component = MotionLayoutAttributesModel.getComponent(property2);
            if (tag != null && component != null) {
                WriteCommandAction.runWriteCommandAction((Project)this.getFacet().getModule().getProject(), (String)"Set $componentName.$name to $newValue", null, () -> MotionLayoutAttributesModel.setPropertyValue(tag, component, property2, newValue), (PsiFile[])new PsiFile[0]);
            }
        });
    }

    @Nullable
    private static NlComponent getComponent(@NotNull NelePropertyItem property2) {
        List<NlComponent> components = property2.getComponents();
        return components.isEmpty() ? null : components.get(0);
    }

    private static void setPropertyValue(@NotNull XmlTag tag, @NotNull NlComponent component, @NotNull NelePropertyItem property2, @Nullable String newValue) {
        NlComponentDelegate delegate = component.getDelegate();
        component.clearTransaction();
        if (delegate != null && delegate.handlesAttribute(component, property2.getNamespace(), property2.getName())) {
            component.setAttribute(property2.getNamespace(), property2.getName(), newValue);
            return;
        }
        if (tag.getLocalName().equals("CustomAttribute")) {
            tag.setAttribute(MotionLayoutPropertyProvider.mapToCustomType(property2.getType()), "http://schemas.android.com/apk/res-auto", newValue);
        } else {
            tag.setAttribute(property2.getName(), property2.getNamespace(), newValue);
        }
        MotionSceneModel.saveAndNotify(tag.getContainingFile(), property2.getComponents().get(0).getModel());
    }

    public void createCustomXmlTag(@NotNull XmlTag keyFrameOrConstraint, @NotNull String attrName, @NotNull String value2, @NotNull MotionSceneModel.CustomAttributes.Type type, @NotNull Consumer<XmlTag> operation) {
        List oldTags = Arrays.stream(keyFrameOrConstraint.findSubTags("CustomAttribute")).filter(tag -> attrName.equals(tag.getAttribute("attributeName", "http://schemas.android.com/apk/res-auto"))).collect(Collectors.toList());
        Runnable transaction = () -> {
            oldTags.forEach(tag -> tag.delete());
            XmlTag createdTag = keyFrameOrConstraint.createChildTag("CustomAttribute", null, null, false);
            createdTag = keyFrameOrConstraint.addSubTag(createdTag, false);
            createdTag.setAttribute("attributeName", "http://schemas.android.com/apk/res-auto", attrName);
            createdTag.setAttribute(type.getTagName(), "http://schemas.android.com/apk/res-auto", StringUtil.isNotEmpty((String)value2) ? value2 : type.getDefaultValue());
            operation.accept(createdTag);
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        TransactionGuard.submitTransaction((Disposable)this, () -> WriteCommandAction.runWriteCommandAction((Project)this.getFacet().getModule().getProject(), (String)"Set $componentName.$name to $newValue", null, (Runnable)transaction, (PsiFile[])new PsiFile[]{keyFrameOrConstraint.getContainingFile()}));
    }

    public void deleteTag(@NotNull XmlTag tag, @NotNull Runnable operation) {
        PsiFile file = tag.getContainingFile();
        Runnable transaction = () -> {
            tag.delete();
            operation.run();
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        TransactionGuard.submitTransaction((Disposable)this, () -> WriteCommandAction.runWriteCommandAction((Project)this.getFacet().getModule().getProject(), (String)"Set $componentName.$name to $newValue", null, (Runnable)transaction, (PsiFile[])new PsiFile[]{file}));
    }

    @Override
    protected boolean wantComponentSelectionUpdate(@Nullable DesignSurface surface, @Nullable DesignSurface activeSurface, @Nullable AccessoryPanelInterface activePanel) {
        return false;
    }

    @Override
    protected boolean wantPanelSelectionUpdate(@NotNull AccessoryPanelInterface panel2, @Nullable AccessoryPanelInterface activePanel) {
        return panel2 == activePanel && panel2.getSelectedAccessory() != null && panel2 instanceof GanttEventListener;
    }

    @Nullable
    public static XmlTag getTag(@NotNull NelePropertyItem property2) {
        SmartPsiElementPointer tagPointer = (SmartPsiElementPointer)property2.getOptionalValue();
        if (tagPointer == null) {
            return null;
        }
        return (XmlTag)tagPointer.getElement();
    }
}

