/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.AddMotionFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteCustomFieldAction;
import com.android.tools.idea.uibuilder.handlers.motion.property2.action.DeleteMotionFieldAction;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.model.SelectedComponentModel;
import com.android.tools.idea.uibuilder.property2.support.NeleEnumSupportProvider;
import com.android.tools.idea.uibuilder.property2.support.NeleTwoStateBooleanControlTypeProvider;
import com.android.tools.idea.uibuilder.property2.ui.SelectedComponentPanel;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.FilteredPTableModel;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertiesView;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesView
extends PropertiesView<NelePropertyItem> {
    private static final String MOTION_VIEW_NAME = "Motion";

    public MotionLayoutAttributesView(@NotNull MotionLayoutAttributesModel model2) {
        super(MOTION_VIEW_NAME, model2);
        NeleEnumSupportProvider enumSupportProvider2 = new NeleEnumSupportProvider(model2);
        NeleTwoStateBooleanControlTypeProvider controlTypeProvider2 = new NeleTwoStateBooleanControlTypeProvider(enumSupportProvider2);
        EditorProvider<NelePropertyItem> editorProvider = EditorProvider.Companion.create(enumSupportProvider2, controlTypeProvider2);
        TableUIProvider tableUIProvider = TableUIProvider.Companion.create(NelePropertyItem.class, controlTypeProvider2, editorProvider);
        this.getMain().getBuilders().add(new SelectedTargetBuilder());
        this.addTab("").getBuilders().add(new MotionInspectorBuilder(model2, editorProvider, tableUIProvider));
    }

    private static class MotionInspectorBuilder
    implements InspectorBuilder<NelePropertyItem> {
        private final MotionLayoutAttributesModel myModel;
        private final EditorProvider<NelePropertyItem> myEditorProvider;
        private final TableUIProvider myTableUIProvider;
        private final CustomPanel myCustomLayoutPanel;
        private final XmlElementDescriptorProvider myDescriptorProvider;

        private MotionInspectorBuilder(@NotNull MotionLayoutAttributesModel model2, @NotNull EditorProvider<NelePropertyItem> editorProvider, @NotNull TableUIProvider tableUIProvider) {
            this.myModel = model2;
            this.myEditorProvider = editorProvider;
            this.myTableUIProvider = tableUIProvider;
            this.myCustomLayoutPanel = MotionInspectorBuilder.loadCustomLayoutPanel(model2.getFacet());
            this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NelePropertyItem> properties) {
            String label;
            NelePropertyItem any = properties.getFirst();
            if (any == null) {
                return;
            }
            XmlTag tag = MotionLayoutAttributesModel.getTag(any);
            if (tag == null) {
                return;
            }
            NlComponent component = any.getComponents().get(0);
            switch (label = tag.getLocalName()) {
                case "Constraint": {
                    NelePropertyItem targetId = properties.getOrNull("http://schemas.android.com/apk/res/android", "id");
                    label = "ConstraintSet";
                    DesignSurface surface = targetId == null ? null : targetId.getModel().getSurface();
                    this.addCustomLayoutComponent(inspector, component, surface);
                    this.addPropertyTable(inspector, label, properties, targetId);
                    break;
                }
                case "Transition": {
                    this.addPropertyTable(inspector, label, properties, new NelePropertyItem[0]);
                    break;
                }
                default: {
                    NelePropertyItem target = properties.getOrNull("http://schemas.android.com/apk/res-auto", "target");
                    NelePropertyItem position = properties.getOrNull("http://schemas.android.com/apk/res-auto", "framePosition");
                    if (target == null || position == null) {
                        Logger.getInstance(NelePropertyItem.class).warn("KeyFrame without target and position");
                        return;
                    }
                    inspector.addEditor(this.myEditorProvider.createEditor(position, false), null);
                    this.addPropertyTable(inspector, label, properties, target, position);
                    this.addEasingCurveComponent(inspector, component, target.getModel().getSurface());
                }
            }
            if (this.hasCustomAttributes(tag)) {
                this.addCustomAttributes(inspector, properties);
            }
        }

        @Nullable
        private static CustomPanel loadCustomLayoutPanel(@NotNull AndroidFacet facet) {
            ViewHandlerManager manager = ViewHandlerManager.get(facet);
            ViewHandler handler = manager.getHandler(SdkConstants.MOTION_LAYOUT.newName());
            return handler != null ? handler.getLayoutCustomPanel() : null;
        }

        private void addEasingCurveComponent(@NotNull InspectorPanel inspector, @NotNull NlComponent component, @Nullable DesignSurface surface) {
            String parentTag;
            NlComponent parent = component.getParent();
            String string = parentTag = parent != null ? parent.getTagName() : null;
            if (this.myCustomLayoutPanel != null && SdkConstants.MOTION_LAYOUT.isEquals(parentTag)) {
                InspectorLineModel title = inspector.addExpandableTitle("Easing Curve", true, new AnAction[0]);
                this.myCustomLayoutPanel.useComponent(component, surface);
                inspector.addComponent(this.myCustomLayoutPanel.getPanel(), title);
            }
        }

        private void addCustomLayoutComponent(@NotNull InspectorPanel inspector, @NotNull NlComponent component, @Nullable DesignSurface surface) {
            String parentTag;
            NlComponent parent = component.getParent();
            String string = parentTag = parent != null ? parent.getTagName() : null;
            if (this.myCustomLayoutPanel != null && SdkConstants.MOTION_LAYOUT.isEquals(parentTag)) {
                InspectorLineModel title = inspector.addExpandableTitle("layout", true, new AnAction[0]);
                this.myCustomLayoutPanel.useComponent(component, surface);
                inspector.addComponent(this.myCustomLayoutPanel.getPanel(), title);
            }
        }

        private void addCustomAttributes(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<? extends NelePropertyItem> properties) {
            NelePropertyItem property2 = properties.getValues().stream().filter(item -> !item.getNamespace().isEmpty()).findFirst().orElse(null);
            if (property2 == null) {
                return;
            }
            Function1 filter2 = item -> item.getNamespace().isEmpty();
            FilteredPTableModel<NelePropertyItem> tableModel = FilteredPTableModel.PTableModelFactory.create(this.myModel, filter2, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), false, true);
            AddCustomFieldAction addFieldAction = new AddCustomFieldAction(tableModel, property2);
            DeleteCustomFieldAction deleteFieldAction = new DeleteCustomFieldAction(tableModel);
            InspectorLineModel title = inspector.addExpandableTitle("CustomAttributes", true, addFieldAction, deleteFieldAction);
            TableLineModel lineModel = inspector.addTable(tableModel, true, this.myTableUIProvider, title);
            deleteFieldAction.setLineModel(lineModel);
        }

        private void addPropertyTable(@NotNull InspectorPanel inspector, @NotNull String titleName, @NotNull PropertiesTable<NelePropertyItem> properties, NelePropertyItem ... excluded) {
            Function1 filter2 = item -> !item.getNamespace().isEmpty() && ArrayUtil.find((Object[])excluded, (Object)item) < 0 && item.getRawValue() != null;
            FilteredPTableModel<NelePropertyItem> tableModel = FilteredPTableModel.PTableModelFactory.create(this.myModel, filter2, FilteredPTableModel.PTableModelFactory.getAlphabeticalSortOrder(), Collections.emptyList(), true, true);
            AddMotionFieldAction addFieldAction = new AddMotionFieldAction(this.myModel, tableModel, properties);
            DeleteMotionFieldAction deleteFieldAction = new DeleteMotionFieldAction(tableModel);
            InspectorLineModel title = inspector.addExpandableTitle(titleName, true, addFieldAction, deleteFieldAction);
            TableLineModel lineModel = inspector.addTable(tableModel, true, this.myTableUIProvider, title);
            addFieldAction.setLineModel(lineModel);
            deleteFieldAction.setLineModel(lineModel);
        }

        private boolean hasCustomAttributes(@NotNull XmlTag tag) {
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return false;
            }
            for (XmlElementDescriptor childDescriptor : elementDescriptor.getElementsDescriptors(tag)) {
                if (!childDescriptor.getDefaultName().equals("CustomAttribute")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void resetCache() {
        }
    }

    private static class SelectedTargetBuilder
    implements InspectorBuilder<NelePropertyItem> {
        private SelectedTargetBuilder() {
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NelePropertyItem> properties) {
            NelePropertyItem any = properties.getFirst();
            if (any == null || any.getComponents().isEmpty()) {
                return;
            }
            NelePropertyItem id = properties.getOrNull("http://schemas.android.com/apk/res/android", "id");
            NlComponent component = any.getComponents().get(0);
            XmlTag tag = MotionLayoutAttributesModel.getTag(any);
            if (tag == null) {
                return;
            }
            String label = tag.getLocalName();
            inspector.addComponent((JComponent)((Object)new SelectedComponentPanel(new SelectedComponentModel(id, Collections.singletonList(component), label))), null);
        }

        @Override
        public void resetCache() {
        }
    }
}

