/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.MotionSceneString;
import com.android.tools.idea.uibuilder.property2.NeleFlagsPropertyItem;
import com.android.tools.idea.uibuilder.property2.NeleIdPropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertiesModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertyType;
import com.android.tools.idea.uibuilder.property2.PropertiesProvider;
import com.android.tools.idea.uibuilder.property2.support.TypeResolver;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutPropertyProvider
implements PropertiesProvider {
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final XmlElementDescriptorProvider myDescriptorProvider;
    private final Table<String, String, NelePropertyItem> myEmptyTable;
    private static final int EXPECTED_ROWS = 3;
    private static final int EXPECTED_CELLS_PER_ROW = 10;

    public MotionLayoutPropertyProvider(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        this.myProject = facet.getModule().getProject();
        this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        this.myEmptyTable = ImmutableTable.of();
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> getProperties(@NotNull NelePropertiesModel model2, @Nullable Object optionalValue, @NotNull List<? extends NlComponent> components) {
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        SmartPsiElementPointer tagPointer = (SmartPsiElementPointer)optionalValue;
        if (tagPointer == null) {
            return PropertiesTable.Companion.emptyTable();
        }
        return (PropertiesTable)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> PropertiesTable.Companion.create(this.getPropertiesImpl(model2, (SmartPsiElementPointer<XmlTag>)tagPointer, components)));
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> createEmptyTable() {
        return PropertiesTable.Companion.create(HashBasedTable.create((int)3, (int)10));
    }

    private Table<String, String, NelePropertyItem> getPropertiesImpl(@NotNull NelePropertiesModel model2, @Nullable SmartPsiElementPointer<XmlTag> tagPointer, @NotNull List<? extends NlComponent> components) {
        if (tagPointer == null || components.isEmpty()) {
            return this.myEmptyTable;
        }
        XmlTag tag = (XmlTag)tagPointer.getElement();
        if (tag == null) {
            return this.myEmptyTable;
        }
        if (tag.getLocalName().equals("ConstraintSet")) {
            if ((tag = MotionLayoutPropertyProvider.findConstraint(tag, components.get(0))) == null) {
                return this.myEmptyTable;
            }
            tagPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)tag);
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(this.myFacet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(MotionLayoutPropertyProvider.class).error("No system resource manager for module: " + this.myFacet.getModule().getName());
            return this.myEmptyTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
        if (elementDescriptor == null) {
            return this.myEmptyTable;
        }
        XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
        for (XmlAttributeDescriptor xmlAttributeDescriptor : descriptors) {
            String namespaceUri = MotionLayoutPropertyProvider.getNamespace(xmlAttributeDescriptor, tag);
            String name = xmlAttributeDescriptor.getName();
            AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android" == namespaceUri ? systemAttrDefs : localAttrDefs;
            ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
            AttributeDefinition attrDef = namespace != null && attrDefs != null ? attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)name)) : null;
            NelePropertyItem property2 = MotionLayoutPropertyProvider.createProperty(namespaceUri, name, attrDef, model2, (SmartPsiElementPointer<XmlTag>)tagPointer, components);
            properties.put((Object)namespaceUri, (Object)name, (Object)property2);
        }
        block1: for (XmlAttributeDescriptor xmlAttributeDescriptor : tag.findSubTags("CustomAttribute")) {
            String name = xmlAttributeDescriptor.getAttributeValue("attributeName", "http://schemas.android.com/apk/res-auto");
            if (name == null) continue;
            for (String customType : MotionSceneString.CustomAttributes_types) {
                String customValue = xmlAttributeDescriptor.getAttributeValue(customType, "http://schemas.android.com/apk/res-auto");
                if (customValue == null) continue;
                properties.put((Object)"", (Object)name, (Object)MotionLayoutPropertyProvider.createCustomProperty(name, customType, (XmlTag)xmlAttributeDescriptor, model2, components));
                continue block1;
            }
        }
        return properties;
    }

    public static NelePropertyItem createCustomProperty(@NotNull String name, @NotNull String customType, @NotNull XmlTag customTag, @NotNull NelePropertiesModel model2, @NotNull List<? extends NlComponent> components) {
        NelePropertyType type = MotionLayoutPropertyProvider.mapFromCustomType(customType);
        SmartPsiElementPointer tagPointer = SmartPointerManager.getInstance((Project)model2.getProject()).createSmartPsiElementPointer((PsiElement)customTag);
        return new NelePropertyItem("", name, type, null, "", "", model2, tagPointer, components);
    }

    private static NelePropertyItem createProperty(@NotNull String namespace, @NotNull String name, @Nullable AttributeDefinition attr, @NotNull NelePropertiesModel model2, @NotNull SmartPsiElementPointer<XmlTag> tagPointer, @NotNull List<? extends NlComponent> components) {
        NelePropertyType type = TypeResolver.INSTANCE.resolveType(name, attr);
        String libraryName = StringUtil.notNullize((String)(attr != null ? attr.getLibraryName() : null));
        if (namespace == "http://schemas.android.com/apk/res/android" && name == "id") {
            return new NeleIdPropertyItem(model2, attr, "", tagPointer, components);
        }
        if (attr != null && attr.getFormats().contains(AttributeFormat.FLAGS) && attr.getValues().length == 0) {
            return new NeleFlagsPropertyItem(namespace, name, type, attr, "", libraryName, model2, tagPointer, components);
        }
        return new NelePropertyItem(namespace, name, type, attr, "", libraryName, model2, tagPointer, components);
    }

    @Nullable
    private static XmlTag findConstraint(@NotNull XmlTag constraintSet, @NotNull NlComponent component) {
        String id = component.getId();
        if (id == null) {
            return null;
        }
        for (XmlTag constraint : constraintSet.findSubTags("Constraint")) {
            if (!id.equals(NlComponent.stripId(constraint.getAttributeValue("id", "http://schemas.android.com/apk/res/android")))) continue;
            return constraint;
        }
        return null;
    }

    @NotNull
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor2, @NotNull XmlTag context) {
        String namespace = null;
        if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(context);
        }
        return namespace != null ? namespace : "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    static NelePropertyType mapFromCustomType(@NotNull String customType) {
        switch (customType) {
            case "customColorValue": {
                return NelePropertyType.COLOR;
            }
            case "customIntegerValue": {
                return NelePropertyType.INTEGER;
            }
            case "customFloatValue": {
                return NelePropertyType.FLOAT;
            }
            case "customStringValue": {
                return NelePropertyType.STRING;
            }
            case "customDimension": {
                return NelePropertyType.DIMENSION;
            }
            case "customBoolean": {
                return NelePropertyType.BOOLEAN;
            }
        }
        return NelePropertyType.STRING;
    }

    @NotNull
    static String mapToCustomType(@NotNull NelePropertyType type) {
        switch (type) {
            case COLOR: {
                return "customColorValue";
            }
            case INTEGER: {
                return "customIntegerValue";
            }
            case FLOAT: {
                return "customFloatValue";
            }
            case STRING: {
                return "customStringValue";
            }
            case DIMENSION: {
                return "customDimension";
            }
            case BOOLEAN: {
                return "customBoolean";
            }
        }
        return "customStringValue";
    }
}

