/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2.action;

import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.NewCustomAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.FilteredPTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AddCustomFieldAction
extends AnAction {
    private final FilteredPTableModel<NelePropertyItem> myTableModel;
    private final NelePropertyItem myProperty;
    private final MotionLayoutAttributesModel myModel;

    public AddCustomFieldAction(@NotNull FilteredPTableModel<NelePropertyItem> tableModel, @NotNull NelePropertyItem property2) {
        super(null, "Add Custom Property", AllIcons.General.Add);
        this.myTableModel = tableModel;
        this.myProperty = property2;
        this.myModel = (MotionLayoutAttributesModel)this.myProperty.getModel();
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NewCustomAttributePanel newAttributePanel = new NewCustomAttributePanel();
        newAttributePanel.show();
        if (!newAttributePanel.isOK()) {
            return;
        }
        String attributeName = newAttributePanel.getAttributeName();
        String value2 = newAttributePanel.getInitialValue();
        MotionSceneModel.CustomAttributes.Type type = newAttributePanel.getType();
        if (StringUtil.isEmpty((String)attributeName)) {
            return;
        }
        XmlTag tag = MotionLayoutAttributesModel.getTag(this.myProperty);
        if (tag == null) {
            return;
        }
        Consumer<XmlTag> applyToModel = newCustomTag -> {
            NelePropertyItem newProperty = MotionLayoutPropertyProvider.createCustomProperty(attributeName, type.getTagName(), newCustomTag, this.myProperty.getModel(), this.myProperty.getComponents());
            this.myTableModel.addNewItem(newProperty);
        };
        this.myModel.createCustomXmlTag(tag, attributeName, value2, type, applyToModel);
    }
}

