/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLine;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JLayeredPane;

class ColumnHead
extends TimeLine
implements Gantt.ChartElement {
    JLayeredPane myLayeredPane;
    Chart mChart;
    int[] mXPoints = new int[5];
    int[] mYPoints = new int[5];
    Rectangle2D myRect;
    FontMetrics myFontMetrics;

    ColumnHead(Chart chart) {
        super(chart);
        this.mChart = chart;
        this.update(Gantt.ChartElement.Reason.CONSTRUCTION);
        this.mChart.add(this);
        this.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)1, (int)0));
    }

    private void drawFletching(Graphics g, int framePosition, int x, int y) {
        String string = Integer.toString(framePosition);
        if (this.myFontMetrics == null) {
            this.myFontMetrics = g.getFontMetrics();
            this.myRect = this.myFontMetrics.getMaxCharBounds(g);
        }
        double w = this.myRect.getWidth() / 2.0;
        double h = this.myRect.getHeight() * 1.5;
        this.mXPoints[0] = ++x;
        this.mYPoints[0] = (int)((double)y + h);
        this.mXPoints[1] = (int)((double)x - w);
        this.mYPoints[1] = (int)((double)y + h / 2.0);
        this.mXPoints[2] = (int)((double)x - w);
        this.mYPoints[2] = y;
        this.mXPoints[3] = (int)((double)x + w);
        this.mYPoints[3] = y;
        this.mXPoints[4] = (int)((double)x + w);
        this.mYPoints[4] = (int)((double)y + h / 2.0);
        g.setColor(Chart.getColorForPosition(framePosition));
        g.fillPolygon(this.mXPoints, this.mYPoints, 5);
        g.setColor(this.getBackground());
        g.drawString(string, x - this.myFontMetrics.stringWidth(string) / 2, y + this.myFontMetrics.getAscent());
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Chart.myGridColor);
        this.setForeground(Chart.myGridColor);
        super.paintComponent(g);
        super.paintBorder(g);
        if (!Float.isNaN(this.mChart.getTimeCursorMs())) {
            int h = this.getHeight();
            float time2 = this.mChart.getTimeCursorMs();
            int x = this.mChart.getCursorPosition();
            g.setColor(Chart.getColorForPosition(this.mChart.getFramePosition()));
            g.fillRect(x, h - 15, 1, h);
            this.drawFletching(g, this.mChart.getFramePosition(), x, 0);
        }
    }

    @Override
    public void update(Gantt.ChartElement.Reason reason) {
        this.setGraphWidth(this.mChart.getGraphWidth());
        switch (reason) {
            case CURSOR_POSITION_CHANGED: {
                if (this.mChart.myGantt.myGanttController == null) break;
                this.mChart.myGantt.myGanttController.framePosition(this.mChart.getTimeCursorMs() / (float)this.mChart.myAnimationTotalTimeMs);
                this.repaint();
                break;
            }
            case RESIZE: 
            case ZOOM: {
                Dimension d = this.getPreferredSize();
                d.width = this.mChart.getGraphWidth();
                d.height = Gantt.HEADER_HEIGHT;
                this.setPreferredSize(d);
                this.repaint();
                break;
            }
        }
        super.setInserts(this.mChart.myChartLeftInset, this.mChart.myChartRightInset);
    }
}

